/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.api;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class MultiException
extends RuntimeException {
    private static final long serialVersionUID = 2112432697858621044L;
    private final List<Throwable> throwables = new LinkedList<Throwable>();

    public MultiException() {
    }

    public MultiException(List<Throwable> th) {
        super(th.get(0).getMessage(), th.get(0));
        this.throwables.addAll(th);
    }

    public MultiException(Throwable th) {
        super(th.getMessage(), th);
        this.throwables.add(th);
    }

    public List<Throwable> getErrors() {
        return Collections.unmodifiableList(this.throwables);
    }

    public void addError(Throwable error) {
        this.throwables.add(error);
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("MultiException [" + System.identityHashCode(this) + "] {");
        int lcv = 1;
        for (Throwable th : this.throwables) {
            printWriter.print("\n" + lcv++ + ". ");
            th.printStackTrace(printWriter);
        }
        if (!this.throwables.isEmpty()) {
            printWriter.println();
        }
        printWriter.println("}");
        return stringWriter.toString();
    }
}

