/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.Metadata;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.internal.ConstantActiveDescriptor;
import org.glassfish.hk2.internal.DescriptorBuilderImpl;
import org.glassfish.hk2.internal.IndexedFilterImpl;
import org.glassfish.hk2.internal.SpecificFilterImpl;
import org.glassfish.hk2.internal.StarFilter;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.DescriptorBuilder;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.annotations.Contract;

public class BuilderHelper {
    public static IndexedFilter createContractFilter(String contract) {
        return new IndexedFilterImpl(contract, null);
    }

    public static IndexedFilter createNameFilter(String name) {
        return new IndexedFilterImpl(null, name);
    }

    public static IndexedFilter createNameAndContractFilter(String contract, String name) {
        return new IndexedFilterImpl(contract, name);
    }

    public static IndexedFilter createSpecificDescriptorFilter(ActiveDescriptor<?> descriptor) {
        Set<String> contracts = descriptor.getAdvertisedContracts();
        String contract = null;
        Iterator<String> i$ = contracts.iterator();
        if (i$.hasNext()) {
            String candidate;
            contract = candidate = i$.next();
        }
        String name = descriptor.getName();
        if (descriptor.getServiceId() == null) {
            throw new IllegalArgumentException("The descriptor must have a specific service ID");
        }
        if (descriptor.getLocatorId() == null) {
            throw new IllegalArgumentException("The descriptor must have a specific locator ID");
        }
        return new SpecificFilterImpl(contract, name, descriptor.getServiceId(), descriptor.getLocatorId());
    }

    public static Filter allFilter() {
        return StarFilter.getDescriptorFilter();
    }

    public static DescriptorBuilder link(String implementationClass, boolean addToContracts) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        return new DescriptorBuilderImpl(implementationClass, addToContracts);
    }

    public static DescriptorBuilder link(String implementationClass) throws IllegalArgumentException {
        return BuilderHelper.link(implementationClass, true);
    }

    public static DescriptorBuilder link(Class<?> implementationClass, boolean addToContracts) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        DescriptorBuilder builder = BuilderHelper.link(implementationClass.getName(), addToContracts);
        return builder;
    }

    public static DescriptorBuilder link(Class<?> implementationClass) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        boolean isFactory = Factory.class.isAssignableFrom(implementationClass);
        DescriptorBuilder db = BuilderHelper.link(implementationClass, !isFactory);
        return db;
    }

    public static <T> AbstractActiveDescriptor<T> createConstantDescriptor(T constant) {
        if (constant == null) {
            throw new IllegalArgumentException();
        }
        Annotation scope = ReflectionHelper.getScopeAnnotationFromObject(constant);
        Class scopeClass = scope == null ? PerLookup.class : scope.annotationType();
        Set qualifiers = ReflectionHelper.getQualifiersFromObject(constant);
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        if (scope != null) {
            BuilderHelper.getMetadataValues(scope, metadata);
        }
        for (Annotation qualifier : qualifiers) {
            BuilderHelper.getMetadataValues(qualifier, metadata);
        }
        return new ConstantActiveDescriptor<T>(constant, ReflectionHelper.getAdvertisedTypesFromObject(constant, Contract.class), scopeClass, ReflectionHelper.getName(constant.getClass()), qualifiers, metadata);
    }

    public static DescriptorImpl createDescriptorFromClass(Class<?> clazz) {
        if (clazz == null) {
            return new DescriptorImpl();
        }
        Set contracts = ReflectionHelper.getContractsFromClass(clazz, Contract.class);
        String name = ReflectionHelper.getName(clazz);
        String scope = ReflectionHelper.getScopeFromClass(clazz, PerLookup.class).getName();
        Set qualifiers = ReflectionHelper.getQualifiersFromClass(clazz);
        DescriptorType type = DescriptorType.CLASS;
        if (Factory.class.isAssignableFrom(clazz)) {
            type = DescriptorType.FACTORY;
        }
        return new DescriptorImpl(contracts, name, scope, clazz.getName(), new HashMap<String, List<String>>(), qualifiers, type, null, 0, null, null, null);
    }

    public static DescriptorImpl deepCopyDescriptor(Descriptor copyMe) {
        return new DescriptorImpl(copyMe);
    }

    public static void getMetadataValues(Annotation annotation, Map<String, List<String>> metadata) {
        Method[] annotationMethods;
        if (annotation == null || metadata == null) {
            throw new IllegalArgumentException();
        }
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        for (Method annotationMethod : annotationMethods = annotationClass.getDeclaredMethods()) {
            Object addMe;
            Metadata metadataAnno = annotationMethod.getAnnotation(Metadata.class);
            if (metadataAnno == null) continue;
            String key = metadataAnno.value();
            try {
                addMe = ReflectionHelper.invoke((Object)annotation, (Method)annotationMethod, (Object[])new Object[0]);
            }
            catch (Throwable th) {
                throw new MultiException(th);
            }
            if (addMe == null) continue;
            String addMeString = addMe instanceof Class ? ((Class)addMe).getName() : addMe.toString();
            ReflectionHelper.addMetadata(metadata, (String)key, (String)addMeString);
        }
    }
}

