/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.testing.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.glassfish.hk2.testing.collections.AbstractCollectionTest;
import org.glassfish.hk2.testing.collections.TestCollectionElement;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractListTest
extends AbstractCollectionTest {
    protected boolean doesListIteratorSupportSet() {
        return true;
    }

    protected boolean doesListIteratorSupportAdd() {
        return true;
    }

    protected abstract List createList();

    protected abstract List createList(Collection var1);

    @Override
    protected Collection createCollection() {
        return this.createList();
    }

    @Override
    protected Collection createCollection(Collection input) {
        return this.createList(input);
    }

    private List<?> createEmptyList() {
        if (this.isNullArgumentConstructorSupported()) {
            return this.createList();
        }
        if (this.isCollectionArgumentConstructorSupported()) {
            return this.createList(new LinkedList());
        }
        Assert.fail((String)"Neither null nor Collection constructor is supported by the List implementation");
        return null;
    }

    @Test
    public void testCanAddToAList() {
        List<?> listMe = this.createEmptyList();
        listMe.add(this.getElement("1"));
        Assert.assertEquals((long)1L, (long)listMe.size());
        TestCollectionElement ele = (TestCollectionElement)listMe.get(0);
        Assert.assertEquals((Object)"1", (Object)ele.testCollectionValue());
        Assert.assertFalse((boolean)listMe.isEmpty());
    }

    @Test
    public void testSecondElementIsPutAtEndOfList() {
        List<?> listMe = this.createEmptyList();
        TestCollectionElement ele1 = this.getElement("1");
        TestCollectionElement ele2 = this.getElement("2");
        listMe.add(ele1);
        listMe.add(ele2);
        Assert.assertEquals((long)2L, (long)listMe.size());
        TestCollectionElement returnedEle1 = (TestCollectionElement)listMe.get(0);
        TestCollectionElement returnedEle2 = (TestCollectionElement)listMe.get(1);
        Assert.assertEquals((Object)"1", (Object)returnedEle1.testCollectionValue());
        Assert.assertEquals((Object)"2", (Object)returnedEle2.testCollectionValue());
    }

    @Test
    public void testAddToBeginningOfNonEmptyList() {
        List<?> listMe = this.createEmptyList();
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        listMe.add(two);
        listMe.add(0, one);
        Assert.assertEquals((long)2L, (long)listMe.size());
        Assert.assertEquals((Object)one, listMe.get(0));
        Assert.assertEquals((Object)two, listMe.get(1));
    }

    @Test
    public void testAllElementsOfCollectionInConstructedList() {
        if (!this.isCollectionArgumentConstructorSupported()) {
            return;
        }
        LinkedList<TestCollectionElement> originalList = new LinkedList<TestCollectionElement>();
        originalList.add(this.getElement("1"));
        originalList.add(this.getElement("2"));
        List listUnderTest = this.createList(originalList);
        Assert.assertEquals((long)2L, (long)listUnderTest.size());
        TestCollectionElement returnedEle1 = (TestCollectionElement)listUnderTest.get(0);
        TestCollectionElement returnedEle2 = (TestCollectionElement)listUnderTest.get(1);
        Assert.assertEquals((Object)"1", (Object)returnedEle1.testCollectionValue());
        Assert.assertEquals((Object)"2", (Object)returnedEle2.testCollectionValue());
    }

    @Override
    @Test
    public void testCanCollectionHaveNullElements() {
        if (!this.doesCollectionAllowNullElements()) {
            return;
        }
        List<?> list = this.createEmptyList();
        list.add(null);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertNull(list.get(0));
        Assert.assertTrue((boolean)list.contains(null));
    }

    @Override
    @Test
    public void testCanCollectionHaveNullAndNonNullElements() {
        if (!this.doesCollectionAllowNullElements()) {
            return;
        }
        List<?> list = this.createEmptyList();
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        list.add(null);
        list.add(one);
        list.add(null);
        list.add(two);
        Assert.assertEquals((long)4L, (long)list.size());
        TestCollectionElement returnOne = (TestCollectionElement)list.get(1);
        Assert.assertNotNull((Object)returnOne);
        TestCollectionElement returnTwo = (TestCollectionElement)list.get(3);
        Assert.assertNotNull((Object)returnTwo);
        Assert.assertNull(list.get(0));
        Assert.assertEquals((Object)"1", (Object)returnOne.testCollectionValue());
        Assert.assertNull(list.get(2));
        Assert.assertEquals((Object)"2", (Object)returnTwo.testCollectionValue());
        Assert.assertTrue((boolean)list.contains(null));
        Assert.assertTrue((boolean)list.contains(one));
        Assert.assertTrue((boolean)list.contains(two));
    }

    @Override
    @Test
    public void testMultipleItemIterator() {
        List<?> list = this.createEmptyList();
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        list.add(one);
        list.add(two);
        Iterator<?> iterator = list.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        TestCollectionElement returnedOne = (TestCollectionElement)iterator.next();
        Assert.assertNotNull((Object)returnedOne);
        Assert.assertEquals((Object)"1", (Object)returnedOne.testCollectionValue());
        Assert.assertTrue((boolean)iterator.hasNext());
        TestCollectionElement returnedTwo = (TestCollectionElement)iterator.next();
        Assert.assertNotNull((Object)returnedTwo);
        Assert.assertEquals((Object)"2", (Object)returnedTwo.testCollectionValue());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Override
    @Test
    public void testCollectionToArrayWithCollectionOfMultipleItems() {
        List<?> collection = this.createEmptyList();
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        collection.add(one);
        collection.add(two);
        Object[] cArray = collection.toArray();
        Assert.assertNotNull((Object)cArray);
        Assert.assertEquals((long)2L, (long)cArray.length);
        String firstValue = ((TestCollectionElement)cArray[0]).testCollectionValue();
        String secondValue = ((TestCollectionElement)cArray[1]).testCollectionValue();
        Assert.assertEquals((Object)"1", (Object)firstValue);
        Assert.assertEquals((Object)"2", (Object)secondValue);
    }

    @Test
    public void testAddAllWithIndex() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(four);
        LinkedList<TestCollectionElement> addin = new LinkedList<TestCollectionElement>();
        addin.add(two);
        addin.add(three);
        list.addAll(1, addin);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
        Assert.assertEquals((Object)three, list.get(2));
        Assert.assertEquals((Object)four, list.get(3));
    }

    @Test
    public void testSetWithIndex() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(four);
        list.add(three);
        Assert.assertEquals((Object)four, (Object)list.set(1, two));
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
        Assert.assertEquals((Object)three, list.get(2));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSetWithBadLowIndex() {
        TestCollectionElement one = this.getElement("1");
        List<?> list = this.createEmptyList();
        list.set(-1, one);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSetWithBadHighIndex() {
        TestCollectionElement one = this.getElement("1");
        List<?> list = this.createEmptyList();
        list.set(0, one);
    }

    @Test
    public void testAddWithIndex() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(four);
        list.add(2, three);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
        Assert.assertEquals((Object)three, list.get(2));
        Assert.assertEquals((Object)four, list.get(3));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAddWithBadLowIndexThrows() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(-1, two);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAddWithBadHighIndexThrows() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(2, two);
    }

    @Test
    public void testRemoveWithIndex() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(three);
        list.add(two);
        Assert.assertEquals((Object)three, list.remove(1));
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRemoveWithIndexThrowsOnBadIndex() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(three);
        list.add(two);
        list.remove(3);
    }

    @Test
    public void testIndexOf() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        if (this.doesCollectionSupportDuplicateElements()) {
            list.add(one);
        }
        Assert.assertEquals((long)0L, (long)list.indexOf(one));
        Assert.assertEquals((long)1L, (long)list.indexOf(two));
        Assert.assertEquals((long)-1L, (long)list.indexOf(three));
    }

    @Test
    public void testLastIndexOf() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        if (this.doesCollectionSupportDuplicateElements()) {
            list.add(one);
            Assert.assertEquals((long)2L, (long)list.lastIndexOf(one));
        } else {
            Assert.assertEquals((long)0L, (long)list.lastIndexOf(one));
        }
        Assert.assertEquals((long)1L, (long)list.lastIndexOf(two));
        Assert.assertEquals((long)-1L, (long)list.lastIndexOf(three));
    }

    @Test
    public void testListIteratorOnEmptyList() {
        List<?> list = this.createEmptyList();
        ListIterator<?> li = list.listIterator();
        Assert.assertFalse((boolean)li.hasPrevious());
        Assert.assertFalse((boolean)li.hasNext());
    }

    @Test
    public void testListIteratorForwardAndBack() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator();
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertEquals((long)0L, (long)li.nextIndex());
        Assert.assertEquals((long)-1L, (long)li.previousIndex());
        Assert.assertEquals((Object)one, li.next());
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertEquals((long)1L, (long)li.nextIndex());
        Assert.assertEquals((long)0L, (long)li.previousIndex());
        Assert.assertEquals((Object)two, li.next());
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertEquals((long)2L, (long)li.nextIndex());
        Assert.assertEquals((long)1L, (long)li.previousIndex());
        Assert.assertEquals((Object)three, li.next());
        Assert.assertFalse((boolean)li.hasNext());
        Assert.assertEquals((long)3L, (long)li.nextIndex());
        Assert.assertEquals((long)2L, (long)li.previousIndex());
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertEquals((long)3L, (long)li.nextIndex());
        Assert.assertEquals((long)2L, (long)li.previousIndex());
        Assert.assertEquals((Object)three, li.previous());
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertEquals((long)2L, (long)li.nextIndex());
        Assert.assertEquals((long)1L, (long)li.previousIndex());
        Assert.assertEquals((Object)two, li.previous());
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertEquals((long)1L, (long)li.nextIndex());
        Assert.assertEquals((long)0L, (long)li.previousIndex());
        Assert.assertEquals((Object)one, li.previous());
        Assert.assertFalse((boolean)li.hasPrevious());
        Assert.assertEquals((long)0L, (long)li.nextIndex());
        Assert.assertEquals((long)-1L, (long)li.previousIndex());
    }

    @Test
    public void testListIteratorBackwardAndForward() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator(3);
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertEquals((long)3L, (long)li.nextIndex());
        Assert.assertEquals((long)2L, (long)li.previousIndex());
        Assert.assertEquals((Object)three, li.previous());
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertEquals((long)2L, (long)li.nextIndex());
        Assert.assertEquals((long)1L, (long)li.previousIndex());
        Assert.assertEquals((Object)two, li.previous());
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertEquals((long)1L, (long)li.nextIndex());
        Assert.assertEquals((long)0L, (long)li.previousIndex());
        Assert.assertEquals((Object)one, li.previous());
        Assert.assertFalse((boolean)li.hasPrevious());
        Assert.assertEquals((long)0L, (long)li.nextIndex());
        Assert.assertEquals((long)-1L, (long)li.previousIndex());
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertEquals((long)0L, (long)li.nextIndex());
        Assert.assertEquals((long)-1L, (long)li.previousIndex());
        Assert.assertEquals((Object)one, li.next());
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertEquals((long)1L, (long)li.nextIndex());
        Assert.assertEquals((long)0L, (long)li.previousIndex());
        Assert.assertEquals((Object)two, li.next());
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertEquals((long)2L, (long)li.nextIndex());
        Assert.assertEquals((long)1L, (long)li.previousIndex());
        Assert.assertEquals((Object)three, li.next());
        Assert.assertFalse((boolean)li.hasNext());
        Assert.assertEquals((long)3L, (long)li.nextIndex());
        Assert.assertEquals((long)2L, (long)li.previousIndex());
    }

    @Test
    public void testListIteratorForwardFromMiddle() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator(1);
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertEquals((Object)two, li.next());
    }

    @Test
    public void testListIteratorBackwardFromMiddle() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator(2);
        Assert.assertTrue((boolean)li.hasNext());
        Assert.assertTrue((boolean)li.hasPrevious());
        Assert.assertEquals((Object)two, li.previous());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testListIteratorWithBadIndexLowThrows() {
        List<?> list = this.createEmptyList();
        list.listIterator(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testListIteratorWithBadIndexHighThrows() {
        List<?> list = this.createEmptyList();
        list.listIterator(1);
    }

    @Test(expected=NoSuchElementException.class)
    public void testPreviousGoneTooFar() {
        TestCollectionElement one = this.getElement("1");
        List<?> list = this.createEmptyList();
        list.add(one);
        ListIterator<?> itr = list.listIterator(1);
        itr.previous();
        itr.previous();
    }

    @Test(expected=NoSuchElementException.class)
    public void testPreviousOnEmptyListThrows() {
        List<?> list = this.createEmptyList();
        ListIterator<?> itr = list.listIterator(0);
        itr.previous();
    }

    @Test
    public void testListIteratorRemoveAfterNext() {
        if (!this.doesCollectionsIteratorSupportRemove()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator();
        li.next();
        li.next();
        li.remove();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)three, list.get(1));
    }

    @Test
    public void testListIteratorRemoveAfterPrevious() {
        if (!this.doesCollectionsIteratorSupportRemove()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator(3);
        li.previous();
        li.previous();
        li.remove();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)three, list.get(1));
    }

    @Test(expected=IllegalStateException.class)
    public void testListIteratorThrowsIfNeverMoved() {
        if (!this.doesCollectionsIteratorSupportRemove()) {
            throw new IllegalStateException();
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator(1);
        li.remove();
    }

    @Test
    public void testListIteratorSetAfterNext() {
        if (!this.doesListIteratorSupportSet()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(three);
        ListIterator<?> li = list.listIterator();
        li.next();
        li.next();
        li.set(two);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
    }

    @Test
    public void testListIteratorSetAfterPrevious() {
        if (!this.doesListIteratorSupportSet()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(three);
        list.add(two);
        ListIterator<?> li = list.listIterator(2);
        li.previous();
        li.previous();
        li.set(one);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
    }

    @Test(expected=IllegalStateException.class)
    public void testListIteratorSetThrowsIfNeverMoved() {
        if (!this.doesListIteratorSupportSet()) {
            throw new IllegalStateException();
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator(1);
        li.set(four);
    }

    @Test(expected=IllegalStateException.class)
    public void testListIteratorSetThrowsIfAfterRemove() {
        if (!this.doesListIteratorSupportSet() || !this.doesCollectionsIteratorSupportRemove()) {
            throw new IllegalStateException();
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        ListIterator<?> li = list.listIterator(1);
        li.next();
        li.remove();
        li.set(four);
    }

    @Test(expected=IllegalStateException.class)
    public void testListIteratorSetThrowsIfAfterAdd() {
        if (!this.doesListIteratorSupportSet() || !this.doesListIteratorSupportAdd()) {
            throw new IllegalStateException();
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        TestCollectionElement five = this.getElement("5");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(four);
        ListIterator<?> li = list.listIterator();
        li.next();
        li.next();
        li.add(three);
        li.set(five);
    }

    @Test
    public void testListIteratorAddAfterNext() {
        if (!this.doesListIteratorSupportAdd()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(three);
        ListIterator<?> li = list.listIterator();
        li.next();
        li.add(two);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
        Assert.assertEquals((Object)three, list.get(2));
    }

    @Test
    public void testListIteratorAddAfterPrevious() {
        if (!this.doesListIteratorSupportAdd()) {
            return;
        }
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(three);
        ListIterator<?> li = list.listIterator(2);
        li.previous();
        li.add(two);
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)two, list.get(1));
        Assert.assertEquals((Object)three, list.get(2));
    }

    @Test
    public void testSubList() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        list.add(four);
        List<?> subList = list.subList(1, 3);
        Assert.assertEquals((long)2L, (long)subList.size());
        Assert.assertEquals((Object)two, subList.get(0));
        Assert.assertEquals((Object)three, subList.get(1));
        Assert.assertTrue((boolean)subList.contains(two));
        Assert.assertTrue((boolean)subList.contains(three));
        Assert.assertFalse((boolean)subList.contains(one));
        Assert.assertFalse((boolean)subList.contains(four));
    }

    @Test
    public void testSubListAffectsUnderlyingList() {
        TestCollectionElement one = this.getElement("1");
        TestCollectionElement two = this.getElement("2");
        TestCollectionElement three = this.getElement("3");
        TestCollectionElement four = this.getElement("4");
        List<?> list = this.createEmptyList();
        list.add(one);
        list.add(two);
        list.add(three);
        list.add(four);
        list.subList(1, 3).clear();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)one, list.get(0));
        Assert.assertEquals((Object)four, list.get(1));
    }
}

