/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.testing.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.glassfish.hk2.testing.collections.DefaultTestCollectionElement;
import org.glassfish.hk2.testing.collections.TestCollectionElement;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractCollectionTest {
    protected static final String ONE = "1";
    protected static final String TWO = "2";
    protected static final String THREE = "3";
    protected static final String FOUR = "4";
    protected static final String FIVE = "5";
    private TestCollectionElement ONE_CE;
    private TestCollectionElement TWO_CE;
    private TestCollectionElement THREE_CE;

    protected boolean isNullArgumentConstructorSupported() {
        return true;
    }

    protected boolean isCollectionArgumentConstructorSupported() {
        return true;
    }

    protected boolean doesCollectionDelegateFromOriginalCollection() {
        return false;
    }

    protected boolean doesCollectionAllowNullElements() {
        return true;
    }

    protected boolean doesCollectionSupportDuplicateElements() {
        return true;
    }

    protected boolean doesCollectionSupportRemove() {
        return true;
    }

    protected boolean doesCollectionSupportEmpty() {
        return true;
    }

    protected boolean doesCollectionsIteratorSupportRemove() {
        return true;
    }

    protected boolean doesCollectionSupportRetainAll() {
        return true;
    }

    protected abstract Collection createCollection();

    protected abstract Collection createCollection(Collection var1);

    protected TestCollectionElement getElement(String data) {
        return new DefaultTestCollectionElement(data);
    }

    private Collection<?> createEmptyCollection() {
        if (this.isNullArgumentConstructorSupported()) {
            return this.createCollection();
        }
        if (this.isCollectionArgumentConstructorSupported()) {
            return this.createCollection(new HashSet());
        }
        Assert.fail((String)"Neither null nor Collection constructor is supported by the List implementation");
        return null;
    }

    @Test
    public void testCollectionFromNullConstructorHasZeroSize() {
        if (!this.isNullArgumentConstructorSupported()) {
            return;
        }
        Collection myList = this.createCollection();
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertTrue((boolean)myList.isEmpty());
    }

    @Test
    public void testCollectionFromCollectionConstructorHasZeroSize() {
        if (!this.isCollectionArgumentConstructorSupported()) {
            return;
        }
        Collection myList = this.createCollection(Collections.emptyList());
        Assert.assertEquals((long)0L, (long)myList.size());
        Assert.assertTrue((boolean)myList.isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testListColnstructedWithNullCollectionThrows() {
        if (!this.isCollectionArgumentConstructorSupported()) {
            throw new NullPointerException();
        }
        this.createCollection(null);
    }

    @Test
    public void testCanAddToCollection() {
        Collection<?> listMe = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        listMe.add(one);
        Assert.assertEquals((long)1L, (long)listMe.size());
        Assert.assertFalse((boolean)listMe.isEmpty());
        Assert.assertTrue((boolean)listMe.contains(one));
    }

    @Test
    public void testModifyingOriginalCollectionDoesNotAffectNewCollection() {
        if (!this.isCollectionArgumentConstructorSupported() || this.doesCollectionDelegateFromOriginalCollection()) {
            return;
        }
        LinkedList<TestCollectionElement> originalList = new LinkedList<TestCollectionElement>();
        originalList.add(this.getElement(ONE));
        originalList.add(this.getElement(TWO));
        Collection listUnderTest = this.createCollection(originalList);
        originalList.add(this.getElement(THREE));
        Assert.assertEquals((long)2L, (long)listUnderTest.size());
        originalList.clear();
        Assert.assertEquals((long)2L, (long)listUnderTest.size());
    }

    @Test
    public void testContainsAfterAdd() {
        Collection<?> list = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        TestCollectionElement three = this.getElement(THREE);
        TestCollectionElement four = this.getElement(FOUR);
        list.add(one);
        list.add(two);
        list.add(three);
        Assert.assertTrue((boolean)list.contains(three));
        Assert.assertTrue((boolean)list.contains(two));
        Assert.assertTrue((boolean)list.contains(one));
        Assert.assertFalse((boolean)list.contains(four));
        if (this.doesCollectionAllowNullElements()) {
            Assert.assertFalse((boolean)list.contains(null));
        }
    }

    @Test
    public void testCanCollectionHaveNullElements() {
        if (!this.doesCollectionAllowNullElements()) {
            return;
        }
        Collection<?> list = this.createEmptyCollection();
        list.add(null);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(null));
    }

    @Test
    public void testCanCollectionHaveNullAndNonNullElements() {
        if (!this.doesCollectionAllowNullElements()) {
            return;
        }
        Collection<?> list = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        list.add(null);
        list.add(one);
        list.add(null);
        list.add(two);
        if (this.doesCollectionSupportDuplicateElements()) {
            Assert.assertEquals((long)4L, (long)list.size());
        } else {
            Assert.assertEquals((long)3L, (long)list.size());
        }
        Assert.assertTrue((boolean)list.contains(null));
        Assert.assertTrue((boolean)list.contains(one));
        Assert.assertTrue((boolean)list.contains(two));
    }

    @Test
    public void testIteratorReturnedFromEmptyList() {
        Collection<?> list = this.createEmptyCollection();
        Iterator<?> iterator = list.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSingleItemIterator() {
        Collection<?> list = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        list.add(one);
        Iterator<?> iterator = list.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        TestCollectionElement returnedOne = (TestCollectionElement)iterator.next();
        Assert.assertNotNull((Object)returnedOne);
        Assert.assertEquals((Object)ONE, (Object)returnedOne.testCollectionValue());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMultipleItemIterator() {
        Collection<?> list = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        list.add(one);
        list.add(two);
        Iterator<?> iterator = list.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        TestCollectionElement returnedFirst = (TestCollectionElement)iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext());
        TestCollectionElement returnedSecond = (TestCollectionElement)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        String returnedFirstValue = returnedFirst.testCollectionValue();
        String returnedSecondValue = returnedSecond.testCollectionValue();
        if (ONE.equals(returnedFirstValue)) {
            Assert.assertEquals((Object)TWO, (Object)returnedSecondValue);
            return;
        }
        Assert.assertEquals((Object)TWO, (Object)returnedFirstValue);
        Assert.assertEquals((Object)ONE, (Object)returnedSecondValue);
    }

    @Test(expected=NoSuchElementException.class)
    public void testFallingOffEndOfEmptyIteratorThrows() {
        Collection<?> list = this.createEmptyCollection();
        Iterator<?> iterator = list.iterator();
        iterator.next();
    }

    @Test(expected=NoSuchElementException.class)
    public void testFallingOffEndOfNonEmptyIteratorThrows() {
        Collection<?> list = this.createEmptyCollection();
        list.add(this.getElement(ONE));
        Iterator<?> iterator = list.iterator();
        iterator.next();
        iterator.next();
    }

    @Test
    public void testSingleItemIteratorRemoval() {
        if (!this.doesCollectionsIteratorSupportRemove()) {
            return;
        }
        Collection<?> list = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        list.add(one);
        Iterator<?> iterator = list.iterator();
        iterator.next();
        iterator.remove();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    private static String findMissing(String a, String b) {
        LinkedList<String> holdMe = new LinkedList<String>();
        holdMe.add(ONE);
        holdMe.add(TWO);
        holdMe.add(THREE);
        LinkedList<String> removeMe = new LinkedList<String>();
        removeMe.add(a);
        removeMe.add(b);
        holdMe.removeAll(removeMe);
        return (String)holdMe.get(0);
    }

    @Test
    public void testMultipleItemIteratorRemoval() {
        if (!this.doesCollectionsIteratorSupportRemove()) {
            return;
        }
        Collection<?> list = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        TestCollectionElement three = this.getElement(THREE);
        list.add(one);
        list.add(two);
        list.add(three);
        Iterator<?> iterator = list.iterator();
        TestCollectionElement first = (TestCollectionElement)iterator.next();
        TestCollectionElement second = (TestCollectionElement)iterator.next();
        iterator.remove();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(first));
        Assert.assertFalse((boolean)list.contains(second));
        String missing = AbstractCollectionTest.findMissing(first.testCollectionValue(), second.testCollectionValue());
        TestCollectionElement missingElement = ONE.equals(missing) ? one : (TWO.equals(missing) ? two : three);
        Assert.assertTrue((boolean)list.contains(missingElement));
        TestCollectionElement third = (TestCollectionElement)iterator.next();
        iterator.remove();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(first));
        Assert.assertFalse((boolean)list.contains(second));
        Assert.assertFalse((boolean)list.contains(third));
    }

    @Test(expected=IllegalStateException.class)
    public void testIteratorRemoveOnEmptyIteratorThrows() {
        if (!this.doesCollectionsIteratorSupportRemove()) {
            throw new IllegalStateException();
        }
        Collection<?> collection = this.createEmptyCollection();
        Iterator<?> iterator = collection.iterator();
        iterator.remove();
    }

    @Test(expected=IllegalStateException.class)
    public void testDoubleIteratorRemoveThrows() {
        if (!this.doesCollectionsIteratorSupportRemove()) {
            throw new IllegalStateException();
        }
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        collection.add(one);
        Iterator<?> iterator = collection.iterator();
        iterator.next();
        iterator.remove();
        iterator.remove();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupporedRemoveIteratorThrows() {
        if (this.doesCollectionsIteratorSupportRemove()) {
            throw new UnsupportedOperationException();
        }
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        collection.add(one);
        Iterator<?> iterator = collection.iterator();
        iterator.next();
        iterator.remove();
    }

    @Test
    public void testCollectionToArrayWithEmptyCollection() {
        Collection<?> collection = this.createEmptyCollection();
        Object[] cArray = collection.toArray();
        Assert.assertNotNull((Object)cArray);
        Assert.assertEquals((long)0L, (long)cArray.length);
    }

    @Test
    public void testCollectionToArrayWithCollectionOfOneItem() {
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        collection.add(one);
        Object[] cArray = collection.toArray();
        Assert.assertNotNull((Object)cArray);
        Assert.assertEquals((long)1L, (long)cArray.length);
        Assert.assertEquals((Object)one, (Object)cArray[0]);
    }

    @Test
    public void testCollectionToArrayWithCollectionOfMultipleItems() {
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        collection.add(one);
        collection.add(two);
        Object[] cArray = collection.toArray();
        Assert.assertNotNull((Object)cArray);
        Assert.assertEquals((long)2L, (long)cArray.length);
        String firstValue = ((TestCollectionElement)cArray[0]).testCollectionValue();
        String secondValue = ((TestCollectionElement)cArray[1]).testCollectionValue();
        if (ONE.equals(firstValue)) {
            Assert.assertEquals((Object)TWO, (Object)secondValue);
            return;
        }
        Assert.assertEquals((Object)TWO, (Object)firstValue);
        Assert.assertEquals((Object)ONE, (Object)secondValue);
    }

    @Test
    public void testCollectionToArrayWithArgumentWithEmptyCollection() {
        Collection<?> collection = this.createEmptyCollection();
        Object[] cArray = collection.toArray(new Object[5]);
        Assert.assertNotNull((Object)cArray);
        Assert.assertEquals((long)5L, (long)cArray.length);
        Assert.assertNull((Object)cArray[0]);
    }

    @Test
    public void testCollectionToArrayWithArgumentWithCollectionOfOneItem() {
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        collection.add(one);
        Object[] cArray = collection.toArray(new Object[1]);
        Assert.assertNotNull((Object)cArray);
        Assert.assertEquals((long)1L, (long)cArray.length);
        Assert.assertEquals((Object)one, (Object)cArray[0]);
    }

    @Test
    public void testCollectionToArrayWithArgumentWithCollectionOfMultipleItems() {
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        collection.add(one);
        collection.add(two);
        Object[] cArray = collection.toArray(new Object[1]);
        Assert.assertNotNull((Object)cArray);
        Assert.assertEquals((long)2L, (long)cArray.length);
        String firstValue = ((TestCollectionElement)cArray[0]).testCollectionValue();
        String secondValue = ((TestCollectionElement)cArray[1]).testCollectionValue();
        if (ONE.equals(firstValue)) {
            Assert.assertEquals((Object)TWO, (Object)secondValue);
            return;
        }
        Assert.assertEquals((Object)TWO, (Object)firstValue);
        Assert.assertEquals((Object)ONE, (Object)secondValue);
    }

    @Test(expected=NullPointerException.class)
    public void testCollectionToArrayWithArgumentWithNullThrows() {
        Collection<?> collection = this.createEmptyCollection();
        collection.toArray((Object[])null);
    }

    @Test
    public void testAddReturnsProperValueForNonDuplicateAdd() {
        Collection<?> collection = this.createEmptyCollection();
        Assert.assertTrue((boolean)collection.add(this.getElement(ONE)));
    }

    @Test
    public void testAddReturnsProperValueForDuplicateAdd() {
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        Assert.assertTrue((boolean)collection.add(one));
        if (this.doesCollectionSupportDuplicateElements()) {
            Assert.assertTrue((boolean)collection.add(one));
        } else {
            Assert.assertFalse((boolean)collection.add(one));
        }
    }

    @Test
    public void testRemoveFromEmptyList() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        Assert.assertFalse((boolean)collection.remove(one));
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    public void testRemoveFromOneElementList() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        collection.add(one);
        Assert.assertTrue((boolean)collection.remove(one));
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    public void testRemoveFirstThingFromMultiElementList() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        TestCollectionElement three = this.getElement(THREE);
        collection.add(one);
        collection.add(two);
        collection.add(three);
        Assert.assertTrue((boolean)collection.remove(one));
        Assert.assertEquals((long)2L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertTrue((boolean)collection.contains(two));
        Assert.assertTrue((boolean)collection.contains(three));
    }

    @Test
    public void testRemoveLastThingFromMultiElementList() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        TestCollectionElement three = this.getElement(THREE);
        collection.add(one);
        collection.add(two);
        collection.add(three);
        Assert.assertTrue((boolean)collection.remove(three));
        Assert.assertEquals((long)2L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertTrue((boolean)collection.contains(two));
        Assert.assertTrue((boolean)collection.contains(one));
    }

    @Test
    public void testRemoveMiddleThingFromMultiElementList() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection<?> collection = this.createEmptyCollection();
        TestCollectionElement one = this.getElement(ONE);
        TestCollectionElement two = this.getElement(TWO);
        TestCollectionElement three = this.getElement(THREE);
        collection.add(one);
        collection.add(two);
        collection.add(three);
        Assert.assertTrue((boolean)collection.remove(two));
        Assert.assertEquals((long)2L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        Assert.assertTrue((boolean)collection.contains(three));
        Assert.assertTrue((boolean)collection.contains(one));
    }

    private Collection createCollectionWithOneTwoThree() {
        Collection<?> collection = this.createEmptyCollection();
        this.ONE_CE = this.getElement(ONE);
        this.TWO_CE = this.getElement(TWO);
        this.THREE_CE = this.getElement(THREE);
        collection.add(this.ONE_CE);
        collection.add(this.TWO_CE);
        collection.add(this.THREE_CE);
        return collection;
    }

    @Test
    public void testContainsAllWithEmptyCollectionAndEmptyInput() {
        Collection collection = this.createEmptyCollection();
        HashSet input = new HashSet();
        Assert.assertTrue((boolean)collection.containsAll(input));
    }

    @Test
    public void testContainsAllWithNonEmptyCollectionAndEmptyInput() {
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet input = new HashSet();
        Assert.assertTrue((boolean)collection.containsAll(input));
    }

    @Test
    public void testContainsAllWithNonEmptyCollectionAndCorrectInput() {
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.ONE_CE);
        input.add(this.THREE_CE);
        Assert.assertTrue((boolean)collection.containsAll(input));
    }

    @Test
    public void testContainsAllWithNonEmptyCollectionAndIncorrectInput() {
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.ONE_CE);
        input.add(this.THREE_CE);
        input.add(this.getElement(FOUR));
        Assert.assertFalse((boolean)collection.containsAll(input));
    }

    @Test(expected=NullPointerException.class)
    public void testContainsAllThrows() {
        Collection collection = this.createCollectionWithOneTwoThree();
        collection.containsAll(null);
    }

    @Test
    public void testAddAllWithEmptyCollectionAndEmptyInput() {
        Collection<?> collection = this.createEmptyCollection();
        HashSet input = new HashSet();
        Assert.assertFalse((boolean)collection.addAll(input));
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    public void testAddAllWithNonEmptyCollectionAndEmptyInput() {
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet input = new HashSet();
        Assert.assertFalse((boolean)collection.addAll(input));
        Assert.assertEquals((long)3L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        HashSet shouldBeIn = new HashSet(input);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
    }

    @Test
    public void testAddAllWithNonEmptyCollectionAndNonEmptyInputNoDups() {
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.getElement(FOUR));
        input.add(this.getElement(FIVE));
        Assert.assertTrue((boolean)collection.addAll(input));
        Assert.assertEquals((long)5L, (long)collection.size());
        HashSet<TestCollectionElement> shouldBeIn = new HashSet<TestCollectionElement>(input);
        shouldBeIn.add(this.ONE_CE);
        shouldBeIn.add(this.TWO_CE);
        shouldBeIn.add(this.THREE_CE);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
    }

    @Test
    public void testAddAllWithNonEmptyCollectionAndNonEmptyInputDups() {
        if (!this.doesCollectionSupportDuplicateElements()) {
            return;
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.THREE_CE);
        input.add(this.getElement(FOUR));
        Assert.assertTrue((boolean)collection.addAll(input));
        HashSet<TestCollectionElement> shouldBeIn = new HashSet<TestCollectionElement>(input);
        shouldBeIn.add(this.ONE_CE);
        shouldBeIn.add(this.TWO_CE);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
        if (this.doesCollectionSupportDuplicateElements()) {
            Assert.assertEquals((long)5L, (long)collection.size());
        } else {
            Assert.assertEquals((long)4L, (long)collection.size());
        }
    }

    @Test(expected=NullPointerException.class)
    public void testAddAllThrows() {
        Collection collection = this.createCollectionWithOneTwoThree();
        collection.addAll(null);
    }

    @Test
    public void testRemoveAllWithEmptyCollectionAndEmptyInput() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection collection = this.createEmptyCollection();
        HashSet input = new HashSet();
        Assert.assertFalse((boolean)collection.removeAll(input));
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    public void testRemoveAllWithNonEmptyCollectionAndEmptyInput() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet input = new HashSet();
        Assert.assertFalse((boolean)collection.removeAll(input));
        Assert.assertEquals((long)3L, (long)collection.size());
        Assert.assertFalse((boolean)collection.isEmpty());
        HashSet shouldBeIn = new HashSet(input);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
    }

    @Test
    public void testRemoveAllWithNonEmptyCollectionAndNonEmptyInput() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.ONE_CE);
        input.add(this.TWO_CE);
        Assert.assertTrue((boolean)collection.removeAll(input));
        Assert.assertEquals((long)1L, (long)collection.size());
        HashSet<TestCollectionElement> shouldBeIn = new HashSet<TestCollectionElement>();
        shouldBeIn.add(this.THREE_CE);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
    }

    @Test
    public void testRemoveAllWithNonEmptyCollectionAndNonEmptyInputWithExtras() {
        if (!this.doesCollectionSupportRemove()) {
            return;
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.THREE_CE);
        input.add(this.getElement(FOUR));
        Assert.assertTrue((boolean)collection.removeAll(input));
        HashSet<TestCollectionElement> shouldBeIn = new HashSet<TestCollectionElement>();
        shouldBeIn.add(this.ONE_CE);
        shouldBeIn.add(this.TWO_CE);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveAllThrows() {
        if (!this.doesCollectionSupportRemove()) {
            throw new NullPointerException();
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        collection.removeAll(null);
    }

    @Test
    public void testRetainAllWithEmptyCollectionAndEmptyInput() {
        if (!this.doesCollectionSupportRetainAll()) {
            return;
        }
        Collection collection = this.createEmptyCollection();
        HashSet input = new HashSet();
        Assert.assertFalse((boolean)collection.retainAll(input));
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    public void testRetainAllWithNonEmptyCollectionAndEmptyInput() {
        if (!this.doesCollectionSupportRetainAll()) {
            return;
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet input = new HashSet();
        Assert.assertTrue((boolean)collection.retainAll(input));
        Assert.assertEquals((long)0L, (long)collection.size());
        Assert.assertTrue((boolean)collection.isEmpty());
    }

    @Test
    public void testRetainAllWithNonEmptyCollectionAndNonEmptyInput() {
        if (!this.doesCollectionSupportRetainAll()) {
            return;
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.ONE_CE);
        input.add(this.TWO_CE);
        Assert.assertTrue((boolean)collection.retainAll(input));
        Assert.assertEquals((long)2L, (long)collection.size());
        HashSet shouldBeIn = new HashSet(input);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
    }

    @Test
    public void testRetainAllWithNonEmptyCollectionAndNonEmptyInputWithExtras() {
        if (!this.doesCollectionSupportRetainAll()) {
            return;
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.THREE_CE);
        input.add(this.getElement(FOUR));
        Assert.assertTrue((boolean)collection.retainAll(input));
        HashSet<TestCollectionElement> shouldBeIn = new HashSet<TestCollectionElement>();
        shouldBeIn.add(this.THREE_CE);
        Assert.assertTrue((boolean)collection.containsAll(shouldBeIn));
    }

    @Test(expected=NullPointerException.class)
    public void testRetainAllThrows() {
        if (!this.doesCollectionSupportRetainAll()) {
            throw new NullPointerException();
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        collection.retainAll(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedRetainAllThrowsProperException() {
        if (this.doesCollectionSupportRetainAll()) {
            throw new UnsupportedOperationException();
        }
        Collection collection = this.createCollectionWithOneTwoThree();
        HashSet<TestCollectionElement> input = new HashSet<TestCollectionElement>();
        input.add(this.THREE_CE);
        collection.retainAll(input);
    }

    @Test
    public void testClearWorksOnEmptyCollection() {
        if (!this.doesCollectionSupportEmpty()) {
            return;
        }
        Collection<?> collection = this.createEmptyCollection();
        collection.clear();
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
    }

    @Test
    public void testClearWorksOnNonEmptyCollection() {
        if (!this.doesCollectionSupportEmpty()) {
            return;
        }
        Collection<?> collection = this.createEmptyCollection();
        collection.add(this.getElement(ONE));
        collection.clear();
        Assert.assertTrue((boolean)collection.isEmpty());
        Assert.assertEquals((long)0L, (long)collection.size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupportedClearThrows() {
        if (this.doesCollectionSupportEmpty()) {
            throw new UnsupportedOperationException();
        }
        Collection<?> collection = this.createEmptyCollection();
        collection.clear();
    }

    @Test
    public void testAddOneThousandEntries() {
        Collection<?> collection = this.createEmptyCollection();
        HashSet<TestCollectionElement> elements = new HashSet<TestCollectionElement>();
        for (int lcv = 0; lcv < 1000; ++lcv) {
            TestCollectionElement element = this.getElement("" + lcv);
            collection.add(element);
            elements.add(element);
        }
        for (TestCollectionElement element : elements) {
            Assert.assertTrue((boolean)collection.contains(element));
        }
    }
}

