/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;

public class ConfigParser {
    protected final Habitat habitat;
    private static final XMLInputFactory xif = XMLInputFactory.newInstance();

    public ConfigParser(Habitat habitat) {
        this.habitat = habitat;
    }

    public DomDocument parse(XMLStreamReader in) throws XMLStreamException {
        DomDocument document = new DomDocument(this.habitat);
        this.parse(in, document);
        return document;
    }

    public void parse(XMLStreamReader in, DomDocument document) throws XMLStreamException {
        this.parse(in, document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(XMLStreamReader in, DomDocument document, Dom parent) throws XMLStreamException {
        try {
            in.nextTag();
            document.root = this.handleElement(in, document, parent);
        }
        finally {
            in.close();
        }
    }

    public DomDocument parse(URL source) {
        return this.parse(source, new DomDocument(this.habitat));
    }

    public DomDocument parse(URL source, DomDocument document) {
        return this.parse(source, document, null);
    }

    public DomDocument parse(URL source, DomDocument document, Dom parent) {
        InputStream inputStream = null;
        try {
            inputStream = source.openStream();
        }
        catch (IOException e) {
            throw new ComponentException("Failed to open " + source, (Throwable)e);
        }
        try {
            this.parse(xif.createXMLStreamReader(new StreamSource(inputStream)), document, parent);
            DomDocument e = document;
            return e;
        }
        catch (XMLStreamException e) {
            throw new ComponentException("Failed to parse " + source, (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {}
        }
    }

    protected Dom handleElement(XMLStreamReader in, DomDocument document, Dom parent) throws XMLStreamException {
        ConfigModel model = document.getModelByElementName(in.getLocalName());
        if (model == null) {
            String localName = in.getLocalName();
            Logger.getAnonymousLogger().severe("Ignoring unrecognized element " + in.getLocalName() + " at " + in.getLocation());
            int depth = 1;
            while (depth > 0) {
                int tag = in.nextTag();
                if (tag == 1 && in.getLocalName().equals(localName)) {
                    if (Logger.getAnonymousLogger().isLoggable(Level.FINE)) {
                        Logger.getAnonymousLogger().fine("Found child of same type " + localName + " ignoring too");
                    }
                    ++depth;
                }
                if (tag == 2 && in.getLocalName().equals(localName)) {
                    if (Logger.getAnonymousLogger().isLoggable(Level.FINE)) {
                        Logger.getAnonymousLogger().fine("closing element type " + localName);
                    }
                    --depth;
                }
                if (!Logger.getAnonymousLogger().isLoggable(Level.FINE) || tag != 1) continue;
                Logger.getAnonymousLogger().fine("Jumping over " + in.getLocalName());
            }
            return null;
        }
        return this.handleElement(in, document, parent, model);
    }

    protected Dom handleElement(XMLStreamReader in, DomDocument document, Dom parent, ConfigModel model) throws XMLStreamException {
        Dom dom = document.make(this.habitat, in, parent, model);
        dom.fillAttributes(in);
        ArrayList<Dom.Child> children = null;
        while (in.nextTag() == 1) {
            Dom child;
            String name = in.getLocalName();
            ConfigModel.Property a = model.elements.get(name);
            if (children == null) {
                children = new ArrayList();
            }
            if (a == null) {
                child = this.handleElement(in, document, dom);
                if (child == null) continue;
                children.add(new Dom.NodeChild(name, child));
                continue;
            }
            if (a.isLeaf()) {
                children.add(new Dom.LeafChild(name, in.getElementText()));
                continue;
            }
            child = this.handleElement(in, document, dom, ((ConfigModel.Node)a).model);
            if (child == null) continue;
            children.add(new Dom.NodeChild(name, child));
        }
        dom.register();
        if (children == null) {
            children = new ArrayList<Dom.Child>();
        }
        dom.ensureConstraints(children);
        if (!children.isEmpty()) {
            dom.setChildren(children);
        }
        dom.initializationCompleted();
        return dom;
    }
}

