/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import com.sun.hk2.component.AbstractInhabitantImpl;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Creator;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.Dom;

class ConfiguredCreator<T>
extends AbstractInhabitantImpl<T>
implements Creator<T> {
    private final Creator<T> core;
    private final Dom dom;

    public ConfiguredCreator(Creator<T> core, Dom dom) {
        super(core);
        this.core = core;
        this.dom = dom;
    }

    public boolean isActive() {
        return true;
    }

    public String typeName() {
        return this.core.getImplementation();
    }

    public Class<? extends T> type() {
        return this.core.type();
    }

    public T get(Inhabitant onBehalfOf) {
        T t = this.create(onBehalfOf);
        this.initialize(t, onBehalfOf);
        return t;
    }

    public T create(Inhabitant onBehalfOf) throws ComponentException {
        Object retVal = this.core.create(onBehalfOf);
        this.initialize(retVal, onBehalfOf);
        return (T)retVal;
    }

    public void initialize(T t, Inhabitant onBehalfOf) throws ComponentException {
        this.injectConfig(t);
        this.core.initialize(t, onBehalfOf);
    }

    private void injectConfig(T t) {
        this.dom.inject(t);
    }

    public void release() {
        this.core.release();
    }
}

