/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config;

import com.sun.hk2.component.Holder;
import com.sun.hk2.component.IntrospectionScanner;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationModel;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.ClassModel;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.MethodModel;
import org.glassfish.hk2.classmodel.reflect.ParsingContext;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.utilities.AliasDescriptor;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.InjectionTarget;
import org.jvnet.hk2.config.NoopConfigInjector;
import org.jvnet.hk2.deprecated.internal.HolderHK2LoaderImpl;

@Service
public class ConfiguredScanner
implements IntrospectionScanner {
    @Inject
    Habitat habitat;
    ParsingContext context;

    public void parse(ParsingContext context, Holder<ClassLoader> loader) {
        this.context = context;
        AnnotationType configured = (AnnotationType)context.getTypes().getBy(Configured.class.getName());
        if (configured == null) {
            return;
        }
        for (AnnotatedElement ae : configured.allAnnotatedTypes()) {
            if (!(ae instanceof ExtensibleType)) continue;
            HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
            this.parse((ExtensibleType)ae, metadata);
            AnnotationModel c = ae.getAnnotation(Configured.class.getName());
            String elementName = (String)c.getValues().get("value");
            if (elementName == null || elementName.length() == 0) {
                elementName = Dom.convertName(ae.getName().substring(ae.getName().lastIndexOf(46) + 1));
            }
            ConfiguredScanner.addToMetadata(metadata, "target", ae.getName());
            DescriptorImpl di = BuilderHelper.link(NoopConfigInjector.class).in(Singleton.class.getName()).andLoadWith((HK2Loader)new HolderHK2LoaderImpl(loader)).build();
            di.setMetadata(metadata);
            ActiveDescriptor added = ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.habitat, (Descriptor)di);
            AliasDescriptor injectionTargetAlias = new AliasDescriptor((ServiceLocator)this.habitat, added, InjectionTarget.class.getName(), ae.getName());
            AliasDescriptor configInjectorAlias = new AliasDescriptor((ServiceLocator)this.habitat, added, ConfigInjector.class.getName(), elementName);
            ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.habitat, (Descriptor)injectionTargetAlias);
            ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)this.habitat, (Descriptor)configInjectorAlias);
        }
    }

    private void parse(ExtensibleType<?> type, Map<String, List<String>> metadata) {
        Stack<Object> q = new Stack<Object>();
        HashSet<ExtensibleType> visited = new HashSet<ExtensibleType>();
        q.push(type);
        while (!q.isEmpty()) {
            Collection interfaces;
            Collection methods;
            ExtensibleType t = (ExtensibleType)q.pop();
            if (null == t || !visited.add(t)) continue;
            if (t instanceof ClassModel) {
                for (FieldModel f : ((ClassModel)t).getFields()) {
                    this.generate(f);
                }
            }
            if (null != (methods = t.getMethods())) {
                for (MethodModel m : methods) {
                    this.generate(m, metadata);
                }
            }
            if (null != (interfaces = t.getInterfaces())) {
                for (InterfaceModel child : interfaces) {
                    q.add(child);
                }
            }
            if (t.getParent() == null) continue;
            q.add(t.getParent());
        }
    }

    private void generate(FieldModel f) {
    }

    private void generate(MethodModel m, Map<String, List<String>> metadata) {
        AnnotationModel attribute = m.getAnnotation(Attribute.class.getName());
        AnnotationModel element = m.getAnnotation(Element.class.getName());
        if (attribute != null) {
            this.generateAttribute(attribute, m, metadata);
            if (element != null) {
                throw new RuntimeException("Cannot have both @Element and @Attribute at the same time on method " + m.getName());
            }
        } else if (element != null) {
            this.generateElement(element, m, metadata);
        }
    }

    private void generateAttribute(AnnotationModel attribute, MethodModel m, Map<String, List<String>> metadata) {
        Boolean isKey;
        String refTypeAsString;
        String name = Dom.convertName(m.getName());
        String xmlTokenName = '@' + name;
        boolean isRequired = Boolean.parseBoolean((String)attribute.getValues().get("isRequired"));
        ConfiguredScanner.addToMetadata(metadata, xmlTokenName, isRequired ? "required" : "optional");
        String defaultValue = (String)attribute.getValues().get("defaultValue");
        if (defaultValue != null && !defaultValue.isEmpty()) {
            if (defaultValue.indexOf(44) != -1) {
                ConfiguredScanner.addToMetadata(metadata, xmlTokenName, "\"default:" + defaultValue + '\"');
            } else {
                ConfiguredScanner.addToMetadata(metadata, xmlTokenName, "default:" + defaultValue);
            }
        }
        String signature = m.getSignature();
        String[] arguments = m.getArgumentTypes();
        if (arguments.length == 0) {
            refTypeAsString = m.getReturnType();
        } else {
            if (arguments.length != 1) {
                throw new RuntimeException("@Attribute method cannot have more than 1 argument " + m.getSignature());
            }
            refTypeAsString = arguments[0];
        }
        boolean isCollection = refTypeAsString.startsWith("java.util.List<L");
        if (isCollection) {
            refTypeAsString = refTypeAsString.substring("java.util.List<L".length());
        }
        ConfiguredScanner.addToMetadata(metadata, xmlTokenName, "datatype:" + refTypeAsString);
        Type refType = this.context.getTypes().getBy(refTypeAsString);
        Boolean isReference = (Boolean)attribute.getValues().get("reference");
        if (refType == null || isReference != null && isReference.booleanValue()) {
            ConfiguredScanner.addToMetadata(metadata, xmlTokenName, this.makeCollectionIfNecessary(isCollection, "leaf"));
            if (isReference != null && isReference.booleanValue()) {
                ConfiguredScanner.addToMetadata(metadata, xmlTokenName, "reference");
            }
        } else {
            ConfiguredScanner.addToMetadata(metadata, xmlTokenName, this.makeCollectionIfNecessary(isCollection, refTypeAsString));
        }
        if ((isKey = (Boolean)attribute.getValues().get("key")) != null && isKey.booleanValue()) {
            ConfiguredScanner.addToMetadata(metadata, "key", xmlTokenName);
            ConfiguredScanner.addToMetadata(metadata, "keyed-as", m.getDeclaringType().getName());
        }
    }

    private String makeCollectionIfNecessary(boolean isCollection, String value) {
        if (isCollection) {
            return "collection:" + value;
        }
        return value;
    }

    private void generateElement(AnnotationModel element, MethodModel m, Map<String, List<String>> metadata) {
        String refTypeAsString;
        String name = Dom.convertName(m.getName());
        String xmlTokenName = "<" + name + ">";
        String[] arguments = m.getArgumentTypes();
        if (arguments.length == 0) {
            refTypeAsString = m.getReturnType();
        } else {
            if (arguments.length != 1) {
                throw new RuntimeException("@Element method cannot have more than 1 argument " + m.getSignature());
            }
            refTypeAsString = arguments[0];
        }
        boolean isCollection = refTypeAsString.startsWith("java.util.List<L");
        if (isCollection) {
            refTypeAsString = refTypeAsString.substring("java.util.List<L".length());
        }
        Boolean isReference = (Boolean)element.getValues().get("reference");
        Type refType = this.context.getTypes().getBy(refTypeAsString);
        if (refType == null || isReference != null && isReference.booleanValue()) {
            ConfiguredScanner.addToMetadata(metadata, xmlTokenName, this.makeCollectionIfNecessary(isCollection, "leaf"));
            if (isReference != null && isReference.booleanValue()) {
                ConfiguredScanner.addToMetadata(metadata, xmlTokenName, "reference");
            }
        } else {
            ConfiguredScanner.addToMetadata(metadata, xmlTokenName, this.makeCollectionIfNecessary(isCollection, refTypeAsString));
        }
    }

    private static final void addToMetadata(Map<String, List<String>> map, String key, String value) {
        List<String> list = map.get(key);
        if (list == null) {
            list = new LinkedList<String>();
        }
        list.add(value);
    }
}

