/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.provider.internal;

import com.sun.hk2.component.ConstructorCreator;
import com.sun.hk2.component.InjectionResolverQuery;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;

class ConfigByCreator<T>
extends ConstructorCreator<T> {
    private final Object configBean;
    private final InjectionResolverQuery txnContextResolver;

    ConfigByCreator(InjectionResolverQuery txnContextResolver, Object configBean, Class<T> type, Habitat habitat, Map<String, List<String>> metadata) {
        super(type, (ServiceLocator)habitat, metadata);
        this.txnContextResolver = txnContextResolver;
        this.configBean = configBean;
    }

    public T create(Inhabitant onBehalfOf) throws ComponentException {
        Class<?> clazz = this.configBean.getClass();
        try {
            T obj = null;
            for (Constructor<?> ctor : this.type().getDeclaredConstructors()) {
                Class<?>[] paramTypes = ctor.getParameterTypes();
                if (1 != paramTypes.length || !paramTypes[0].isAssignableFrom(clazz)) continue;
                ctor.setAccessible(true);
                obj = (T)ctor.newInstance(this.configBean);
                return obj;
            }
            return (T)super.create(onBehalfOf);
        }
        catch (Exception e) {
            throw new ComponentException("unable to find appropriate ctor for: " + clazz, (Throwable)new ComponentException(e.getMessage(), (Throwable)e));
        }
    }
}

