/*
 * Copyright (c) 2014, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.hk2.configuration.hub.api;

import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.internal.HubImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

/**
 * @author jwells
 *
 */
public class ManagerUtilities {
    
    /**
     * This method will add the Hub service to the given service locator.
     * If there is already a Hub service available this method will do
     * nothing
     * 
     * @param locator The non-null ServiceLocator to add the configuration
     * Hub service to
     */
    public static void enableConfigurationHub(ServiceLocator locator) {
        if (locator.getService(Hub.class) != null) {
            return;
        }
        
        ServiceLocatorUtilities.addClasses(locator, true, HubImpl.class);
    }

}
