/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.CommitFailedException;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.PrepareFailedException;
import org.glassfish.hk2.configuration.hub.api.RollbackFailedException;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.internal.BeanDatabaseImpl;
import org.glassfish.hk2.configuration.hub.internal.WriteableBeanDatabaseImpl;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={Hub.class})
@Visibility(value=DescriptorVisibility.LOCAL)
public class HubImpl
implements Hub {
    private static final AtomicLong revisionCounter = new AtomicLong(1L);
    private final ReentrantLock lock = new ReentrantLock();
    private BeanDatabaseImpl currentDatabase = new BeanDatabaseImpl(revisionCounter.getAndIncrement());
    @Inject
    private IterableProvider<BeanDatabaseUpdateListener> listeners;
    private int inTransaction = 0;

    @Override
    public BeanDatabase getCurrentDatabase() {
        this.lock.lock();
        try {
            BeanDatabaseImpl beanDatabaseImpl = this.currentDatabase;
            return beanDatabaseImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public WriteableBeanDatabase getWriteableDatabaseCopy() {
        this.lock.lock();
        try {
            WriteableBeanDatabaseImpl writeableBeanDatabaseImpl = new WriteableBeanDatabaseImpl(this, this.currentDatabase);
            return writeableBeanDatabaseImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedList<BeanDatabaseUpdateListener> prepareCurrentDatabase(WriteableBeanDatabaseImpl writeableDatabase, Object commitMessage, List<Change> changes) {
        this.lock.lock();
        try {
            long writeRevision;
            if (this.inTransaction > 0) {
                throw new IllegalStateException("This Hub is already in a transaction");
            }
            long currentRevision = this.currentDatabase.getRevision();
            if (currentRevision != (writeRevision = writeableDatabase.getBaseRevision())) {
                throw new IllegalStateException("commit was called on a WriteableDatabase but the current database has changed after that copy was made");
            }
            LinkedList<BeanDatabaseUpdateListener> completedListeners = new LinkedList<BeanDatabaseUpdateListener>();
            for (BeanDatabaseUpdateListener listener : this.listeners) {
                try {
                    listener.prepareDatabaseChange(this.currentDatabase, writeableDatabase, commitMessage, changes);
                    completedListeners.add(listener);
                }
                catch (Throwable th) {
                    MultiException throwMe = new MultiException((Throwable)((Object)new PrepareFailedException(th)));
                    for (BeanDatabaseUpdateListener completedListener : completedListeners) {
                        try {
                            completedListener.rollbackDatabaseChange(this.currentDatabase, writeableDatabase, commitMessage, changes);
                        }
                        catch (Throwable rollTh) {
                            throwMe.addError((Throwable)((Object)new RollbackFailedException(rollTh)));
                        }
                    }
                    throw throwMe;
                }
            }
            ++this.inTransaction;
            LinkedList<BeanDatabaseUpdateListener> linkedList = completedListeners;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activateCurrentDatabase(WriteableBeanDatabaseImpl writeableDatabase, Object commitMessage, List<Change> changes, LinkedList<BeanDatabaseUpdateListener> completedListeners) {
        this.lock.lock();
        try {
            --this.inTransaction;
            if (this.inTransaction < 0) {
                this.inTransaction = 0;
            }
            List<BeanDatabaseUpdateListener> completed = completedListeners;
            completedListeners = null;
            if (completed == null) {
                completed = Collections.emptyList();
            }
            BeanDatabaseImpl oldDatabase = this.currentDatabase;
            this.currentDatabase = new BeanDatabaseImpl(revisionCounter.getAndIncrement(), writeableDatabase);
            MultiException commitError = null;
            for (BeanDatabaseUpdateListener completedListener : completed) {
                try {
                    completedListener.commitDatabaseChange(oldDatabase, this.currentDatabase, commitMessage, changes);
                }
                catch (Throwable th) {
                    if (commitError == null) {
                        commitError = new MultiException((Throwable)((Object)new CommitFailedException(th)));
                        continue;
                    }
                    commitError.addError((Throwable)((Object)new CommitFailedException(th)));
                }
            }
            if (commitError != null) {
                throw commitError;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackCurrentDatabase(WriteableBeanDatabaseImpl writeableDatabase, Object commitMessage, List<Change> changes, LinkedList<BeanDatabaseUpdateListener> completedListeners) {
        this.lock.lock();
        try {
            --this.inTransaction;
            if (this.inTransaction < 0) {
                this.inTransaction = 0;
            }
            List<BeanDatabaseUpdateListener> completed = completedListeners;
            completedListeners = null;
            if (completed == null) {
                completed = Collections.emptyList();
            }
            MultiException rollbackError = null;
            for (BeanDatabaseUpdateListener completedListener : completed) {
                try {
                    completedListener.rollbackDatabaseChange(this.currentDatabase, writeableDatabase, commitMessage, changes);
                }
                catch (Throwable th) {
                    if (rollbackError == null) {
                        rollbackError = new MultiException((Throwable)((Object)new RollbackFailedException(th)));
                        continue;
                    }
                    rollbackError.addError((Throwable)((Object)new RollbackFailedException(th)));
                }
            }
            if (rollbackError != null) {
                throw rollbackError;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void setCurrentDatabase(WriteableBeanDatabaseImpl writeableDatabase, Object commitMessage, List<Change> changes) {
        LinkedList<BeanDatabaseUpdateListener> completedListeners = this.prepareCurrentDatabase(writeableDatabase, commitMessage, changes);
        this.activateCurrentDatabase(writeableDatabase, commitMessage, changes, completedListeners);
    }
}

