/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.hub.internal.ChangeImpl;
import org.glassfish.hk2.configuration.hub.internal.InstanceImpl;
import org.glassfish.hk2.configuration.hub.internal.TypeImpl;
import org.glassfish.hk2.configuration.hub.internal.WriteableBeanDatabaseImpl;
import org.glassfish.hk2.utilities.reflection.BeanReflectionHelper;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;

public class WriteableTypeImpl
implements WriteableType {
    private final ReentrantLock lock = new ReentrantLock();
    private final WriteableBeanDatabaseImpl parent;
    private final String name;
    private final HashMap<String, Instance> beanMap = new HashMap();
    private final ClassReflectionHelper helper;
    private Object metadata;

    WriteableTypeImpl(WriteableBeanDatabaseImpl parent, TypeImpl mother) {
        this.parent = parent;
        this.name = mother.getName();
        this.metadata = mother.getMetadata();
        this.beanMap.putAll(mother.getInstances());
        this.helper = mother.getHelper();
    }

    WriteableTypeImpl(WriteableBeanDatabaseImpl parent, String name) {
        this.parent = parent;
        this.name = name;
        this.helper = new ClassReflectionHelperImpl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, Instance> getInstances() {
        this.lock.lock();
        try {
            Map<String, Instance> map = Collections.unmodifiableMap(this.beanMap);
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Instance getInstance(String key) {
        this.lock.lock();
        try {
            Instance instance = this.beanMap.get(key);
            return instance;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instance addInstance(String key, Object bean) {
        this.lock.lock();
        try {
            Instance instance = this.addInstance(key, bean, null);
            return instance;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instance addInstance(String key, Object bean, Object metadata) {
        this.lock.lock();
        try {
            if (key == null || bean == null) {
                throw new IllegalArgumentException();
            }
            InstanceImpl ii = new InstanceImpl(bean, metadata);
            this.parent.addChange(new ChangeImpl(Change.ChangeCategory.ADD_INSTANCE, this, key, ii, null, null));
            this.beanMap.put(key, ii);
            InstanceImpl instanceImpl = ii;
            return instanceImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instance removeInstance(String key) {
        this.lock.lock();
        try {
            if (key == null) {
                throw new IllegalArgumentException();
            }
            Instance removedValue = this.beanMap.remove(key);
            if (removedValue == null) {
                Instance instance = null;
                return instance;
            }
            this.parent.addChange(new ChangeImpl(Change.ChangeCategory.REMOVE_INSTANCE, this, key, removedValue, null, null));
            Instance instance = removedValue;
            return instance;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyChangeEvent[] modifyInstance(String key, Object newBean, PropertyChangeEvent ... propChanges) {
        this.lock.lock();
        try {
            if (key == null || newBean == null) {
                throw new IllegalArgumentException();
            }
            Instance oldInstance = this.beanMap.get(key);
            if (oldInstance == null) {
                throw new IllegalStateException("Attempting to modify bean with key " + key + " but no such bean exists");
            }
            InstanceImpl newInstance = new InstanceImpl(newBean, oldInstance.getMetadata());
            if (propChanges.length == 0) {
                propChanges = BeanReflectionHelper.getChangeEvents((ClassReflectionHelper)this.helper, (Object)oldInstance.getBean(), (Object)newInstance.getBean());
            }
            this.beanMap.put(key, newInstance);
            ArrayList<PropertyChangeEvent> propChangesList = new ArrayList<PropertyChangeEvent>(propChanges.length);
            for (PropertyChangeEvent pce : propChanges) {
                propChangesList.add(pce);
            }
            this.parent.addChange(new ChangeImpl(Change.ChangeCategory.MODIFY_INSTANCE, this, key, newInstance, oldInstance, propChangesList));
            PropertyChangeEvent[] propertyChangeEventArray = propChanges;
            return propertyChangeEventArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    ClassReflectionHelper getHelper() {
        return this.helper;
    }

    @Override
    public Object getMetadata() {
        this.lock.lock();
        try {
            Object object = this.metadata;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setMetadata(Object metadata) {
        this.lock.lock();
        try {
            this.metadata = metadata;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "WriteableTypeImpl(" + this.name + "," + this.metadata + "," + System.identityHashCode(this) + ")";
    }
}

