/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.hub.internal;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.TwoPhaseResource;
import org.glassfish.hk2.api.TwoPhaseTransactionData;
import org.glassfish.hk2.configuration.hub.api.BeanDatabaseUpdateListener;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.configuration.hub.api.WriteableBeanDatabase;
import org.glassfish.hk2.configuration.hub.api.WriteableType;
import org.glassfish.hk2.configuration.hub.internal.BeanDatabaseImpl;
import org.glassfish.hk2.configuration.hub.internal.ChangeImpl;
import org.glassfish.hk2.configuration.hub.internal.HubImpl;
import org.glassfish.hk2.configuration.hub.internal.TypeImpl;
import org.glassfish.hk2.configuration.hub.internal.Utilities;
import org.glassfish.hk2.configuration.hub.internal.WriteableTypeImpl;

public class WriteableBeanDatabaseImpl
implements WriteableBeanDatabase {
    private final long baseRevision;
    private final HashMap<String, WriteableTypeImpl> types = new HashMap();
    private final HubImpl hub;
    private final TwoPhaseResourceImpl resource = new TwoPhaseResourceImpl();
    private final ReentrantLock lock = new ReentrantLock();
    private final LinkedList<Change> changes = new LinkedList();
    private final LinkedList<WriteableTypeImpl> removedTypes = new LinkedList();
    private boolean committed = false;
    private Object commitMessage = null;

    WriteableBeanDatabaseImpl(HubImpl hub, BeanDatabaseImpl currentDatabase) {
        this.hub = hub;
        this.baseRevision = currentDatabase.getRevision();
        for (Type type : currentDatabase.getAllTypes()) {
            this.types.put(type.getName(), new WriteableTypeImpl(this, (TypeImpl)type));
        }
    }

    @Override
    public Set<Type> getAllTypes() {
        this.lock.lock();
        try {
            Set<Type> set = Collections.unmodifiableSet(new HashSet<WriteableTypeImpl>(this.types.values()));
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Set<WriteableType> getAllWriteableTypes() {
        return Collections.unmodifiableSet(new HashSet<WriteableTypeImpl>(this.types.values()));
    }

    @Override
    public Type getType(String type) {
        this.lock.lock();
        try {
            Type type2 = this.types.get(type);
            return type2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instance getInstance(String type, String instanceKey) {
        this.lock.lock();
        try {
            Type t = this.getType(type);
            if (t == null) {
                Instance instance = null;
                return instance;
            }
            Instance instance = t.getInstance(instanceKey);
            return instance;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkState() {
        if (this.committed) {
            throw new IllegalStateException("This database has already been committed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteableType addType(String typeName) {
        this.lock.lock();
        try {
            if (typeName == null) {
                throw new IllegalArgumentException();
            }
            this.checkState();
            WriteableTypeImpl wti = new WriteableTypeImpl(this, typeName);
            this.changes.add(new ChangeImpl(Change.ChangeCategory.ADD_TYPE, wti, null, null, null, null));
            this.types.put(typeName, wti);
            WriteableTypeImpl writeableTypeImpl = wti;
            return writeableTypeImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Type removeType(String typeName) {
        this.lock.lock();
        try {
            if (typeName == null) {
                throw new IllegalArgumentException();
            }
            this.checkState();
            WriteableTypeImpl retVal = this.types.remove(typeName);
            if (retVal == null) {
                Type type = null;
                return type;
            }
            Map<String, Instance> instances = retVal.getInstances();
            for (String key : new HashSet<String>(instances.keySet())) {
                retVal.removeInstance(key);
            }
            this.changes.add(new ChangeImpl(Change.ChangeCategory.REMOVE_TYPE, retVal, null, null, null, null));
            this.removedTypes.add(retVal);
            WriteableTypeImpl writeableTypeImpl = retVal;
            return writeableTypeImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public WriteableType getWriteableType(String typeName) {
        this.lock.lock();
        try {
            this.checkState();
            WriteableType writeableType = this.types.get(typeName);
            return writeableType;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteableType findOrAddWriteableType(String typeName) {
        this.lock.lock();
        try {
            if (typeName == null) {
                throw new IllegalArgumentException();
            }
            this.checkState();
            WriteableTypeImpl wti = this.types.get(typeName);
            if (wti == null) {
                WriteableType writeableType = this.addType(typeName);
                return writeableType;
            }
            WriteableTypeImpl writeableTypeImpl = wti;
            return writeableTypeImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void commit() {
        Object defaultCommit;
        this.lock.lock();
        try {
            defaultCommit = this.commitMessage;
        }
        finally {
            this.lock.unlock();
        }
        this.commit(defaultCommit);
    }

    @Override
    public void commit(Object commitMessage) {
        this.lock.lock();
        try {
            this.checkState();
            this.committed = true;
        }
        finally {
            this.lock.unlock();
        }
        this.hub.setCurrentDatabase(this, commitMessage, this.changes);
        for (WriteableTypeImpl removedType : this.removedTypes) {
            removedType.getHelper().dispose();
        }
        this.removedTypes.clear();
    }

    long getBaseRevision() {
        return this.baseRevision;
    }

    void addChange(Change change) {
        this.lock.lock();
        try {
            this.changes.add(change);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void dumpDatabase() {
        this.dumpDatabase(System.err);
    }

    @Override
    public void dumpDatabase(PrintStream output) {
        this.lock.lock();
        try {
            Utilities.dumpDatabase(this, output);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String dumpDatabaseAsString() {
        return Utilities.dumpDatabaseAsString(this);
    }

    @Override
    public TwoPhaseResource getTwoPhaseResource() {
        return this.resource;
    }

    @Override
    public Object getCommitMessage() {
        this.lock.lock();
        try {
            Object object = this.commitMessage;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCommitMessage(Object commitMessage) {
        this.lock.lock();
        try {
            this.commitMessage = commitMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String getChanges() {
        int lcv = 1;
        StringBuffer sb = new StringBuffer("\n");
        for (Change change : this.changes) {
            sb.append(lcv + ". " + change + "\n");
            ++lcv;
        }
        return sb.toString();
    }

    public String toString() {
        return "WriteableBeanDatabaseImpl(" + this.baseRevision + ",changes=" + this.getChanges() + "," + System.identityHashCode(this) + ")";
    }

    private class TwoPhaseResourceImpl
    implements TwoPhaseResource {
        private LinkedList<BeanDatabaseUpdateListener> completedListeners;

        private TwoPhaseResourceImpl() {
        }

        public void prepareDynamicConfiguration(TwoPhaseTransactionData dynamicConfiguration) throws MultiException {
            Object defaultCommit;
            WriteableBeanDatabaseImpl.this.lock.lock();
            try {
                WriteableBeanDatabaseImpl.this.checkState();
                WriteableBeanDatabaseImpl.this.committed = true;
                defaultCommit = WriteableBeanDatabaseImpl.this.commitMessage;
            }
            finally {
                WriteableBeanDatabaseImpl.this.lock.unlock();
            }
            this.completedListeners = WriteableBeanDatabaseImpl.this.hub.prepareCurrentDatabase(WriteableBeanDatabaseImpl.this, defaultCommit, WriteableBeanDatabaseImpl.this.changes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateDynamicConfiguration(TwoPhaseTransactionData dynamicConfiguration) {
            Object defaultCommit;
            LinkedList<BeanDatabaseUpdateListener> completedListeners = this.completedListeners;
            this.completedListeners = null;
            WriteableBeanDatabaseImpl.this.lock.lock();
            try {
                defaultCommit = WriteableBeanDatabaseImpl.this.commitMessage;
            }
            finally {
                WriteableBeanDatabaseImpl.this.lock.unlock();
            }
            WriteableBeanDatabaseImpl.this.hub.activateCurrentDatabase(WriteableBeanDatabaseImpl.this, defaultCommit, WriteableBeanDatabaseImpl.this.changes, completedListeners);
            for (WriteableTypeImpl removedType : WriteableBeanDatabaseImpl.this.removedTypes) {
                removedType.getHelper().dispose();
            }
            WriteableBeanDatabaseImpl.this.removedTypes.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollbackDynamicConfiguration(TwoPhaseTransactionData dynamicConfiguration) {
            Object defaultCommit;
            LinkedList<BeanDatabaseUpdateListener> completedListeners = this.completedListeners;
            this.completedListeners = null;
            WriteableBeanDatabaseImpl.this.lock.lock();
            try {
                defaultCommit = WriteableBeanDatabaseImpl.this.commitMessage;
            }
            finally {
                WriteableBeanDatabaseImpl.this.lock.unlock();
            }
            WriteableBeanDatabaseImpl.this.hub.rollbackCurrentDatabase(WriteableBeanDatabaseImpl.this, defaultCommit, WriteableBeanDatabaseImpl.this.changes, completedListeners);
            for (WriteableTypeImpl removedType : WriteableBeanDatabaseImpl.this.removedTypes) {
                removedType.getHelper().dispose();
            }
            WriteableBeanDatabaseImpl.this.removedTypes.clear();
        }
    }
}

