/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.glassfish.hk2.configuration.api.Configured;
import org.glassfish.hk2.configuration.api.Dynamicity;
import org.glassfish.hk2.configuration.internal.BeanInfo;
import org.glassfish.hk2.utilities.reflection.TypeChecker;

public class BeanUtilities {
    private static final String GET = "get";
    private static final String IS = "is";
    private static final String EMPTY = "";

    private static String firstUpper(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        char firstChar = Character.toUpperCase(s.charAt(0));
        return firstChar + s.substring(1);
    }

    public static Object getBeanPropertyValue(Type requiredType, String attribute, BeanInfo beanInfo) {
        if ("$bean".equals(attribute)) {
            Object bean = beanInfo.getBean();
            if (bean == null) {
                return null;
            }
            if (TypeChecker.isRawTypeSafe((Type)requiredType, bean.getClass())) {
                return bean;
            }
            Object metadata = beanInfo.getMetadata();
            if (metadata != null && TypeChecker.isRawTypeSafe((Type)requiredType, metadata.getClass())) {
                return metadata;
            }
            return bean;
        }
        if ("$type".equals(attribute)) {
            return beanInfo.getTypeName();
        }
        if ("$instance".equals(attribute)) {
            return beanInfo.getInstanceName();
        }
        Object bean = beanInfo.getBean();
        if (bean instanceof Map) {
            Map beanLikeMap = (Map)bean;
            return beanLikeMap.get(attribute);
        }
        attribute = BeanUtilities.firstUpper(attribute);
        String methodName = GET + attribute;
        Class<?> beanClass = bean.getClass();
        Method m = null;
        try {
            m = beanClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException me) {
            methodName = IS + attribute;
            try {
                m = beanClass.getMethod(methodName, new Class[0]);
            }
            catch (NoSuchMethodException me2) {
                throw new IllegalArgumentException("The bean " + bean + " has no getter for attribute " + attribute);
            }
        }
        m.setAccessible(true);
        try {
            return m.invoke(bean, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            throw new IllegalStateException(th);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return EMPTY.equals(s);
    }

    public static String getParameterNameFromField(Field f, boolean onlyDynamic) {
        Configured c = f.getAnnotation(Configured.class);
        if (c == null) {
            return null;
        }
        if (onlyDynamic && !Dynamicity.FULLY_DYNAMIC.equals((Object)c.dynamicity())) {
            return null;
        }
        String key = c.value();
        if (BeanUtilities.isEmpty(key)) {
            key = f.getName();
        }
        return key;
    }

    public static String getParameterNameFromMethod(Method m, int paramIndex) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = m.getParameterAnnotations()[paramIndex]) {
            if (!Configured.class.equals(annotation.annotationType())) continue;
            Configured configured = (Configured)annotation;
            if (!Dynamicity.FULLY_DYNAMIC.equals((Object)configured.dynamicity())) {
                return null;
            }
            String retVal = ((Configured)annotation).value();
            if (BeanUtilities.isEmpty(retVal)) {
                return null;
            }
            return retVal;
        }
        return null;
    }

    public static boolean hasDynamicParameter(Method m) {
        Annotation[][] annotationArray = m.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                Configured configured;
                if (!Configured.class.equals(annotation.annotationType()) || !Dynamicity.FULLY_DYNAMIC.equals((Object)(configured = (Configured)annotation).dynamicity())) continue;
                return true;
            }
        }
        return false;
    }
}

