/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.configuration.internal;

import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.configuration.api.ConfiguredBy;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class ConfiguredByContext
implements Context<ConfiguredBy> {
    private static final ThreadLocal<ActiveDescriptor<?>> workingOn = ThreadLocal.withInitial(() -> null);
    private final Object lock = new Object();
    private final Map<ActiveDescriptor<?>, Object> db = new HashMap();

    public Class<? extends Annotation> getScope() {
        return ConfiguredBy.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        ActiveDescriptor<?> previousValue = workingOn.get();
        workingOn.set(activeDescriptor);
        try {
            U u = this.internalFindOrCreate(activeDescriptor, root);
            return u;
        }
        finally {
            workingOn.set(previousValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <U> U internalFindOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        Object object = this.lock;
        synchronized (object) {
            Object retVal = this.db.get(activeDescriptor);
            if (retVal != null) {
                return (U)retVal;
            }
            if (activeDescriptor.getName() == null) {
                throw new MultiException((Throwable)new IllegalStateException("ConfiguredBy services without names are templates and cannot be created directly"));
            }
            retVal = activeDescriptor.create(root);
            this.db.put(activeDescriptor, retVal);
            return (U)retVal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        Object object = this.lock;
        synchronized (object) {
            return this.db.containsKey(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyOne(ActiveDescriptor<?> descriptor) {
        Object object = this.lock;
        synchronized (object) {
            Object destroyMe = this.db.remove(descriptor);
            if (destroyMe == null) {
                return;
            }
            descriptor.dispose(destroyMe);
        }
    }

    public boolean supportsNullCreation() {
        return false;
    }

    public boolean isActive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            HashSet activeDescriptors = new HashSet(this.db.keySet());
            for (ActiveDescriptor activeDescriptor : activeDescriptors) {
                this.destroyOne(activeDescriptor);
            }
        }
    }

    ActiveDescriptor<?> getWorkingOn() {
        return workingOn.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object findOnly(ActiveDescriptor<?> descriptor) {
        Object object = this.lock;
        synchronized (object) {
            return this.db.get(descriptor);
        }
    }
}

