/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.BCELClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.BCELClassFileLoader1;
import com.sun.enterprise.tools.verifier.apiscan.classfile.BCELClosureCompilerImpl;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompiler;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClosureCompilerImplBase;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class ClosureCompilerImpl
implements ClosureCompiler {
    private ClosureCompilerImplBase imp;
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    private static Logger logger = Logger.getLogger("apiscan.classfile", resourceBundleName);
    private static final String myClassName = "ClosureCompilerImpl";

    public ClosureCompilerImpl(ClassFileLoader loader) {
        if (!(loader instanceof BCELClassFileLoader) && !(loader instanceof BCELClassFileLoader1)) {
            throw new RuntimeException("Unknown loader type [" + loader + "]");
        }
        this.imp = new BCELClosureCompilerImpl(loader);
    }

    public ClosureCompilerImpl(ClosureCompilerImplBase imp) {
        this.imp = imp;
    }

    public void addExcludedClass(String className) {
        this.imp.addExcludedClass(className);
    }

    public void addExcludedPackage(String pkgName) {
        this.imp.addExcludedPackage(pkgName);
    }

    public void addExcludedPattern(String pattern) {
        this.imp.addExcludedPattern(pattern);
    }

    @Override
    public boolean buildClosure(String className) {
        logger.entering(myClassName, "buildClosure", className);
        return this.imp.buildClosure(className);
    }

    public boolean buildClosure(JarFile jar) throws IOException {
        return this.imp.buildClosure(jar);
    }

    @Override
    public Collection getClosure() {
        return this.imp.getClosure();
    }

    @Override
    public Map getFailed() {
        return this.imp.getFailed();
    }

    @Override
    public void reset() {
        this.imp.reset();
    }

    public Collection<String> getNativeMethods() {
        return this.imp.getNativeMethods();
    }

    public String toString() {
        return this.imp.toString();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage : java " + ClosureCompilerImpl.class.getName() + " <classpath> <external class name(s)>");
            System.out.println("Example: to find the closure of mypkg.MySessionBean which is packaged in myejb.jar run\n java " + ClosureCompilerImpl.class.getName() + " path_to_j2ee.jar" + File.pathSeparator + "path_to_myejb.jar mypkg.MySessionBean");
            System.exit(1);
        }
        String cp = args[0];
        System.out.println("Using classpath " + cp);
        ClassFileLoader cfl = ClassFileLoaderFactory.newInstance(new Object[]{cp});
        ClosureCompilerImpl closure = new ClosureCompilerImpl(cfl);
        closure.addExcludedPattern("java.");
        for (int i = 1; i < args.length; ++i) {
            String clsName = args[i];
            System.out.println("Building closure for " + clsName);
            closure.reset();
            closure.buildClosure(clsName);
            System.out.println("The closure is [" + closure + "\n]");
        }
    }
}

