/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation.internal;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.operation.OperationContext;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationIdentifier;
import org.glassfish.hk2.extras.operation.internal.OperationDescriptor;
import org.glassfish.hk2.extras.operation.internal.OperationHandleImpl;
import org.glassfish.hk2.extras.operation.internal.OperationIdentifierImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class SingleOperationManager<T extends Annotation> {
    private static final String ID_PREAMBLE = "OperationIdentifier(";
    private final Object operationLock = new Object();
    private final T scope;
    private final HashMap<OperationIdentifier<T>, OperationHandleImpl<T>> openScopes = new HashMap();
    private final HashMap<Long, OperationHandleImpl<T>> threadToHandleMap = new HashMap();
    private final ServiceLocator locator;
    private final OperationContext<T> context;
    private long scopedIdentifier;
    private final ActiveDescriptor<?> operationDescriptor;
    private boolean closed = false;

    SingleOperationManager(T scope, ServiceLocator locator) {
        this.scope = scope;
        this.locator = locator;
        OperationContext found = null;
        for (OperationContext context : locator.getAllServices(OperationContext.class, new Annotation[0])) {
            if (!context.getScope().equals(scope.annotationType())) continue;
            found = context;
            break;
        }
        if (found == null) {
            throw new IllegalStateException("Could not find the OperationContext for scope " + scope);
        }
        this.context = found;
        this.context.setOperationManager(this);
        OperationDescriptor<T> opDesc = new OperationDescriptor<T>(scope, this);
        this.operationDescriptor = ServiceLocatorUtilities.addOneDescriptor((ServiceLocator)locator, opDesc);
    }

    private OperationIdentifierImpl<T> allocateNewIdentifier() {
        return new OperationIdentifierImpl<T>(ID_PREAMBLE + this.scopedIdentifier++ + "," + this.scope.annotationType().getName() + ")", this.scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandleImpl<T> createOperation() {
        Object object = this.operationLock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("This manager has been closed");
            }
            OperationIdentifierImpl<T> id = this.allocateNewIdentifier();
            OperationHandleImpl<T> created = new OperationHandleImpl<T>(this, id, this.operationLock, this.locator);
            this.openScopes.put(id, created);
            return created;
        }
    }

    void closeOperation(OperationHandleImpl<T> closeMe) {
        this.openScopes.remove(closeMe.getIdentifier());
    }

    void disposeAllOperationServices(OperationHandleImpl<T> closeMe) {
        this.context.closeOperation(closeMe);
    }

    void associateWithThread(long threadId, OperationHandleImpl<T> handle) {
        this.threadToHandleMap.put(threadId, handle);
    }

    void disassociateThread(long threadId, OperationHandleImpl<T> toRemove) {
        OperationHandleImpl<T> activeOnThread = this.threadToHandleMap.get(threadId);
        if (activeOnThread == null || !activeOnThread.equals(toRemove)) {
            return;
        }
        this.threadToHandleMap.remove(threadId);
    }

    OperationHandleImpl<T> getCurrentOperationOnThisThread(long threadId) {
        return this.threadToHandleMap.get(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationHandleImpl<T> getCurrentOperationOnThisThread() {
        long threadId = Thread.currentThread().getId();
        Object object = this.operationLock;
        synchronized (object) {
            if (this.closed) {
                return null;
            }
            return this.getCurrentOperationOnThisThread(threadId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<OperationHandle<T>> getAllOperations() {
        HashSet<OperationHandleImpl<T>> retVal = new HashSet<OperationHandleImpl<T>>();
        Object object = this.operationLock;
        synchronized (object) {
            if (this.closed) {
                return Collections.emptySet();
            }
            retVal.addAll(this.openScopes.values());
            return Collections.unmodifiableSet(retVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.operationLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (OperationHandleImpl<T> closeMe : this.openScopes.values()) {
                closeMe.shutdownByFiat();
            }
            this.openScopes.clear();
            this.threadToHandleMap.clear();
            ServiceLocatorUtilities.removeOneDescriptor((ServiceLocator)this.locator, this.operationDescriptor);
        }
    }

    public String toString() {
        return "SingleOperationManager(" + this.scope.annotationType().getName() + ",closed=" + this.closed + "," + System.identityHashCode(this) + ")";
    }
}

