/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.operation.internal;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.operation.OperationHandle;
import org.glassfish.hk2.extras.operation.OperationManager;
import org.glassfish.hk2.extras.operation.internal.SingleOperationManager;

@Singleton
public class OperationManagerImpl
implements OperationManager {
    private final HashMap<Class<? extends Annotation>, SingleOperationManager<?>> children = new HashMap();
    @Inject
    private ServiceLocator locator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Annotation> OperationHandle<T> createOperation(T scope) {
        SingleOperationManager<Object> manager;
        OperationManagerImpl operationManagerImpl = this;
        synchronized (operationManagerImpl) {
            manager = this.children.get(scope.annotationType());
            if (manager == null) {
                manager = new SingleOperationManager<T>(scope, this.locator);
                this.children.put(scope.annotationType(), manager);
            }
        }
        return manager.createOperation();
    }

    @Override
    public <T extends Annotation> OperationHandle<T> createAndStartOperation(T scope) {
        OperationHandle<T> retVal = this.createOperation(scope);
        retVal.resume();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Annotation> Set<OperationHandle<T>> getCurrentOperations(T scope) {
        SingleOperationManager<?> manager;
        OperationManagerImpl operationManagerImpl = this;
        synchronized (operationManagerImpl) {
            manager = this.children.get(scope.annotationType());
            if (manager == null) {
                return Collections.emptySet();
            }
        }
        return manager.getAllOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Annotation> OperationHandle<T> getCurrentOperation(T scope) {
        SingleOperationManager<?> manager;
        OperationManagerImpl operationManagerImpl = this;
        synchronized (operationManagerImpl) {
            manager = this.children.get(scope.annotationType());
            if (manager == null) {
                return null;
            }
        }
        return manager.getCurrentOperationOnThisThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownAllOperations(Annotation scope) {
        OperationManagerImpl operationManagerImpl = this;
        synchronized (operationManagerImpl) {
            SingleOperationManager<?> manager = this.children.remove(scope.annotationType());
            if (manager == null) {
                return;
            }
            manager.shutdown();
        }
    }
}

