/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.generator.ant;

import java.io.File;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.jvnet.hk2.generator.HabitatGenerator;

public class HK2InhabitantGeneratorTask
extends Task {
    private File targetDirectory = new File("target/classes");
    private boolean verbose = false;
    private String locator = null;
    private File outputDirectory = null;
    private boolean noswap = false;
    private Path classpath = null;
    private boolean includeDate = true;

    public void setTargetDirectory(File targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setNoSwap(boolean noswap) {
        this.noswap = noswap;
    }

    public void setIncludeDate(boolean includeDate) {
        this.includeDate = includeDate;
    }

    public void addClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void execute() throws BuildException {
        String[] argv;
        int result;
        LinkedList<String> args = new LinkedList<String>();
        if (this.targetDirectory != null) {
            if (!this.targetDirectory.isDirectory()) {
                throw new BuildException("targetDirectory " + this.targetDirectory.getAbsolutePath() + " must point to the directory where the built classes reside");
            }
            args.add("--file");
            args.add(this.targetDirectory.getAbsolutePath());
        }
        if (this.verbose) {
            args.add("--verbose");
        }
        if (!this.includeDate) {
            args.add("--noDate");
        }
        if (this.locator != null) {
            args.add("--locator");
            args.add(this.locator);
        }
        if (this.outputDirectory != null) {
            if (!this.outputDirectory.isDirectory()) {
                if (this.outputDirectory.exists()) {
                    throw new BuildException("outputDirectory " + this.outputDirectory.getAbsolutePath() + " exists and is not a directory");
                }
                if (!this.outputDirectory.mkdirs()) {
                    throw new BuildException("Could not create directory " + this.outputDirectory.getAbsolutePath());
                }
            }
            args.add("--directory");
            args.add(this.outputDirectory.getAbsolutePath());
        }
        if (this.noswap) {
            args.add("--noswap");
        }
        if (this.classpath != null) {
            args.add("--searchPath");
            args.add(this.classpath.toString());
        }
        if ((result = HabitatGenerator.embeddedMain(argv = args.toArray(new String[args.size()]))) != 0) {
            throw new BuildException("Could not generate inhabitants file for " + this.targetDirectory.getAbsolutePath());
        }
    }
}

