/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Operation;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ValidationService;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.ConstantActiveDescriptor;
import org.jvnet.hk2.internal.DescriptorComparator;
import org.jvnet.hk2.internal.DynamicConfigurationImpl;
import org.jvnet.hk2.internal.IterableProviderImpl;
import org.jvnet.hk2.internal.NarrowResults;
import org.jvnet.hk2.internal.ParameterizedTypeImpl;
import org.jvnet.hk2.internal.PerLookupContext;
import org.jvnet.hk2.internal.ServiceHandleComparator;
import org.jvnet.hk2.internal.ServiceHandleImpl;
import org.jvnet.hk2.internal.SingletonContext;
import org.jvnet.hk2.internal.SystemDescriptor;
import org.jvnet.hk2.internal.TypeChecker;
import org.jvnet.hk2.internal.Utilities;

public class ServiceLocatorImpl
implements ServiceLocator {
    private static final Object sLock = new Object();
    private static long currentLocatorId = 0L;
    static final DescriptorComparator DESCRIPTOR_COMPARATOR = new DescriptorComparator();
    private static final ServiceHandleComparator HANDLE_COMPARATOR = new ServiceHandleComparator();
    private final Object lock = new Object();
    private long nextServiceId = 0L;
    private final String locatorName;
    private final long id;
    private final ServiceLocator parent;
    private final LinkedList<SystemDescriptor<?>> allDescriptors = new LinkedList();
    private final HashMap<String, LinkedList<SystemDescriptor<?>>> descriptorsByAdvertisedContract = new HashMap();
    private final HashMap<String, LinkedList<SystemDescriptor<?>>> descriptorsByName = new HashMap();
    private final HashMap<Class<? extends Annotation>, InjectionResolver<?>> allResolvers = new HashMap();
    private final Context<Singleton> singletonContext = new SingletonContext();
    private final Context<PerLookup> perLookupContext = new PerLookupContext();
    private final LinkedHashSet<ValidationService> allValidators = new LinkedHashSet();
    private final LinkedList<ErrorService> errorHandlers = new LinkedList();
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceLocatorImpl(String name, ServiceLocator parent) {
        this.locatorName = name;
        this.parent = parent;
        Object object = sLock;
        synchronized (object) {
            this.id = currentLocatorId++;
        }
    }

    private boolean validate(SystemDescriptor<?> descriptor, Injectee onBehalfOf) {
        for (ValidationService vs : this.allValidators) {
            if (!descriptor.isValidating(vs) || vs.getValidator().validate(Operation.LOOKUP, descriptor, onBehalfOf)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActiveDescriptor<?>> getDescriptors(Filter filter, Injectee onBehalfOf, boolean getParents) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        Object object = this.lock;
        synchronized (object) {
            List<SystemDescriptor<Object>> sortMeOut;
            if (filter instanceof IndexedFilter) {
                IndexedFilter df = (IndexedFilter)filter;
                if (df.getName() != null) {
                    String string = df.getName();
                    List<SystemDescriptor> scopedByName = (List<SystemDescriptor>)this.descriptorsByName.get(string);
                    if (scopedByName == null) {
                        scopedByName = Collections.emptyList();
                    }
                    if (df.getAdvertisedContract() != null) {
                        sortMeOut = new LinkedList();
                        for (SystemDescriptor candidate : scopedByName) {
                            if (!candidate.getAdvertisedContracts().contains(df.getAdvertisedContract())) continue;
                            sortMeOut.add(candidate);
                        }
                    } else {
                        sortMeOut = scopedByName;
                    }
                } else if (df.getAdvertisedContract() != null) {
                    String advertisedContract = df.getAdvertisedContract();
                    sortMeOut = this.descriptorsByAdvertisedContract.get(advertisedContract);
                    if (sortMeOut == null) {
                        sortMeOut = Collections.emptyList();
                    }
                } else {
                    sortMeOut = this.allDescriptors;
                }
            } else {
                sortMeOut = this.allDescriptors;
            }
            TreeSet<Descriptor> sorter = new TreeSet<Descriptor>(DESCRIPTOR_COMPARATOR);
            for (SystemDescriptor systemDescriptor : sortMeOut) {
                if (!this.validate(systemDescriptor, onBehalfOf) || !filter.matches((Descriptor)systemDescriptor)) continue;
                sorter.add((Descriptor)systemDescriptor);
            }
            if (getParents && this.parent != null) {
                sorter.addAll(this.parent.getDescriptors(filter));
            }
            return new LinkedList<Descriptor>(sorter);
        }
    }

    private List<ActiveDescriptor<?>> protectedGetDescriptors(final Filter filter) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<ActiveDescriptor<?>>>(){

            @Override
            public List<ActiveDescriptor<?>> run() {
                return ServiceLocatorImpl.this.getDescriptors(filter);
            }
        });
    }

    public List<ActiveDescriptor<?>> getDescriptors(Filter filter) {
        this.checkState();
        return this.getDescriptors(filter, null, true);
    }

    public ActiveDescriptor<?> getBestDescriptor(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.checkState();
        List<ActiveDescriptor<?>> sorted = this.getDescriptors(filter);
        return Utilities.getFirstThingInList(sorted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActiveDescriptor<?> reifyDescriptor(Descriptor descriptor, Injectee injectee) throws MultiException {
        this.checkState();
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (!(descriptor instanceof ActiveDescriptor)) {
            SystemDescriptor sd = new SystemDescriptor(descriptor, new Long(this.id), new Long(this.getNextServiceId()));
            Class<?> implClass = this.loadClass(descriptor, injectee);
            Collector collector = new Collector();
            sd.reify(implClass, this, collector);
            collector.throwIfErrors();
            return sd;
        }
        ActiveDescriptor active = (ActiveDescriptor)descriptor;
        if (active.isReified()) {
            return active;
        }
        SystemDescriptor sd = active instanceof SystemDescriptor ? (SystemDescriptor)active : new SystemDescriptor(descriptor, new Long(this.id), new Long(this.getNextServiceId()));
        Class<?> implClass = this.loadClass(descriptor, injectee);
        Collector collector = new Collector();
        Object object = this.lock;
        synchronized (object) {
            sd.reify(implClass, this, collector);
        }
        collector.throwIfErrors();
        return sd;
    }

    public ActiveDescriptor<?> reifyDescriptor(Descriptor descriptor) throws MultiException {
        this.checkState();
        return this.reifyDescriptor(descriptor, null);
    }

    public ActiveDescriptor<?> getInjecteeDescriptor(Injectee injectee) throws MultiException {
        Annotation[] qualifiers;
        if (injectee == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        Type requiredType = injectee.getRequiredType();
        Class<?> rawType = Utilities.getRawClass(requiredType);
        if (rawType == null) {
            throw new MultiException((Throwable)new IllegalArgumentException("Invalid injectee with required type of " + injectee.getRequiredType() + " passed to getInjecteeDescriptor"));
        }
        if (Provider.class.equals(rawType) || IterableProvider.class.equals(rawType)) {
            IterableProviderImpl value = new IterableProviderImpl(this, Utilities.getFirstTypeArgument(requiredType), injectee.getRequiredQualifiers());
            return new ConstantActiveDescriptor(value, this.id);
        }
        Set qualifiersAsSet = injectee.getRequiredQualifiers();
        String name = Utilities.getNameFromAllQualifiers(qualifiersAsSet, injectee.getParent());
        ServiceHandle handle = this.internalGetServiceHandle(injectee, requiredType, name, qualifiers = qualifiersAsSet.toArray(new Annotation[qualifiersAsSet.size()]));
        if (handle == null) {
            return null;
        }
        return handle.getActiveDescriptor();
    }

    public <T> ServiceHandle<T> getServiceHandle(ActiveDescriptor<T> activeDescriptor, Injectee injectee) throws MultiException {
        if (activeDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        return new ServiceHandleImpl<T>(this, activeDescriptor, injectee);
    }

    public <T> ServiceHandle<T> getServiceHandle(ActiveDescriptor<T> activeDescriptor) throws MultiException {
        if (activeDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        return this.getServiceHandle(activeDescriptor, null);
    }

    public <T> T getService(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) throws MultiException {
        ServiceHandle<T> subHandle = this.getServiceHandle(activeDescriptor);
        this.checkState();
        if (root != null && PerLookup.class.equals((Object)activeDescriptor.getScopeAnnotation())) {
            ((ServiceHandleImpl)root).addSubHandle((ServiceHandleImpl)subHandle);
        }
        return (T)subHandle.getService();
    }

    public <T> T getService(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        ServiceHandle<T> serviceHandle = this.getServiceHandle(contractOrImpl, qualifiers);
        if (serviceHandle == null) {
            return null;
        }
        return (T)serviceHandle.getService();
    }

    private <T> List<T> protectedGetAllServices(final Type contractOrImpl, final Annotation ... qualifiers) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<T>>(){

            @Override
            public List<T> run() {
                return ServiceLocatorImpl.this.getAllServices(contractOrImpl, qualifiers);
            }
        });
    }

    public <T> List<T> getAllServices(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        List<ServiceHandle<?>> services = this.getAllServiceHandles(contractOrImpl, qualifiers);
        LinkedList<Object> retVal = new LinkedList<Object>();
        for (ServiceHandle<?> service : services) {
            retVal.add(service.getService());
        }
        return retVal;
    }

    public <T> T getService(Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        ServiceHandle<T> handle = this.getServiceHandle(contractOrImpl, name, qualifiers);
        if (handle == null) {
            return null;
        }
        return (T)handle.getService();
    }

    public List<?> getAllServices(Filter searchCriteria) throws MultiException {
        this.checkState();
        List<ServiceHandle<?>> handleSet = this.getAllServiceHandles(searchCriteria);
        LinkedList<Object> retVal = new LinkedList<Object>();
        for (ServiceHandle<?> handle : handleSet) {
            retVal.add(handle.getService());
        }
        return retVal;
    }

    public String getName() {
        return this.locatorName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.allDescriptors.clear();
            this.descriptorsByAdvertisedContract.clear();
            this.descriptorsByName.clear();
            this.allResolvers.clear();
            this.allValidators.clear();
            this.errorHandlers.clear();
        }
    }

    public <T> T create(Class<T> createMe) {
        this.checkState();
        return Utilities.justCreate(createMe, this);
    }

    public void inject(Object injectMe) {
        this.checkState();
        Utilities.justInject(injectMe, this);
    }

    public void postConstruct(Object postConstructMe) {
        this.checkState();
        Utilities.justPostConstruct(postConstructMe);
    }

    public void preDestroy(Object preDestroyMe) {
        this.checkState();
        Utilities.justPreDestroy(preDestroyMe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ServiceHandle<T> internalGetServiceHandle(Injectee onBehalfOf, Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        ActiveDescriptor<?> topDog;
        NarrowResults results;
        if (contractOrImpl == null) {
            throw new IllegalArgumentException();
        }
        Class<?> rawClass = Utilities.getRawClass(contractOrImpl);
        if (rawClass == null) {
            return null;
        }
        rawClass = Utilities.translatePrimitiveType(rawClass);
        IndexedFilter filter = BuilderHelper.createNameAndContractFilter((String)rawClass.getName(), (String)name);
        LinkedList<ErrorService> currentErrorHandlers = null;
        Object object = this.lock;
        synchronized (object) {
            List<ActiveDescriptor<?>> candidates = this.getDescriptors((Filter)filter, onBehalfOf, true);
            results = this.narrow(candidates, contractOrImpl, name, false, onBehalfOf, qualifiers);
            if (!results.getErrors().isEmpty()) {
                currentErrorHandlers = new LinkedList<ErrorService>(this.errorHandlers);
            }
        }
        if (currentErrorHandlers != null) {
            Utilities.handleErrors(results, currentErrorHandlers);
        }
        if ((topDog = Utilities.getFirstThingInList(results.getResults())) == null) {
            return null;
        }
        return this.getServiceHandle(topDog);
    }

    public <T> ServiceHandle<T> getServiceHandle(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        return this.internalGetServiceHandle(null, contractOrImpl, null, qualifiers);
    }

    private List<ServiceHandle<?>> protectedGetAllServiceHandles(final Type contractOrImpl, final Annotation ... qualifiers) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<ServiceHandle<?>>>(){

            @Override
            public List<ServiceHandle<?>> run() {
                return ServiceLocatorImpl.this.getAllServiceHandles(contractOrImpl, qualifiers);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceHandle<?>> getAllServiceHandles(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        NarrowResults results;
        if (contractOrImpl == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        Class<?> rawClass = Utilities.getRawClass(contractOrImpl);
        if (rawClass == null) {
            throw new MultiException((Throwable)new IllegalArgumentException("Type must be a class or parameterized type, it was " + contractOrImpl));
        }
        IndexedFilter filter = BuilderHelper.createContractFilter((String)rawClass.getName());
        LinkedList<ErrorService> currentErrorHandlers = null;
        Object object = this.lock;
        synchronized (object) {
            List<ActiveDescriptor<?>> candidates = this.getDescriptors((Filter)filter);
            results = this.narrow(candidates, contractOrImpl, null, true, null, qualifiers);
            if (!results.getErrors().isEmpty()) {
                currentErrorHandlers = new LinkedList<ErrorService>(this.errorHandlers);
            }
        }
        if (currentErrorHandlers != null) {
            Utilities.handleErrors(results, currentErrorHandlers);
        }
        LinkedList retVal = new LinkedList();
        for (ActiveDescriptor<?> candidate : results.getResults()) {
            retVal.add(this.getServiceHandle(candidate));
        }
        return retVal;
    }

    public <T> ServiceHandle<T> getServiceHandle(Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        return this.internalGetServiceHandle(null, contractOrImpl, name, qualifiers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServiceHandle<?>> getAllServiceHandles(Filter searchCriteria) throws MultiException {
        NarrowResults results;
        this.checkState();
        LinkedList<ErrorService> currentErrorHandlers = null;
        Object object = this.lock;
        synchronized (object) {
            List<ActiveDescriptor<?>> candidates = this.getDescriptors(searchCriteria);
            results = this.narrow(candidates, null, null, true, null, new Annotation[0]);
            if (!results.getErrors().isEmpty()) {
                currentErrorHandlers = new LinkedList<ErrorService>(this.errorHandlers);
            }
        }
        if (currentErrorHandlers != null) {
            Utilities.handleErrors(results, currentErrorHandlers);
        }
        TreeSet retVal = new TreeSet(HANDLE_COMPARATOR);
        for (ActiveDescriptor<?> candidate : results.getResults()) {
            retVal.add(this.getServiceHandle(candidate));
        }
        return new LinkedList(retVal);
    }

    private SortedSet<SystemDescriptor<?>> checkConfiguration(DynamicConfigurationImpl dci) {
        TreeSet<Descriptor> retVal = new TreeSet<Descriptor>(DESCRIPTOR_COMPARATOR);
        for (Filter filter : dci.getUnbindFilters()) {
            List<ActiveDescriptor<?>> results = this.getDescriptors(filter, null, false);
            for (ActiveDescriptor<?> result : results) {
                SystemDescriptor candidate = (SystemDescriptor)result;
                if (retVal.contains(candidate)) continue;
                for (ValidationService vs : this.allValidators) {
                    if (vs.getValidator().validate(Operation.UNBIND, (ActiveDescriptor)candidate, null)) continue;
                    throw new MultiException((Throwable)new IllegalArgumentException("Descriptor " + candidate + " did not pass the UNBIND validation"));
                }
                retVal.add((Descriptor)candidate);
            }
        }
        for (SystemDescriptor systemDescriptor : dci.getAllDescriptors()) {
            boolean checkScope = false;
            if (systemDescriptor.getAdvertisedContracts().contains(ValidationService.class.getName()) || systemDescriptor.getAdvertisedContracts().contains(ErrorService.class.getName())) {
                this.reifyDescriptor((Descriptor)systemDescriptor);
                checkScope = true;
            }
            if (systemDescriptor.getAdvertisedContracts().contains(InjectionResolver.class.getName())) {
                this.reifyDescriptor((Descriptor)systemDescriptor);
                checkScope = true;
                if (Utilities.getInjectionResolverType(systemDescriptor) == null) {
                    throw new MultiException((Throwable)new IllegalArgumentException("An implementation of InjectionResolver must be a parameterized type and the actual type must be an annotation"));
                }
            }
            if (systemDescriptor.getAdvertisedContracts().contains(Context.class.getName())) {
                checkScope = true;
            }
            if (checkScope) {
                String scope;
                String string = scope = systemDescriptor.getScope() == null ? PerLookup.class.getName() : systemDescriptor.getScope();
                if (!scope.equals(Singleton.class.getName())) {
                    throw new MultiException((Throwable)new IllegalArgumentException("The implementation class " + systemDescriptor.getImplementation() + " must be in the Singleton scope"));
                }
            }
            for (ValidationService vs : this.allValidators) {
                if (vs.getValidator().validate(Operation.BIND, (ActiveDescriptor)systemDescriptor, null)) continue;
                throw new MultiException((Throwable)new IllegalArgumentException("Descriptor " + systemDescriptor + " did not pass the BIND validation"));
            }
        }
        return retVal;
    }

    private void removeConfigurationInternal(SortedSet<SystemDescriptor<?>> unbinds) {
        for (SystemDescriptor systemDescriptor : unbinds) {
            LinkedList<SystemDescriptor<?>> byName;
            this.allDescriptors.remove(systemDescriptor);
            for (String advertisedContract : systemDescriptor.getAdvertisedContracts()) {
                LinkedList<SystemDescriptor<?>> byImpl = this.descriptorsByAdvertisedContract.get(advertisedContract);
                if (byImpl == null) continue;
                byImpl.remove(systemDescriptor);
                if (!byImpl.isEmpty()) continue;
                this.descriptorsByAdvertisedContract.remove(advertisedContract);
            }
            String unbindName = systemDescriptor.getName();
            if (unbindName != null && (byName = this.descriptorsByName.get(unbindName)) != null) {
                byName.remove(systemDescriptor);
                if (byName.isEmpty()) {
                    this.descriptorsByName.remove(unbindName);
                }
            }
            if (!systemDescriptor.getAdvertisedContracts().contains(ValidationService.class.getName())) continue;
            ServiceHandle handle = this.getServiceHandle(systemDescriptor);
            ValidationService vs = (ValidationService)handle.getService();
            this.allValidators.remove(vs);
        }
    }

    private void addConfigurationInternal(DynamicConfigurationImpl dci) {
        for (SystemDescriptor systemDescriptor : dci.getAllDescriptors()) {
            this.allDescriptors.add(systemDescriptor);
            for (String advertisedContract : systemDescriptor.getAdvertisedContracts()) {
                LinkedList<SystemDescriptor<Object>> byImpl = this.descriptorsByAdvertisedContract.get(advertisedContract);
                if (byImpl == null) {
                    byImpl = new LinkedList();
                    this.descriptorsByAdvertisedContract.put(advertisedContract, byImpl);
                }
                byImpl.add(systemDescriptor);
            }
            if (systemDescriptor.getName() != null) {
                String name = systemDescriptor.getName();
                LinkedList<SystemDescriptor<Object>> byName = this.descriptorsByName.get(name);
                if (byName == null) {
                    byName = new LinkedList();
                    this.descriptorsByName.put(name, byName);
                }
                byName.add(systemDescriptor);
            }
            if (!systemDescriptor.getAdvertisedContracts().contains(ValidationService.class.getName())) continue;
            ServiceHandle handle = this.getServiceHandle(systemDescriptor);
            ValidationService vs = (ValidationService)handle.getService();
            this.allValidators.add(vs);
        }
    }

    private void reupInjectionResolvers() {
        HashMap<Class<? extends Annotation>, InjectionResolver> newResolvers = new HashMap<Class<? extends Annotation>, InjectionResolver>();
        IndexedFilter injectionResolverFilter = BuilderHelper.createContractFilter((String)InjectionResolver.class.getName());
        List<ActiveDescriptor<?>> resolverDescriptors = this.protectedGetDescriptors((Filter)injectionResolverFilter);
        for (ActiveDescriptor<?> resolverDescriptor : resolverDescriptors) {
            Class<? extends Annotation> iResolve = Utilities.getInjectionResolverType(resolverDescriptor);
            if (iResolve == null || newResolvers.containsKey(iResolve)) continue;
            InjectionResolver resolver = (InjectionResolver)this.getServiceHandle(resolverDescriptor).getService();
            newResolvers.put(iResolve, resolver);
        }
        this.allResolvers.clear();
        this.allResolvers.putAll(newResolvers);
    }

    private void reupErrorHandlers() {
        List allErrorServices = this.protectedGetAllServices((Type)((Object)ErrorService.class), new Annotation[0]);
        this.errorHandlers.clear();
        this.errorHandlers.addAll(allErrorServices);
    }

    private void reup() {
        this.reupInjectionResolvers();
        this.reupErrorHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConfiguration(DynamicConfigurationImpl dci) {
        Object object = this.lock;
        synchronized (object) {
            SortedSet<SystemDescriptor<?>> unbinds = this.checkConfiguration(dci);
            this.removeConfigurationInternal(unbinds);
            this.addConfigurationInternal(dci);
            this.reup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInjectAnnotation(Annotation annotation) {
        Object object = this.lock;
        synchronized (object) {
            return this.allResolvers.containsKey(annotation.annotationType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InjectionResolver<?> getInjectionResolver(Class<? extends Annotation> annoType) {
        Object object = this.lock;
        synchronized (object) {
            return this.allResolvers.get(annoType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Context<?> resolveContext(Class<? extends Annotation> scope) throws IllegalStateException {
        if (scope.equals(Singleton.class)) {
            return this.singletonContext;
        }
        if (scope.equals(PerLookup.class)) {
            return this.perLookupContext;
        }
        Type[] actuals = new Type[]{scope};
        ParameterizedTypeImpl findContext = new ParameterizedTypeImpl((Type)((Object)Context.class), actuals);
        List contextHandles = (List)Utilities.cast(this.protectedGetAllServiceHandles(findContext, new Annotation[0]));
        try {
            Context retVal = null;
            for (ServiceHandle contextHandle : contextHandles) {
                Context context = (Context)contextHandle.getService();
                if (!context.isActive()) continue;
                if (retVal != null) {
                    throw new IllegalStateException("There is more than one active context for " + scope.getName());
                }
                retVal = context;
            }
            Context context = retVal;
            return context;
        }
        finally {
            for (ServiceHandle contextHandle : contextHandles) {
                contextHandle.destroy();
            }
        }
    }

    private Class<?> loadClass(Descriptor descriptor, Injectee injectee) {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        HK2Loader loader = descriptor.getLoader();
        if (loader == null) {
            return Utilities.loadClass(descriptor.getImplementation(), injectee);
        }
        return loader.loadClass(descriptor.getImplementation());
    }

    private NarrowResults narrow(List<ActiveDescriptor<?>> candidates, Type requiredType, String name, boolean getAll, Injectee injectee, Annotation ... qualifiers) {
        NarrowResults retVal = new NarrowResults();
        Set<Annotation> requiredAnnotations = Utilities.fixAndCheckQualifiers(qualifiers, name);
        for (ActiveDescriptor<?> candidate : candidates) {
            if (!candidate.isReified()) {
                try {
                    candidate = this.reifyDescriptor((Descriptor)candidate, injectee);
                }
                catch (MultiException me) {
                    retVal.addError(candidate, injectee, me);
                    continue;
                }
                catch (Throwable th) {
                    retVal.addError(candidate, injectee, new MultiException(th));
                    continue;
                }
            }
            if (requiredType != null) {
                boolean safe = false;
                for (Type candidateType : candidate.getContractTypes()) {
                    if (!TypeChecker.isTypeSafe(requiredType, candidateType)) continue;
                    safe = true;
                    break;
                }
                if (!safe) continue;
            }
            Set candidateAnnotations = candidate.getQualifierAnnotations();
            if (!requiredAnnotations.isEmpty() && !Utilities.annotationContainsAll(candidateAnnotations, requiredAnnotations)) continue;
            retVal.addGoodResult(candidate);
            if (getAll) continue;
            break;
        }
        return retVal;
    }

    public long getLocatorId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextServiceId() {
        Object object = this.lock;
        synchronized (object) {
            return this.nextServiceId++;
        }
    }

    private void checkState() {
        if (this.shutdown) {
            throw new IllegalStateException(this + " has been shut down");
        }
    }

    public String toString() {
        return "ServiceLocatorImpl(" + this.locatorName + "," + this.id + "," + System.identityHashCode(this) + ")";
    }
}

