/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ValidationService;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.internal.ClazzCreator;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.Creator;
import org.jvnet.hk2.internal.FactoryCreator;
import org.jvnet.hk2.internal.Pretty;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.Utilities;

public class SystemDescriptor<T>
implements ActiveDescriptor<T> {
    private final Descriptor originalDescriptor;
    private final Descriptor baseDescriptor;
    private final Long id;
    private final ActiveDescriptor<T> activeDescriptor;
    private final Long locatorId;
    private boolean reified;
    private final Object cacheLock = new Object();
    private boolean cacheSet = false;
    private T cachedValue;
    private Class<?> implClass;
    private Class<? extends Annotation> scope;
    private Set<Type> contracts;
    private Set<Annotation> qualifiers;
    private Creator<T> creator;
    private final HashMap<ValidationService, Boolean> validationServiceCache = new HashMap();

    SystemDescriptor(Descriptor baseDescriptor, Long locatorId, Long serviceId) {
        this.originalDescriptor = baseDescriptor;
        this.baseDescriptor = BuilderHelper.deepCopyDescriptor((Descriptor)baseDescriptor);
        this.locatorId = locatorId;
        this.id = serviceId;
        if (baseDescriptor instanceof ActiveDescriptor) {
            ActiveDescriptor active = (ActiveDescriptor)baseDescriptor;
            if (active.isReified()) {
                this.activeDescriptor = active;
                this.reified = true;
            } else {
                this.activeDescriptor = null;
                this.reified = false;
            }
        } else {
            this.activeDescriptor = null;
            this.reified = false;
        }
    }

    public String getImplementation() {
        return this.baseDescriptor.getImplementation();
    }

    public Set<String> getAdvertisedContracts() {
        return this.baseDescriptor.getAdvertisedContracts();
    }

    public String getScope() {
        return this.baseDescriptor.getScope();
    }

    public String getName() {
        return this.baseDescriptor.getName();
    }

    public Set<String> getQualifiers() {
        return this.baseDescriptor.getQualifiers();
    }

    public DescriptorType getDescriptorType() {
        return this.baseDescriptor.getDescriptorType();
    }

    public Map<String, List<String>> getMetadata() {
        return this.baseDescriptor.getMetadata();
    }

    public HK2Loader getLoader() {
        return this.baseDescriptor.getLoader();
    }

    public int getRanking() {
        return this.baseDescriptor.getRanking();
    }

    public int setRanking(int ranking) {
        return this.baseDescriptor.setRanking(ranking);
    }

    public Descriptor getBaseDescriptor() {
        return this.originalDescriptor;
    }

    public Long getServiceId() {
        return this.id;
    }

    public T getCache() {
        return this.cachedValue;
    }

    public boolean isCacheSet() {
        return this.cacheSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(T cacheMe) {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cachedValue = cacheMe;
            this.cacheSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCache() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.cacheSet = false;
            this.cachedValue = null;
        }
    }

    public boolean isReified() {
        return this.reified;
    }

    public Class<?> getImplementationClass() {
        this.checkState();
        if (this.activeDescriptor != null) {
            return this.activeDescriptor.getImplementationClass();
        }
        return this.implClass;
    }

    public Set<Type> getContractTypes() {
        this.checkState();
        if (this.activeDescriptor != null) {
            return this.activeDescriptor.getContractTypes();
        }
        return this.contracts;
    }

    public Class<? extends Annotation> getScopeAnnotation() {
        this.checkState();
        if (this.activeDescriptor != null) {
            return this.activeDescriptor.getScopeAnnotation();
        }
        return this.scope;
    }

    public Set<Annotation> getQualifierAnnotations() {
        this.checkState();
        if (this.activeDescriptor != null) {
            return this.activeDescriptor.getQualifierAnnotations();
        }
        return this.qualifiers;
    }

    public List<Injectee> getInjectees() {
        this.checkState();
        if (this.activeDescriptor != null) {
            return this.activeDescriptor.getInjectees();
        }
        return this.creator.getInjectees();
    }

    public T create(ServiceHandle<?> root) {
        this.checkState();
        if (this.activeDescriptor != null) {
            return (T)this.activeDescriptor.create(root);
        }
        return this.creator.create(root);
    }

    public void dispose(T instance) {
        this.checkState();
        if (this.activeDescriptor != null) {
            this.activeDescriptor.dispose(instance);
            return;
        }
        this.creator.dispose(instance);
    }

    private void checkState() {
        if (!this.reified) {
            throw new IllegalStateException();
        }
    }

    void reify(Class<?> implClass, ServiceLocatorImpl locator, Collector collector) {
        String scopeName;
        this.implClass = implClass;
        if (this.getDescriptorType().equals((Object)DescriptorType.CLASS)) {
            this.qualifiers = Collections.unmodifiableSet(Utilities.getAllQualifiers(implClass, this.baseDescriptor.getName(), collector));
            this.creator = new ClazzCreator(locator, implClass, collector);
            this.scope = Utilities.getScopeAnnotationType(implClass, collector);
            this.contracts = Collections.unmodifiableSet(Utilities.getTypeClosure(implClass, this.baseDescriptor.getAdvertisedContracts()));
        } else {
            Utilities.checkFactoryType(implClass, collector);
            Method provideMethod = Utilities.getFactoryProvideMethod(implClass);
            if (provideMethod == null) {
                collector.addThrowable(new IllegalArgumentException("A non-factory descriptor returned type FACTORY"));
                return;
            }
            this.qualifiers = Collections.unmodifiableSet(Utilities.getAllQualifiers(provideMethod, Utilities.getDefaultNameFromMethod(provideMethod, collector), collector));
            this.creator = new FactoryCreator(locator, implClass);
            this.scope = Utilities.getScopeAnnotationType(provideMethod, collector);
            Type factoryProvidedType = provideMethod.getGenericReturnType();
            this.contracts = Collections.unmodifiableSet(Utilities.getTypeClosure(factoryProvidedType, this.baseDescriptor.getAdvertisedContracts()));
        }
        if (this.baseDescriptor.getScope() == null && this.scope == null) {
            this.scope = PerLookup.class;
        }
        if (this.baseDescriptor.getScope() != null && this.scope != null && !(scopeName = this.scope.getName()).equals(this.baseDescriptor.getScope())) {
            collector.addThrowable(new IllegalArgumentException("The scope name given in the descriptor (" + this.baseDescriptor.getScope() + ") did not match the scope annotation on the class (" + this.scope.getName() + ") in class " + Pretty.clazz(implClass)));
        }
        if (!collector.hasErrors()) {
            this.reified = true;
        }
    }

    public int hashCode() {
        int low32 = this.id.intValue();
        int high32 = (int)(this.id >> 32);
        int locatorLow32 = this.locatorId.intValue();
        int locatorHigh32 = (int)(this.locatorId >> 32);
        return this.baseDescriptor.hashCode() ^ low32 ^ high32 ^ locatorLow32 ^ locatorHigh32;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SystemDescriptor)) {
            return false;
        }
        SystemDescriptor sd = (SystemDescriptor)o;
        if (!sd.getServiceId().equals(this.id)) {
            return false;
        }
        if (!sd.getLocatorId().equals(this.locatorId)) {
            return false;
        }
        return sd.baseDescriptor.equals(this.baseDescriptor);
    }

    public Long getLocatorId() {
        return this.locatorId;
    }

    boolean isValidating(ValidationService service) {
        Boolean cachedResult = this.validationServiceCache.get(service);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean decision = true;
        try {
            decision = service.getLookupFilter().matches((Descriptor)this);
        }
        catch (Throwable th) {
            // empty catch block
        }
        if (decision) {
            this.validationServiceCache.put(service, Boolean.TRUE);
        } else {
            this.validationServiceCache.put(service, Boolean.FALSE);
        }
        return decision;
    }

    public String toString() {
        return "SystemDescriptor(" + this.getImplementation() + "," + Pretty.collection(this.getAdvertisedContracts()) + "," + Pretty.collection(this.getQualifiers()) + "," + System.identityHashCode(this) + ")";
    }
}

