/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.internal.NamedImpl;
import org.jvnet.hk2.internal.Pretty;
import org.jvnet.hk2.internal.Utilities;

public class IterableProviderImpl<T>
implements IterableProvider<T> {
    private final ServiceLocator locator;
    private final Type requiredType;
    private final Set<Annotation> requiredQualifiers;

    IterableProviderImpl(ServiceLocator locator, Type requiredType, Set<Annotation> requiredQualifiers) {
        this.locator = locator;
        this.requiredType = requiredType;
        this.requiredQualifiers = Collections.unmodifiableSet(requiredQualifiers);
    }

    public T get() {
        return (T)this.locator.getService(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()]));
    }

    public ServiceHandle<T> getHandle() {
        return this.locator.getServiceHandle(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()]));
    }

    public Iterator<T> iterator() {
        List handles = (List)Utilities.cast(this.locator.getAllServiceHandles(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()])));
        return new MyIterator(handles);
    }

    public int getSize() {
        return this.locator.getAllServiceHandles(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()])).size();
    }

    public IterableProvider<T> named(String name) {
        return this.qualifiedWith(new Annotation[]{new NamedImpl(name)});
    }

    public <U> IterableProvider<U> ofType(Type type) {
        return new IterableProviderImpl<T>(this.locator, type, this.requiredQualifiers);
    }

    public IterableProvider<T> qualifiedWith(Annotation ... qualifiers) {
        HashSet<Annotation> moreAnnotations = new HashSet<Annotation>(this.requiredQualifiers);
        for (Annotation qualifier : qualifiers) {
            moreAnnotations.add(qualifier);
        }
        return new IterableProviderImpl<T>(this.locator, this.requiredType, moreAnnotations);
    }

    public Iterable<ServiceHandle<T>> handleIterator() {
        List handles = (List)Utilities.cast(this.locator.getAllServiceHandles(this.requiredType, this.requiredQualifiers.toArray(new Annotation[this.requiredQualifiers.size()])));
        return new HandleIterable(handles);
    }

    public String toString() {
        return "IterableProviderImpl(" + Pretty.type(this.requiredType) + "," + Pretty.collection(this.requiredQualifiers) + "," + System.identityHashCode(this) + ")";
    }

    private static class MyHandleIterator<U>
    implements Iterator<ServiceHandle<U>> {
        private final LinkedList<ServiceHandle<U>> handles;

        private MyHandleIterator(List<ServiceHandle<U>> handles) {
            this.handles = new LinkedList<ServiceHandle<U>>(handles);
        }

        @Override
        public boolean hasNext() {
            return !this.handles.isEmpty();
        }

        @Override
        public ServiceHandle<U> next() {
            return this.handles.removeFirst();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class HandleIterable<U>
    implements Iterable<ServiceHandle<U>> {
        private final List<ServiceHandle<U>> handles;

        private HandleIterable(List<ServiceHandle<U>> handles) {
            this.handles = new LinkedList<ServiceHandle<U>>(handles);
        }

        @Override
        public Iterator<ServiceHandle<U>> iterator() {
            return new MyHandleIterator(this.handles);
        }
    }

    private static class MyIterator<U>
    implements Iterator<U> {
        private final LinkedList<ServiceHandle<U>> handles;

        private MyIterator(List<ServiceHandle<U>> handles) {
            this.handles = new LinkedList<ServiceHandle<U>>(handles);
        }

        @Override
        public boolean hasNext() {
            return !this.handles.isEmpty();
        }

        @Override
        public U next() {
            ServiceHandle<U> nextHandle = this.handles.removeFirst();
            return (U)nextHandle.getService();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

