/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.jvnet.hk2.internal.Creator;

public class AutoActiveDescriptor<T>
extends AbstractActiveDescriptor<T> {
    private final Class<?> implClass;
    private final Creator<T> creator;
    private final String implClassString;
    private final Object lock = new Object();
    private boolean isCacheSet = false;
    private T cachedValue;

    public AutoActiveDescriptor(Class<?> clazz, Creator<T> creator, Set<Type> advertisedContracts, Class<? extends Annotation> scope, String name, Set<Annotation> qualifiers, int ranking) {
        super(advertisedContracts, scope, name, qualifiers, DescriptorType.CLASS, ranking);
        this.implClass = clazz;
        this.creator = creator;
        this.implClassString = this.implClass.getName();
    }

    public Class<?> getImplementationClass() {
        return this.implClass;
    }

    public T create(ServiceHandle<?> root) {
        return this.creator.create(root);
    }

    public void dispose(T instance) {
        this.creator.dispose(instance);
    }

    public String getImplementation() {
        return this.implClassString;
    }

    public List<Injectee> getInjectees() {
        return this.creator.getInjectees();
    }

    public T getCache() {
        return this.cachedValue;
    }

    public boolean isCacheSet() {
        return this.isCacheSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(T cacheMe) {
        Object object = this.lock;
        synchronized (object) {
            this.cachedValue = cacheMe;
            this.isCacheSet = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseCache() {
        Object object = this.lock;
        synchronized (object) {
            this.isCacheSet = false;
            this.cachedValue = null;
        }
    }
}

