/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.ErrorInformation;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.ErrorType;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.Proxiable;
import org.glassfish.hk2.api.ProxyCtl;
import org.glassfish.hk2.api.Self;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.NamedImpl;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.internal.AutoActiveDescriptor;
import org.jvnet.hk2.internal.ClazzCreator;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.ConstantActiveDescriptor;
import org.jvnet.hk2.internal.Constants;
import org.jvnet.hk2.internal.ErrorInformationImpl;
import org.jvnet.hk2.internal.ErrorResults;
import org.jvnet.hk2.internal.InjecteeImpl;
import org.jvnet.hk2.internal.NarrowResults;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.ThreeThirtyResolver;

public class Utilities {
    private static final String PROVIDE_METHOD = "provide";
    private static final String CONVENTION_POST_CONSTRUCT = "postConstruct";
    private static final String CONVENTION_PRE_DESTROY = "preDestroy";

    public static Class<?> getFactoryAwareImplementationClass(ActiveDescriptor<?> descriptor) {
        if (descriptor.getDescriptorType().equals((Object)DescriptorType.CLASS)) {
            return descriptor.getImplementationClass();
        }
        return Utilities.getFactoryProductionClass(descriptor.getImplementationClass());
    }

    public static void checkLookupType(Class<?> checkMe) {
        if (!checkMe.isAnnotation()) {
            return;
        }
        if (checkMe.isAnnotationPresent(Scope.class)) {
            return;
        }
        if (checkMe.isAnnotationPresent(Qualifier.class)) {
            return;
        }
        throw new IllegalArgumentException("Lookup type " + checkMe + " must be a scope or annotation");
    }

    static boolean annotationContainsAll(final Set<Annotation> candidateAnnotations, final Set<Annotation> requiredAnnotations) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return candidateAnnotations.containsAll(requiredAnnotations);
            }
        });
    }

    private static Field[] getDeclaredFields(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static Method[] getDeclaredMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    static void setAccessible(final AccessibleObject ao) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ao.setAccessible(true);
                return null;
            }
        });
    }

    public static Class<?> translatePrimitiveType(Class<?> type) {
        Class<?> translation = Constants.PRIMITIVE_MAP.get(type);
        if (translation == null) {
            return type;
        }
        return translation;
    }

    public static void handleErrors(NarrowResults results, LinkedList<ErrorService> callThese) {
        Collector collector = new Collector();
        for (ErrorResults errorResult : results.getErrors()) {
            for (ErrorService eService : callThese) {
                try {
                    eService.onFailure((ErrorInformation)new ErrorInformationImpl(ErrorType.FAILURE_TO_REIFY, (Descriptor)errorResult.getDescriptor(), errorResult.getInjectee(), errorResult.getMe()));
                }
                catch (MultiException me) {
                    for (Throwable th : me.getErrors()) {
                        collector.addThrowable(th);
                    }
                }
                catch (Throwable th) {
                    collector.addThrowable(th);
                }
            }
        }
        collector.throwIfErrors();
    }

    public static Class<?> loadClass(String loadMe, Descriptor fromMe, Collector collector) {
        HK2Loader loader = fromMe.getLoader();
        if (loader == null) {
            ClassLoader cl = Utilities.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                return cl.loadClass(loadMe);
            }
            catch (Throwable th) {
                collector.addThrowable(th);
                return null;
            }
        }
        try {
            return loader.loadClass(loadMe);
        }
        catch (Throwable th) {
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                for (Throwable th2 : me.getErrors()) {
                    collector.addThrowable(th2);
                }
            } else {
                collector.addThrowable(th);
            }
            return null;
        }
    }

    public static Class<?> loadClass(String implementation, Injectee injectee) {
        AnnotatedElement parent;
        ClassLoader loader = injectee != null ? ((parent = injectee.getParent()) instanceof Constructor ? ((Constructor)parent).getDeclaringClass().getClassLoader() : (parent instanceof Method ? ((Method)parent).getDeclaringClass().getClassLoader() : (parent instanceof Field ? ((Field)parent).getDeclaringClass().getClassLoader() : injectee.getClass().getClassLoader()))) : Utilities.class.getClassLoader();
        try {
            return loader.loadClass(implementation);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    public static Class<? extends Annotation> getInjectionResolverType(ActiveDescriptor<?> desc) {
        for (Type advertisedType : desc.getContractTypes()) {
            Class rawClass = ReflectionHelper.getRawClass((Type)advertisedType);
            if (!InjectionResolver.class.equals((Object)rawClass)) continue;
            if (!(advertisedType instanceof ParameterizedType)) {
                return null;
            }
            Type firstType = Utilities.getFirstTypeArgument(advertisedType);
            if (!(firstType instanceof Class)) {
                return null;
            }
            Class retVal = (Class)firstType;
            if (!Annotation.class.isAssignableFrom(retVal)) {
                return null;
            }
            return retVal;
        }
        return null;
    }

    private static Class<?> getFactoryProductionClass(Class<?> factoryClass) {
        for (Type type : factoryClass.getGenericInterfaces()) {
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !Factory.class.equals((Object)rawClass)) continue;
            Type firstType = Utilities.getFirstTypeArgument(type);
            return ReflectionHelper.getRawClass((Type)firstType);
        }
        throw new MultiException((Throwable)new IllegalArgumentException(factoryClass.getName() + " is not a factory"));
    }

    public static void checkFactoryType(Class<?> factoryClass, Collector collector) {
        for (Type type : factoryClass.getGenericInterfaces()) {
            Type firstType;
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !Factory.class.equals((Object)rawClass) || !((firstType = Utilities.getFirstTypeArgument(type)) instanceof WildcardType)) continue;
            collector.addThrowable(new IllegalArgumentException("The class " + Pretty.clazz(factoryClass) + " has a Wildcard as its type"));
        }
    }

    private static Set<Type> getAutoAdvertisedTypes(Type t) {
        Class rawSuperclass;
        LinkedHashSet<Type> retVal = new LinkedHashSet<Type>();
        retVal.add(t);
        Class rawClass = ReflectionHelper.getRawClass((Type)t);
        if (rawClass == null) {
            return retVal;
        }
        Type genericSuperclass = rawClass.getGenericSuperclass();
        while (genericSuperclass != null && (rawSuperclass = ReflectionHelper.getRawClass((Type)genericSuperclass)) != null) {
            if (rawSuperclass.isAnnotationPresent(Contract.class)) {
                retVal.add(genericSuperclass);
            }
            genericSuperclass = rawSuperclass.getGenericSuperclass();
        }
        while (rawClass != null) {
            for (Type iface : rawClass.getGenericInterfaces()) {
                Class ifaceClass = ReflectionHelper.getRawClass((Type)iface);
                if (!ifaceClass.isAnnotationPresent(Contract.class)) continue;
                retVal.add(iface);
            }
            rawClass = rawClass.getSuperclass();
        }
        return retVal;
    }

    public static <T> ActiveDescriptor<T> createAutoDescriptor(Class<T> clazz, ServiceLocatorImpl locator) throws MultiException, IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        Set<Annotation> qualifiers = ReflectionHelper.getQualifierAnnotations(clazz);
        String name = Utilities.getNameFromAllQualifiers(qualifiers, clazz);
        qualifiers = Utilities.getAllQualifiers(clazz, name, collector);
        Set<Type> contracts = Utilities.getAutoAdvertisedTypes(clazz);
        ScopeInfo scopeInfo = Utilities.getScopeInfo(clazz, null, collector);
        Class scope = scopeInfo.getAnnoType();
        ClazzCreator creator = new ClazzCreator(locator, clazz, null, collector);
        collector.throwIfErrors();
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        if (scopeInfo.getScope() != null) {
            BuilderHelper.getMetadataValues((Annotation)scopeInfo.getScope(), metadata);
        }
        for (Annotation qualifier : qualifiers) {
            BuilderHelper.getMetadataValues((Annotation)qualifier, metadata);
        }
        return new AutoActiveDescriptor(clazz, creator, contracts, scope, name, qualifiers, 0, metadata);
    }

    public static void justPreDestroy(Object preMe) {
        if (preMe == null) {
            throw new IllegalArgumentException();
        }
        Class<?> baseClass = preMe.getClass();
        Collector collector = new Collector();
        Method preDestroy = Utilities.findPreDestroy(baseClass, collector);
        collector.throwIfErrors();
        if (preDestroy == null) {
            return;
        }
        Utilities.setAccessible(preDestroy);
        try {
            ReflectionHelper.invoke((Object)preMe, (Method)preDestroy, (Object[])new Object[0]);
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justPostConstruct(Object postMe) {
        if (postMe == null) {
            throw new IllegalArgumentException();
        }
        Class<?> baseClass = postMe.getClass();
        Collector collector = new Collector();
        Method postConstruct = Utilities.findPostConstruct(baseClass, collector);
        collector.throwIfErrors();
        if (postConstruct == null) {
            return;
        }
        Utilities.setAccessible(postConstruct);
        try {
            ReflectionHelper.invoke((Object)postMe, (Method)postConstruct, (Object[])new Object[0]);
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justInject(Object injectMe, ServiceLocatorImpl locator) {
        InjectionResolver<?> resolver;
        if (injectMe == null) {
            throw new IllegalArgumentException();
        }
        Class<?> baseClass = injectMe.getClass();
        Collector collector = new Collector();
        Set<Field> fields = Utilities.findInitializerFields(baseClass, locator, collector);
        Set<Method> methods = Utilities.findInitializerMethods(baseClass, locator, collector);
        collector.throwIfErrors();
        for (Field field : fields) {
            resolver = Utilities.getInjectionResolver(locator, field);
            List<Injectee> injecteeFields = Utilities.getFieldInjectees(field);
            Utilities.validateSelfInjectees(null, injecteeFields, collector);
            collector.throwIfErrors();
            Injectee injectee = injecteeFields.get(0);
            Object fieldValue = resolver.resolve(injectee, null);
            Utilities.setAccessible(field);
            try {
                field.set(injectMe, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new MultiException((Throwable)e);
            }
        }
        for (Method method : methods) {
            resolver = Utilities.getInjectionResolver(locator, method);
            List<Injectee> injectees = Utilities.getMethodInjectees(method);
            Utilities.validateSelfInjectees(null, injectees, collector);
            collector.throwIfErrors();
            Object[] args = new Object[injectees.size()];
            for (Injectee injectee : injectees) {
                args[injectee.getPosition()] = resolver.resolve(injectee, null);
            }
            Utilities.setAccessible(method);
            try {
                ReflectionHelper.invoke((Object)injectMe, (Method)method, (Object[])args);
            }
            catch (Throwable e) {
                throw new MultiException(e);
            }
        }
    }

    public static <T> T justCreate(Class<T> createMe, ServiceLocatorImpl locator) {
        if (createMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        Constructor<?> c = Utilities.findProducerConstructor(createMe, locator, collector);
        collector.throwIfErrors();
        InjectionResolver<?> resolver = Utilities.getInjectionResolver(locator, c);
        List<Injectee> injectees = Utilities.getConstructorInjectees(c);
        Utilities.validateSelfInjectees(null, injectees, collector);
        collector.throwIfErrors();
        Object[] args = new Object[injectees.size()];
        for (Injectee injectee : injectees) {
            args[injectee.getPosition()] = resolver.resolve(injectee, null);
        }
        Utilities.setAccessible(c);
        try {
            return (T)Utilities.makeMe(c, args);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    public static Class<?>[] getInterfacesForProxy(Set<Type> contracts) {
        LinkedList<Class> retVal = new LinkedList<Class>();
        retVal.add(ProxyCtl.class);
        for (Type type : contracts) {
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !rawClass.isInterface()) continue;
            retVal.add(rawClass);
        }
        return retVal.toArray(new Class[retVal.size()]);
    }

    public static boolean isProxiableScope(Class<? extends Annotation> scope) {
        return scope.isAnnotationPresent(Proxiable.class);
    }

    public static <T> T getFirstThingInList(List<T> set) {
        Iterator<T> i$ = set.iterator();
        if (i$.hasNext()) {
            T t = i$.next();
            return t;
        }
        return null;
    }

    private static Set<Field> getAllFields(Class<?> clazz, Collector collector) {
        HashSet<Field> retVal = new HashSet<Field>();
        HashSet<MemberKey> keys = new HashSet<MemberKey>();
        Utilities.getAllFieldKeys(clazz, keys, collector);
        for (MemberKey key : keys) {
            retVal.add((Field)key.getBackingMember());
        }
        return retVal;
    }

    private static void getAllFieldKeys(Class<?> clazz, Set<MemberKey> currentFields, Collector collector) {
        if (clazz == null) {
            return;
        }
        Utilities.getAllFieldKeys(clazz.getSuperclass(), currentFields, collector);
        try {
            for (Field field : Utilities.getDeclaredFields(clazz)) {
                currentFields.add(new MemberKey(field));
            }
        }
        catch (Throwable th) {
            collector.addThrowable(new IllegalStateException("Error while getting fields of class " + clazz.getName()));
            collector.addThrowable(th);
        }
    }

    public static ActiveDescriptor<ServiceLocator> getLocatorDescriptor(ServiceLocator locator) {
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.add((Type)((Object)ServiceLocator.class));
        Set<Annotation> qualifiers = Collections.emptySet();
        ConstantActiveDescriptor<ServiceLocator> retVal = new ConstantActiveDescriptor<ServiceLocator>(locator, contracts, PerLookup.class, null, qualifiers, 0, locator.getLocatorId(), null);
        return retVal;
    }

    public static ActiveDescriptor<InjectionResolver<Inject>> getThreeThirtyDescriptor(ServiceLocatorImpl locator) {
        ThreeThirtyResolver threeThirtyResolver = new ThreeThirtyResolver(locator);
        HashSet<Type> contracts = new HashSet<Type>();
        Type[] actuals = new Type[]{Inject.class};
        contracts.add((Type)new ParameterizedTypeImpl(InjectionResolver.class, actuals));
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new NamedImpl("SystemInjectResolver"));
        ConstantActiveDescriptor<ThreeThirtyResolver> retVal = new ConstantActiveDescriptor<ThreeThirtyResolver>(threeThirtyResolver, contracts, Singleton.class, "SystemInjectResolver", qualifiers, 0, locator.getLocatorId(), null);
        return retVal;
    }

    public static Constructor<?> findProducerConstructor(Class<?> annotatedType, ServiceLocatorImpl locator, Collector collector) {
        Constructor<?> zeroArgConstructor = null;
        Constructor<?> aConstructorWithInjectAnnotation = null;
        Set<Constructor<?>> allConstructors = Utilities.getAllConstructors(annotatedType);
        for (Constructor<?> constructor : allConstructors) {
            Type[] rawParameters = constructor.getGenericParameterTypes();
            if (rawParameters.length <= 0) {
                zeroArgConstructor = constructor;
            }
            if (Utilities.getInjectAnnotation(locator, constructor, true) != null) {
                if (aConstructorWithInjectAnnotation != null) {
                    collector.addThrowable(new IllegalArgumentException("There is more than one constructor on class " + Pretty.clazz(annotatedType)));
                    return null;
                }
                aConstructorWithInjectAnnotation = constructor;
            }
            if (Utilities.isProperConstructor(constructor)) continue;
            collector.addThrowable(new IllegalArgumentException("The constructor for " + Pretty.clazz(annotatedType) + " may not have an annotation as a parameter"));
            return null;
        }
        if (aConstructorWithInjectAnnotation != null) {
            return aConstructorWithInjectAnnotation;
        }
        if (zeroArgConstructor == null) {
            collector.addThrowable(new IllegalArgumentException("The class " + Pretty.clazz(annotatedType) + " has no constructor marked @Inject and no zero argument constructor"));
            return null;
        }
        return zeroArgConstructor;
    }

    private static boolean isProperConstructor(Constructor<?> c) {
        for (Class<?> pClazz : c.getParameterTypes()) {
            if (!pClazz.isAnnotation()) continue;
            return false;
        }
        return true;
    }

    public static Type getFirstTypeArgument(Type type) {
        if (type instanceof Class) {
            return Object.class;
        }
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] arguments = pt.getActualTypeArguments();
        if (arguments.length <= 0) {
            return Object.class;
        }
        return arguments[0];
    }

    private static Set<Constructor<?>> getAllConstructors(Class<?> clazz) {
        HashSet retVal = new HashSet();
        HashSet<MemberKey> keys = new HashSet<MemberKey>();
        Utilities.getAllConstructorKeys(clazz, keys);
        for (MemberKey key : keys) {
            retVal.add((Constructor)key.getBackingMember());
        }
        return retVal;
    }

    private static void getAllConstructorKeys(Class<?> clazz, Set<MemberKey> currentConstructors) {
        if (clazz == null) {
            return;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            currentConstructors.add(new MemberKey(constructor));
        }
    }

    private static Set<Method> getAllMethods(Class<?> clazz) {
        HashSet<Method> retVal = new HashSet<Method>();
        HashSet<MemberKey> keys = new HashSet<MemberKey>();
        Utilities.getAllMethodKeys(clazz, keys);
        for (MemberKey key : keys) {
            retVal.add((Method)key.getBackingMember());
        }
        return retVal;
    }

    private static void getAllMethodKeys(Class<?> clazz, Set<MemberKey> currentMethods) {
        if (clazz == null) {
            return;
        }
        Utilities.getAllMethodKeys(clazz.getSuperclass(), currentMethods);
        for (Method method : Utilities.getDeclaredMethods(clazz)) {
            currentMethods.add(new MemberKey(method));
        }
    }

    public static Set<Method> findInitializerMethods(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        HashSet<Method> retVal = new HashSet<Method>();
        for (Method method : Utilities.getAllMethods(annotatedType)) {
            if (Utilities.getInjectAnnotation(locator, method, true) == null) continue;
            if (!Utilities.isProperMethod(method)) {
                errorCollector.addThrowable(new IllegalArgumentException("An initializer method " + Pretty.method((Method)method) + " is static, abstract or has a parameter that is an annotation"));
                continue;
            }
            retVal.add(method);
        }
        return retVal;
    }

    public static Set<Field> findInitializerFields(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        HashSet<Field> retVal = new HashSet<Field>();
        for (Field field : Utilities.getAllFields(annotatedType, errorCollector)) {
            if (Utilities.getInjectAnnotation(locator, field, false) == null) continue;
            if (!Utilities.isProperField(field)) {
                errorCollector.addThrowable(new IllegalArgumentException("The field " + Pretty.field((Field)field) + " may not be static, final or have an Annotation type"));
                continue;
            }
            retVal.add(field);
        }
        return retVal;
    }

    private static Annotation getInjectAnnotation(ServiceLocatorImpl locator, AnnotatedElement annotated, boolean checkParams) {
        Annotation[][] allAnnotations;
        boolean isConstructor;
        for (Annotation anno : annotated.getAnnotations()) {
            if (!locator.isInjectAnnotation(anno)) continue;
            return anno;
        }
        if (!checkParams) {
            return null;
        }
        if (annotated instanceof Method) {
            Method m = (Method)annotated;
            isConstructor = false;
            allAnnotations = m.getParameterAnnotations();
        } else if (annotated instanceof Constructor) {
            Constructor c = (Constructor)annotated;
            isConstructor = true;
            allAnnotations = c.getParameterAnnotations();
        } else {
            return null;
        }
        Annotation[][] arr$ = allAnnotations;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] allParamAnnotations;
            for (Annotation paramAnno : allParamAnnotations = arr$[i$]) {
                if (!locator.isInjectAnnotation(paramAnno, isConstructor)) continue;
                return paramAnno;
            }
        }
        return null;
    }

    private static boolean isProperMethod(Method member) {
        if (ReflectionHelper.isStatic((Member)member)) {
            return false;
        }
        if (Utilities.isAbstract(member)) {
            return false;
        }
        for (Class<?> paramClazz : member.getParameterTypes()) {
            if (!paramClazz.isAnnotation()) continue;
            return false;
        }
        return true;
    }

    private static boolean isProperField(Field field) {
        if (ReflectionHelper.isStatic((Member)field)) {
            return false;
        }
        if (Utilities.isFinal(field)) {
            return false;
        }
        Class<?> type = field.getType();
        return !type.isAnnotation();
    }

    public static boolean isPrivate(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 2) != 0;
    }

    public static boolean isAbstract(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x400) != 0;
    }

    public static boolean isFinal(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x10) != 0;
    }

    private static ScopeInfo getScopeInfo(AnnotatedElement annotatedGuy, Descriptor defaultScope, Collector collector) {
        Class<?> descScope;
        Class topLevelElement = annotatedGuy;
        Annotation winnerScope = null;
        block0: while (annotatedGuy != null) {
            Annotation current = Utilities.internalGetScopeAnnotationType(annotatedGuy, collector);
            if (current != null) {
                if (annotatedGuy.equals(topLevelElement)) {
                    winnerScope = current;
                    break;
                }
                if (!current.annotationType().isAnnotationPresent(Inherited.class)) break;
                winnerScope = current;
                break;
            }
            if (annotatedGuy instanceof Class) {
                annotatedGuy = ((Class)annotatedGuy).getSuperclass();
                continue;
            }
            Method theMethod = (Method)annotatedGuy;
            Class<?> methodClass = theMethod.getDeclaringClass();
            annotatedGuy = null;
            for (Class<?> methodSuperclass = methodClass.getSuperclass(); methodSuperclass != null; methodSuperclass = methodSuperclass.getSuperclass()) {
                if (!Factory.class.isAssignableFrom(methodSuperclass)) continue;
                annotatedGuy = Utilities.getFactoryProvideMethod(methodSuperclass);
                continue block0;
            }
        }
        if (winnerScope != null) {
            return new ScopeInfo(winnerScope, winnerScope.annotationType());
        }
        if (topLevelElement.isAnnotationPresent(Service.class)) {
            return new ScopeInfo(null, Singleton.class);
        }
        if (defaultScope != null && defaultScope.getScope() != null && (descScope = Utilities.loadClass(defaultScope.getScope(), defaultScope, collector)) != null) {
            return new ScopeInfo(null, descScope);
        }
        return new ScopeInfo(null, PerLookup.class);
    }

    public static Class<? extends Annotation> getScopeAnnotationType(Class<?> fromThis, Descriptor defaultScope) {
        Collector collector = new Collector();
        ScopeInfo si = Utilities.getScopeInfo(fromThis, defaultScope, collector);
        collector.throwIfErrors();
        return si.getAnnoType();
    }

    public static Class<? extends Annotation> getScopeAnnotationType(AnnotatedElement annotatedGuy, Descriptor defaultScope, Collector collector) {
        ScopeInfo si = Utilities.getScopeInfo(annotatedGuy, defaultScope, collector);
        return si.getAnnoType();
    }

    private static Annotation internalGetScopeAnnotationType(AnnotatedElement annotatedGuy, Collector collector) {
        boolean epicFail = false;
        Annotation retVal = null;
        for (Annotation annotation : annotatedGuy.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Scope.class)) continue;
            if (retVal != null) {
                collector.addThrowable(new IllegalArgumentException("The type " + annotatedGuy + " may not have more than one scope.  It has at least " + Pretty.clazz(retVal.annotationType()) + " and " + Pretty.clazz(annotation.annotationType())));
                epicFail = true;
                continue;
            }
            retVal = annotation;
        }
        if (epicFail) {
            return null;
        }
        return retVal;
    }

    public static InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, AnnotatedElement annotatedGuy) throws IllegalStateException {
        Annotation injectAnnotation = Utilities.getInjectAnnotation(locator, annotatedGuy, true);
        Class injectType = injectAnnotation == null ? Inject.class : injectAnnotation.annotationType();
        InjectionResolver<?> retVal = locator.getInjectionResolver(injectType);
        if (retVal == null) {
            throw new IllegalStateException("There is no installed injection resolver for " + Pretty.clazz(injectType) + " for type " + annotatedGuy);
        }
        return retVal;
    }

    public static Method getFactoryProvideMethod(Class<?> clazz) {
        try {
            return clazz.getMethod(PROVIDE_METHOD, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static String getNameFromAllQualifiers(Set<Annotation> qualifiers, AnnotatedElement parent) {
        for (Annotation qualifier : qualifiers) {
            if (!Named.class.equals(qualifier.annotationType())) continue;
            Named named = (Named)qualifier;
            if (named.value() == null || named.value().equals("")) {
                if (parent instanceof Class) {
                    return Pretty.clazz((Class)((Class)parent));
                }
                throw new MultiException((Throwable)new IllegalStateException("@Named must have a value for " + parent));
            }
            return named.value();
        }
        return null;
    }

    public static String getDefaultNameFromMethod(Method parent, Collector collector) {
        Named named = parent.getAnnotation(Named.class);
        if (named == null) {
            return null;
        }
        if (named.value() == null || named.value().equals("")) {
            collector.addThrowable(new IllegalArgumentException("@Named on the provide method of a factory must have an explicit value"));
        }
        return named.value();
    }

    public static Set<Annotation> getAllQualifiers(AnnotatedElement annotatedGuy, String name, Collector collector) {
        Named namedQualifier = null;
        Set retVal = ReflectionHelper.getQualifierAnnotations((AnnotatedElement)annotatedGuy);
        for (Annotation anno : retVal) {
            if (!(anno instanceof Named)) continue;
            namedQualifier = (Named)anno;
            break;
        }
        if (name == null) {
            if (namedQualifier != null) {
                collector.addThrowable(new IllegalArgumentException("No name was in the descriptor, but this element(" + annotatedGuy + " has a Named annotation with value: " + namedQualifier.value()));
                retVal.remove(namedQualifier);
            }
            return retVal;
        }
        if (namedQualifier == null || namedQualifier.value().equals("")) {
            if (namedQualifier != null) {
                retVal.remove(namedQualifier);
            }
            namedQualifier = new NamedImpl(name);
            retVal.add(namedQualifier);
        }
        if (!name.equals(namedQualifier.value())) {
            collector.addThrowable(new IllegalArgumentException("The class had an @Named qualifier that was inconsistent.  The expected name is " + name + " but the annotation has name " + namedQualifier.value()));
        }
        return retVal;
    }

    private static Set<Annotation> getAllQualifiers(Annotation[] memberAnnotations) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        for (Annotation annotation : memberAnnotations) {
            if (!ReflectionHelper.isAnnotationAQualifier((Annotation)annotation)) continue;
            retVal.add(annotation);
        }
        return retVal;
    }

    private static boolean isOptional(Annotation[] memberAnnotations) {
        for (Annotation annotation : memberAnnotations) {
            if (!annotation.annotationType().equals(Optional.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelf(Annotation[] memberAnnotations) {
        for (Annotation annotation : memberAnnotations) {
            if (!annotation.annotationType().equals(Self.class)) continue;
            return true;
        }
        return false;
    }

    public static List<Injectee> getConstructorInjectees(Constructor<?> c) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        for (int lcv = 0; lcv < genericTypeParams.length; ++lcv) {
            retVal.add(new InjecteeImpl(genericTypeParams[lcv], Utilities.getAllQualifiers(paramAnnotations[lcv]), lcv, c, Utilities.isOptional(paramAnnotations[lcv]), Utilities.isSelf(paramAnnotations[lcv])));
        }
        return retVal;
    }

    public static List<Injectee> getMethodInjectees(Method c) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        for (int lcv = 0; lcv < genericTypeParams.length; ++lcv) {
            retVal.add(new InjecteeImpl(genericTypeParams[lcv], Utilities.getAllQualifiers(paramAnnotations[lcv]), lcv, c, Utilities.isOptional(paramAnnotations[lcv]), Utilities.isSelf(paramAnnotations[lcv])));
        }
        return retVal;
    }

    public static List<Injectee> getFieldInjectees(Field f) {
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        retVal.add(new InjecteeImpl(f.getGenericType(), ReflectionHelper.getQualifierAnnotations((AnnotatedElement)f), -1, f, Utilities.isOptional(f.getAnnotations()), Utilities.isSelf(f.getAnnotations())));
        return retVal;
    }

    public static void validateSelfInjectees(ActiveDescriptor<?> givenDescriptor, List<Injectee> injectees, Collector collector) {
        for (Injectee injectee : injectees) {
            if (!injectee.isSelf()) continue;
            Class requiredRawClass = ReflectionHelper.getRawClass((Type)injectee.getRequiredType());
            if (requiredRawClass == null || !ActiveDescriptor.class.equals((Object)requiredRawClass)) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " does not have the required type of ActiveDescriptor"));
            }
            if (injectee.isOptional()) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " is marked both @Optional and @Self"));
            }
            if (!injectee.getRequiredQualifiers().isEmpty()) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " is marked @Self but has other qualifiers"));
            }
            if (givenDescriptor != null) continue;
            collector.addThrowable(new IllegalArgumentException("A class with injection point " + injectee + " is being created or injected via the non-managed ServiceLocator API"));
        }
    }

    public static Method findPostConstruct(Class<?> clazz, Collector collector) {
        if (org.glassfish.hk2.api.PostConstruct.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Method method : Utilities.getAllMethods(clazz)) {
            if (method.isAnnotationPresent(PostConstruct.class)) {
                if (method.getParameterTypes().length != 0) {
                    collector.addThrowable(new IllegalArgumentException("The method " + Pretty.method((Method)method) + " annotated with @PostConstruct must not have any arguments"));
                    return null;
                }
                return method;
            }
            if (method.getParameterTypes().length != 0 || !method.getName().equals(CONVENTION_POST_CONSTRUCT)) continue;
            return method;
        }
        return null;
    }

    public static Method findPreDestroy(Class<?> clazz, Collector collector) {
        if (PreDestroy.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Method method : Utilities.getAllMethods(clazz)) {
            if (method.isAnnotationPresent(javax.annotation.PreDestroy.class)) {
                if (method.getParameterTypes().length != 0) {
                    collector.addThrowable(new IllegalArgumentException("The method " + Pretty.method((Method)method) + " annotated with @PreDestroy must not have any arguments"));
                    return null;
                }
                return method;
            }
            if (method.getParameterTypes().length != 0 || !method.getName().equals(CONVENTION_PRE_DESTROY)) continue;
            return method;
        }
        return null;
    }

    public static Object makeMe(Constructor<?> c, Object[] args) throws Throwable {
        ClassLoader currentCCL = Thread.currentThread().getContextClassLoader();
        try {
            Object obj = c.newInstance(args);
            return obj;
        }
        catch (InvocationTargetException ite) {
            Throwable targetException = ite.getTargetException();
            Logger.getLogger().debug(c.getDeclaringClass().getName(), c.getName(), targetException);
            throw targetException;
        }
        catch (Throwable th) {
            Logger.getLogger().debug(c.getDeclaringClass().getName(), c.getName(), th);
            throw th;
        }
        finally {
            ReflectionHelper.setContextClassLoader((Thread)Thread.currentThread(), (ClassLoader)currentCCL);
        }
    }

    public static Set<Annotation> fixAndCheckQualifiers(Annotation[] qualifiers, String name) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        HashSet<String> dupChecker = new HashSet<String>();
        Named named = null;
        for (Annotation qualifier : qualifiers) {
            String annotationType = qualifier.annotationType().getName();
            if (dupChecker.contains(annotationType)) {
                throw new IllegalArgumentException(annotationType + " appears more than once in the qualifier list");
            }
            dupChecker.add(annotationType);
            retVal.add(qualifier);
            if (!(qualifier instanceof Named)) continue;
            named = (Named)qualifier;
            if (named.value().equals("")) {
                throw new IllegalArgumentException("The @Named qualifier must have a value");
            }
            if (name == null || name.equals(named.value())) continue;
            throw new IllegalArgumentException("The name passed to the method (" + name + ") does not match the value of the @Named qualifier (" + named.value() + ")");
        }
        if (named == null && name != null) {
            retVal.add((Annotation)new NamedImpl(name));
        }
        return retVal;
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    private static class ScopeInfo {
        private final Annotation scope;
        private final Class<? extends Annotation> annoType;

        private ScopeInfo(Annotation scope, Class<? extends Annotation> annoType) {
            this.scope = scope;
            this.annoType = annoType;
        }

        private Annotation getScope() {
            return this.scope;
        }

        private Class<? extends Annotation> getAnnoType() {
            return this.annoType;
        }
    }

    private static class MemberKey {
        private final Member backingMember;

        private MemberKey(Member method) {
            this.backingMember = method;
        }

        private Member getBackingMember() {
            return this.backingMember;
        }

        public int hashCode() {
            int startCode = 0;
            if (this.backingMember instanceof Method) {
                startCode = 1;
            } else if (this.backingMember instanceof Constructor) {
                startCode = 2;
            }
            startCode ^= this.backingMember.getName().hashCode();
            Class<Object>[] parameters = this.backingMember instanceof Method ? ((Method)this.backingMember).getParameterTypes() : (this.backingMember instanceof Constructor ? ((Constructor)this.backingMember).getParameterTypes() : new Class[]{});
            for (Class<?> clazz : parameters) {
                startCode ^= clazz.hashCode();
            }
            return startCode;
        }

        public boolean equals(Object o) {
            Class<?>[] bParams;
            Class<?>[] oParams;
            if (o == null) {
                return false;
            }
            if (!(o instanceof MemberKey)) {
                return false;
            }
            MemberKey omk = (MemberKey)o;
            Member oMember = omk.backingMember;
            if (oMember.equals(this.backingMember)) {
                return true;
            }
            if (this.backingMember instanceof Field || oMember instanceof Field) {
                return false;
            }
            if (this.backingMember instanceof Method && !(oMember instanceof Method)) {
                return false;
            }
            if (this.backingMember instanceof Constructor && !(oMember instanceof Constructor)) {
                return false;
            }
            if (!oMember.getName().equals(this.backingMember.getName())) {
                return false;
            }
            if (Utilities.isPrivate(this.backingMember) || Utilities.isPrivate(oMember)) {
                return false;
            }
            if (this.backingMember instanceof Method) {
                oParams = ((Method)oMember).getParameterTypes();
                bParams = ((Method)this.backingMember).getParameterTypes();
            } else if (this.backingMember instanceof Constructor) {
                oParams = ((Constructor)oMember).getParameterTypes();
                bParams = ((Constructor)this.backingMember).getParameterTypes();
            } else {
                oParams = new Class[]{};
                bParams = new Class[]{};
            }
            if (oParams.length != bParams.length) {
                return false;
            }
            for (int i = 0; i < oParams.length; ++i) {
                if (oParams[i] == bParams[i]) continue;
                return false;
            }
            return true;
        }
    }
}

