/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.util.LinkedList;
import java.util.TreeSet;
import org.glassfish.hk2.api.Descriptor;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemDescriptor;

public class IndexedListData {
    private final LinkedList<SystemDescriptor<?>> currentList = new LinkedList();
    private boolean currentlySorted = true;

    public LinkedList<SystemDescriptor<?>> getSortedList() {
        if (!this.currentlySorted) {
            TreeSet<Descriptor> sorter = new TreeSet<Descriptor>(ServiceLocatorImpl.DESCRIPTOR_COMPARATOR);
            for (SystemDescriptor systemDescriptor : this.currentList) {
                sorter.add((Descriptor)systemDescriptor);
            }
            this.currentList.clear();
            for (SystemDescriptor systemDescriptor : sorter) {
                this.currentList.add(systemDescriptor);
            }
            this.currentlySorted = true;
        }
        return this.currentList;
    }

    public void addDescriptor(SystemDescriptor<?> descriptor) {
        this.currentList.add(descriptor);
        if (this.currentList.size() > 1) {
            this.currentlySorted = false;
        }
        descriptor.addList(this);
    }

    public void removeDescriptor(SystemDescriptor<?> descriptor) {
        this.currentList.remove(descriptor);
        if (this.currentList.size() > 1) {
            this.currentlySorted = false;
        }
        descriptor.removeList(this);
    }

    public boolean isEmpty() {
        return this.currentList.isEmpty();
    }

    public void unSort() {
        if (this.currentList.size() > 1) {
            this.currentlySorted = false;
        }
    }

    public void clear() {
        for (SystemDescriptor systemDescriptor : this.currentList) {
            systemDescriptor.removeList(this);
        }
        this.currentList.clear();
        this.currentlySorted = true;
    }
}

