/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.InstanceLifecycleListener;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.Operation;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ValidationInformation;
import org.glassfish.hk2.api.ValidationService;
import org.glassfish.hk2.api.Validator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.ConstantActiveDescriptor;
import org.jvnet.hk2.internal.DescriptorComparator;
import org.jvnet.hk2.internal.DynamicConfigurationImpl;
import org.jvnet.hk2.internal.IndexedListData;
import org.jvnet.hk2.internal.IterableProviderImpl;
import org.jvnet.hk2.internal.NarrowResults;
import org.jvnet.hk2.internal.PerLookupContext;
import org.jvnet.hk2.internal.ServiceHandleComparator;
import org.jvnet.hk2.internal.ServiceHandleImpl;
import org.jvnet.hk2.internal.SingletonContext;
import org.jvnet.hk2.internal.SystemDescriptor;
import org.jvnet.hk2.internal.TypeChecker;
import org.jvnet.hk2.internal.Utilities;
import org.jvnet.hk2.internal.ValidationInformationImpl;

public class ServiceLocatorImpl
implements ServiceLocator {
    private static final Object sLock = new Object();
    private static long currentLocatorId = 0L;
    static final DescriptorComparator DESCRIPTOR_COMPARATOR = new DescriptorComparator();
    private static final ServiceHandleComparator HANDLE_COMPARATOR = new ServiceHandleComparator();
    private final Object lock = new Object();
    private long nextServiceId = 0L;
    private final String locatorName;
    private final long id;
    private final ServiceLocator parent;
    private final IndexedListData allDescriptors = new IndexedListData();
    private final HashMap<String, IndexedListData> descriptorsByAdvertisedContract = new HashMap();
    private final HashMap<String, IndexedListData> descriptorsByName = new HashMap();
    private final HashMap<Class<? extends Annotation>, InjectionResolver<?>> allResolvers = new HashMap();
    private final Context<Singleton> singletonContext = new SingletonContext(this);
    private final Context<PerLookup> perLookupContext = new PerLookupContext();
    private final LinkedHashSet<ValidationService> allValidators = new LinkedHashSet();
    private final LinkedList<ErrorService> errorHandlers = new LinkedList();
    private final HashMap<Class<? extends Annotation>, Context<?>> contextCache = new HashMap();
    private boolean shutdown = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceLocatorImpl(String name, ServiceLocator parent) {
        this.locatorName = name;
        this.parent = parent;
        Object object = sLock;
        synchronized (object) {
            this.id = currentLocatorId++;
        }
    }

    private boolean validate(SystemDescriptor<?> descriptor, Injectee onBehalfOf, Filter filter) {
        for (ValidationService vs : this.allValidators) {
            if (!descriptor.isValidating(vs) || vs.getValidator().validate((ValidationInformation)new ValidationInformationImpl(Operation.LOOKUP, descriptor, onBehalfOf, filter))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ActiveDescriptor<?>> getDescriptors(Filter filter, Injectee onBehalfOf, boolean getParents) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        Object object = this.lock;
        synchronized (object) {
            List<SystemDescriptor<Object>> sortMeOut;
            if (filter instanceof IndexedFilter) {
                IndexedFilter df = (IndexedFilter)filter;
                if (df.getName() != null) {
                    List<SystemDescriptor<Object>> scopedByName;
                    String string = df.getName();
                    IndexedListData ild = this.descriptorsByName.get(string);
                    List<SystemDescriptor<Object>> list = scopedByName = ild == null ? null : ild.getSortedList();
                    if (scopedByName == null) {
                        scopedByName = Collections.emptyList();
                    }
                    if (df.getAdvertisedContract() != null) {
                        sortMeOut = new LinkedList();
                        for (SystemDescriptor<Object> candidate : scopedByName) {
                            if (!candidate.getAdvertisedContracts().contains(df.getAdvertisedContract())) continue;
                            sortMeOut.add(candidate);
                        }
                    } else {
                        sortMeOut = scopedByName;
                    }
                } else if (df.getAdvertisedContract() != null) {
                    String advertisedContract = df.getAdvertisedContract();
                    IndexedListData indexedListData = this.descriptorsByAdvertisedContract.get(advertisedContract);
                    List<SystemDescriptor<Object>> list = sortMeOut = indexedListData == null ? null : indexedListData.getSortedList();
                    if (sortMeOut == null) {
                        sortMeOut = Collections.emptyList();
                    }
                } else {
                    sortMeOut = this.allDescriptors.getSortedList();
                }
            } else {
                sortMeOut = this.allDescriptors.getSortedList();
            }
            LinkedList retVal = new LinkedList();
            for (SystemDescriptor systemDescriptor : sortMeOut) {
                if (!this.validate(systemDescriptor, onBehalfOf, filter) || !filter.matches((Descriptor)systemDescriptor)) continue;
                retVal.add(systemDescriptor);
            }
            if (getParents && this.parent != null) {
                TreeSet<Descriptor> sorter = new TreeSet<Descriptor>(DESCRIPTOR_COMPARATOR);
                sorter.addAll(retVal);
                sorter.addAll(this.parent.getDescriptors(filter));
                retVal.clear();
                retVal.addAll(sorter);
            }
            return retVal;
        }
    }

    private List<ActiveDescriptor<?>> protectedGetDescriptors(final Filter filter) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<ActiveDescriptor<?>>>(){

            @Override
            public List<ActiveDescriptor<?>> run() {
                return ServiceLocatorImpl.this.getDescriptors(filter);
            }
        });
    }

    public List<ActiveDescriptor<?>> getDescriptors(Filter filter) {
        this.checkState();
        return this.getDescriptors(filter, null, true);
    }

    public ActiveDescriptor<?> getBestDescriptor(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter is null");
        }
        this.checkState();
        List<ActiveDescriptor<?>> sorted = this.getDescriptors(filter);
        return Utilities.getFirstThingInList(sorted);
    }

    public ActiveDescriptor<?> reifyDescriptor(Descriptor descriptor, Injectee injectee) throws MultiException {
        this.checkState();
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (!(descriptor instanceof ActiveDescriptor)) {
            SystemDescriptor sd = new SystemDescriptor(descriptor, this, new Long(this.getNextServiceId()));
            Class<?> implClass = this.loadClass(descriptor, injectee);
            Collector collector = new Collector();
            sd.reify(implClass, collector);
            collector.throwIfErrors();
            return sd;
        }
        ActiveDescriptor active = (ActiveDescriptor)descriptor;
        if (active.isReified()) {
            return active;
        }
        SystemDescriptor sd = active instanceof SystemDescriptor ? (SystemDescriptor)active : new SystemDescriptor(descriptor, this, new Long(this.getNextServiceId()));
        Class<?> implClass = sd.getPreAnalyzedClass();
        if (implClass == null) {
            implClass = this.loadClass(descriptor, injectee);
        }
        Collector collector = new Collector();
        sd.reify(implClass, collector);
        collector.throwIfErrors();
        return sd;
    }

    public ActiveDescriptor<?> reifyDescriptor(Descriptor descriptor) throws MultiException {
        this.checkState();
        return this.reifyDescriptor(descriptor, null);
    }

    public ActiveDescriptor<?> getInjecteeDescriptor(Injectee injectee) throws MultiException {
        Annotation[] qualifiers;
        if (injectee == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        Type requiredType = injectee.getRequiredType();
        Class rawType = ReflectionHelper.getRawClass((Type)requiredType);
        if (rawType == null) {
            throw new MultiException((Throwable)new IllegalArgumentException("Invalid injectee with required type of " + injectee.getRequiredType() + " passed to getInjecteeDescriptor"));
        }
        if (Provider.class.equals((Object)rawType) || IterableProvider.class.equals((Object)rawType)) {
            IterableProviderImpl value = new IterableProviderImpl(this, Utilities.getFirstTypeArgument(requiredType), injectee.getRequiredQualifiers());
            return new ConstantActiveDescriptor(value, this.id);
        }
        Set qualifiersAsSet = injectee.getRequiredQualifiers();
        String name = Utilities.getNameFromAllQualifiers(qualifiersAsSet, injectee.getParent());
        ServiceHandle handle = this.internalGetServiceHandle(injectee, requiredType, name, qualifiers = qualifiersAsSet.toArray(new Annotation[qualifiersAsSet.size()]));
        if (handle == null) {
            return null;
        }
        return handle.getActiveDescriptor();
    }

    public <T> ServiceHandle<T> getServiceHandle(ActiveDescriptor<T> activeDescriptor, Injectee injectee) throws MultiException {
        if (activeDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        return new ServiceHandleImpl<T>(this, activeDescriptor, injectee);
    }

    public <T> ServiceHandle<T> getServiceHandle(ActiveDescriptor<T> activeDescriptor) throws MultiException {
        if (activeDescriptor == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        return this.getServiceHandle(activeDescriptor, null);
    }

    public <T> T getService(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) throws MultiException {
        ServiceHandle<T> subHandle = this.getServiceHandle(activeDescriptor);
        this.checkState();
        if (root != null && PerLookup.class.equals((Object)activeDescriptor.getScopeAnnotation())) {
            ((ServiceHandleImpl)root).addSubHandle((ServiceHandleImpl)subHandle);
        }
        return (T)subHandle.getService();
    }

    public <T> T getService(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        ServiceHandle<T> serviceHandle = this.getServiceHandle(contractOrImpl, qualifiers);
        if (serviceHandle == null) {
            return null;
        }
        return (T)serviceHandle.getService();
    }

    private <T> List<T> protectedGetAllServices(final Type contractOrImpl, final Annotation ... qualifiers) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<T>>(){

            @Override
            public List<T> run() {
                return ServiceLocatorImpl.this.getAllServices(contractOrImpl, qualifiers);
            }
        });
    }

    public <T> List<T> getAllServices(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        List<ServiceHandle<?>> services = this.getAllServiceHandles(contractOrImpl, qualifiers);
        LinkedList<Object> retVal = new LinkedList<Object>();
        for (ServiceHandle<?> service : services) {
            retVal.add(service.getService());
        }
        return retVal;
    }

    public <T> List<T> getAllServices(Annotation qualifier, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        List<ServiceHandle<?>> services = this.getAllServiceHandles(qualifier, qualifiers);
        LinkedList<Object> retVal = new LinkedList<Object>();
        for (ServiceHandle<?> service : services) {
            retVal.add(service.getService());
        }
        return retVal;
    }

    public <T> T getService(Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        ServiceHandle<T> handle = this.getServiceHandle(contractOrImpl, name, qualifiers);
        if (handle == null) {
            return null;
        }
        return (T)handle.getService();
    }

    public List<?> getAllServices(Filter searchCriteria) throws MultiException {
        this.checkState();
        List<ServiceHandle<?>> handleSet = this.getAllServiceHandles(searchCriteria);
        LinkedList<Object> retVal = new LinkedList<Object>();
        for (ServiceHandle<?> handle : handleSet) {
            retVal.add(handle.getService());
        }
        return retVal;
    }

    public String getName() {
        return this.locatorName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            List<ServiceHandle<?>> handles = this.getAllServiceHandles((Filter)BuilderHelper.createContractFilter((String)Context.class.getName()));
            for (ServiceHandle<?> handle : handles) {
                if (!handle.isActive()) continue;
                Context context = (Context)handle.getService();
                context.shutdown();
            }
            this.singletonContext.shutdown();
            this.shutdown = true;
            this.allDescriptors.clear();
            this.descriptorsByAdvertisedContract.clear();
            this.descriptorsByName.clear();
            this.allResolvers.clear();
            this.allValidators.clear();
            this.errorHandlers.clear();
        }
    }

    public <T> T create(Class<T> createMe) {
        this.checkState();
        return Utilities.justCreate(createMe, this);
    }

    public void inject(Object injectMe) {
        this.checkState();
        Utilities.justInject(injectMe, this);
    }

    public void postConstruct(Object postConstructMe) {
        this.checkState();
        if (postConstructMe == null) {
            throw new IllegalArgumentException();
        }
        if (postConstructMe instanceof PostConstruct) {
            ((PostConstruct)postConstructMe).postConstruct();
        } else {
            Utilities.justPostConstruct(postConstructMe);
        }
    }

    public void preDestroy(Object preDestroyMe) {
        this.checkState();
        if (preDestroyMe == null) {
            throw new IllegalArgumentException();
        }
        if (preDestroyMe instanceof PreDestroy) {
            ((PreDestroy)preDestroyMe).preDestroy();
        } else {
            Utilities.justPreDestroy(preDestroyMe);
        }
    }

    public <U> U createAndInitialize(Class<U> createMe) {
        U retVal = this.create(createMe);
        this.inject(retVal);
        this.postConstruct(retVal);
        return retVal;
    }

    private <T> ServiceHandle<T> internalGetServiceHandle(Injectee onBehalfOf, Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        ActiveDescriptor<?> topDog;
        if (contractOrImpl == null) {
            throw new IllegalArgumentException();
        }
        Class<?> rawClass = ReflectionHelper.getRawClass((Type)contractOrImpl);
        if (rawClass == null) {
            return null;
        }
        Utilities.checkLookupType(rawClass);
        rawClass = Utilities.translatePrimitiveType(rawClass);
        IndexedFilter filter = BuilderHelper.createNameAndContractFilter((String)rawClass.getName(), (String)name);
        LinkedList<ErrorService> currentErrorHandlers = null;
        List<ActiveDescriptor<?>> candidates = this.getDescriptors((Filter)filter, onBehalfOf, true);
        NarrowResults results = ServiceLocatorImpl.narrow(this, candidates, contractOrImpl, name, false, onBehalfOf, qualifiers);
        if (!results.getErrors().isEmpty()) {
            currentErrorHandlers = new LinkedList<ErrorService>(this.errorHandlers);
        }
        if (currentErrorHandlers != null) {
            Utilities.handleErrors(results, currentErrorHandlers);
        }
        if ((topDog = Utilities.getFirstThingInList(results.getResults())) == null) {
            return null;
        }
        return this.getServiceHandle(topDog);
    }

    public <T> ServiceHandle<T> getServiceHandle(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        return this.internalGetServiceHandle(null, contractOrImpl, null, qualifiers);
    }

    private List<ServiceHandle<?>> protectedGetAllServiceHandles(final Type contractOrImpl, final Annotation ... qualifiers) {
        return (List)AccessController.doPrivileged(new PrivilegedAction<List<ServiceHandle<?>>>(){

            @Override
            public List<ServiceHandle<?>> run() {
                return ServiceLocatorImpl.this.getAllServiceHandles(contractOrImpl, qualifiers);
            }
        });
    }

    public List<ServiceHandle<?>> getAllServiceHandles(Type contractOrImpl, Annotation ... qualifiers) throws MultiException {
        if (contractOrImpl == null) {
            throw new IllegalArgumentException();
        }
        this.checkState();
        Class rawClass = ReflectionHelper.getRawClass((Type)contractOrImpl);
        if (rawClass == null) {
            throw new MultiException((Throwable)new IllegalArgumentException("Type must be a class or parameterized type, it was " + contractOrImpl));
        }
        IndexedFilter filter = BuilderHelper.createContractFilter((String)rawClass.getName());
        LinkedList<ErrorService> currentErrorHandlers = null;
        List<ActiveDescriptor<?>> candidates = this.getDescriptors((Filter)filter);
        NarrowResults results = ServiceLocatorImpl.narrow(this, candidates, contractOrImpl, null, true, null, qualifiers);
        if (!results.getErrors().isEmpty()) {
            currentErrorHandlers = new LinkedList<ErrorService>(this.errorHandlers);
        }
        if (currentErrorHandlers != null) {
            Utilities.handleErrors(results, currentErrorHandlers);
        }
        LinkedList retVal = new LinkedList();
        for (ActiveDescriptor<?> candidate : results.getResults()) {
            retVal.add(this.getServiceHandle(candidate));
        }
        return retVal;
    }

    public <T> ServiceHandle<T> getServiceHandle(Type contractOrImpl, String name, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        return this.internalGetServiceHandle(null, contractOrImpl, name, qualifiers);
    }

    public List<ServiceHandle<?>> getAllServiceHandles(Filter searchCriteria) throws MultiException {
        this.checkState();
        LinkedList<ErrorService> currentErrorHandlers = null;
        List<ActiveDescriptor<?>> candidates = this.getDescriptors(searchCriteria);
        NarrowResults results = ServiceLocatorImpl.narrow(this, candidates, null, null, true, null, new Annotation[0]);
        if (!results.getErrors().isEmpty()) {
            currentErrorHandlers = new LinkedList<ErrorService>(this.errorHandlers);
        }
        if (currentErrorHandlers != null) {
            Utilities.handleErrors(results, currentErrorHandlers);
        }
        TreeSet retVal = new TreeSet(HANDLE_COMPARATOR);
        for (ActiveDescriptor<?> candidate : results.getResults()) {
            retVal.add(this.getServiceHandle(candidate));
        }
        return new LinkedList(retVal);
    }

    public List<ServiceHandle<?>> getAllServiceHandles(Annotation qualifier, Annotation ... qualifiers) throws MultiException {
        this.checkState();
        if (qualifier == null) {
            throw new IllegalArgumentException("qualifier is null");
        }
        final LinkedHashSet<String> allQualifiers = new LinkedHashSet<String>();
        allQualifiers.add(qualifier.annotationType().getName());
        for (Annotation anno : qualifiers) {
            String addMe = anno.annotationType().getName();
            if (allQualifiers.contains(addMe)) {
                throw new IllegalArgumentException("Multiple qualifiers with name " + addMe);
            }
            allQualifiers.add(addMe);
        }
        return this.getAllServiceHandles(new Filter(){

            public boolean matches(Descriptor d) {
                return d.getQualifiers().containsAll(allQualifiers);
            }
        });
    }

    private CheckConfigurationData checkConfiguration(DynamicConfigurationImpl dci) {
        TreeSet<Descriptor> retVal = new TreeSet<Descriptor>(DESCRIPTOR_COMPARATOR);
        boolean addOrRemoveOfInstanceListener = false;
        boolean addOrRemoveOfInjectionResolver = false;
        boolean addOrRemoveOfErrorHandler = false;
        for (Filter filter : dci.getUnbindFilters()) {
            List<ActiveDescriptor<?>> results = this.getDescriptors(filter, null, false);
            for (ActiveDescriptor<?> result : results) {
                SystemDescriptor candidate = (SystemDescriptor)result;
                if (retVal.contains(candidate)) continue;
                for (ValidationService vs : this.allValidators) {
                    if (vs.getValidator().validate((ValidationInformation)new ValidationInformationImpl(Operation.UNBIND, candidate))) continue;
                    throw new MultiException((Throwable)new IllegalArgumentException("Descriptor " + candidate + " did not pass the UNBIND validation"));
                }
                if (candidate.getAdvertisedContracts().contains(InstanceLifecycleListener.class.getName())) {
                    addOrRemoveOfInstanceListener = true;
                }
                if (candidate.getAdvertisedContracts().contains(InjectionResolver.class.getName())) {
                    addOrRemoveOfInjectionResolver = true;
                }
                if (candidate.getAdvertisedContracts().contains(ErrorService.class.getName())) {
                    addOrRemoveOfErrorHandler = true;
                }
                retVal.add((Descriptor)candidate);
            }
        }
        for (SystemDescriptor systemDescriptor : dci.getAllDescriptors()) {
            boolean checkScope = false;
            if (systemDescriptor.getAdvertisedContracts().contains(ValidationService.class.getName()) || systemDescriptor.getAdvertisedContracts().contains(ErrorService.class.getName()) || systemDescriptor.getAdvertisedContracts().contains(InstanceLifecycleListener.class.getName())) {
                this.reifyDescriptor((Descriptor)systemDescriptor);
                checkScope = true;
                if (systemDescriptor.getAdvertisedContracts().contains(ErrorService.class.getName())) {
                    addOrRemoveOfErrorHandler = true;
                }
                if (systemDescriptor.getAdvertisedContracts().contains(InstanceLifecycleListener.class.getName())) {
                    addOrRemoveOfInstanceListener = true;
                }
            }
            if (systemDescriptor.getAdvertisedContracts().contains(InjectionResolver.class.getName())) {
                this.reifyDescriptor((Descriptor)systemDescriptor);
                checkScope = true;
                if (Utilities.getInjectionResolverType(systemDescriptor) == null) {
                    throw new MultiException((Throwable)new IllegalArgumentException("An implementation of InjectionResolver must be a parameterized type and the actual type must be an annotation"));
                }
                addOrRemoveOfInjectionResolver = true;
            }
            if (systemDescriptor.getAdvertisedContracts().contains(Context.class.getName())) {
                checkScope = true;
            }
            if (checkScope) {
                String scope;
                String string = scope = systemDescriptor.getScope() == null ? PerLookup.class.getName() : systemDescriptor.getScope();
                if (!scope.equals(Singleton.class.getName())) {
                    throw new MultiException((Throwable)new IllegalArgumentException("The implementation class " + systemDescriptor.getImplementation() + " must be in the Singleton scope"));
                }
            }
            for (ValidationService vs : this.allValidators) {
                Validator validator = vs.getValidator();
                if (validator == null) {
                    throw new MultiException((Throwable)new IllegalArgumentException("Validator was null from validation service" + vs));
                }
                if (vs.getValidator().validate((ValidationInformation)new ValidationInformationImpl(Operation.BIND, systemDescriptor))) continue;
                throw new MultiException((Throwable)new IllegalArgumentException("Descriptor " + systemDescriptor + " did not pass the BIND validation"));
            }
        }
        return new CheckConfigurationData(retVal, addOrRemoveOfInstanceListener, addOrRemoveOfInjectionResolver, addOrRemoveOfErrorHandler);
    }

    private void removeConfigurationInternal(SortedSet<SystemDescriptor<?>> unbinds) {
        for (SystemDescriptor systemDescriptor : unbinds) {
            IndexedListData ild;
            this.allDescriptors.removeDescriptor(systemDescriptor);
            for (String advertisedContract : systemDescriptor.getAdvertisedContracts()) {
                IndexedListData ild2 = this.descriptorsByAdvertisedContract.get(advertisedContract);
                if (ild2 == null) continue;
                ild2.removeDescriptor(systemDescriptor);
                if (!ild2.isEmpty()) continue;
                this.descriptorsByAdvertisedContract.remove(advertisedContract);
            }
            String unbindName = systemDescriptor.getName();
            if (unbindName != null && (ild = this.descriptorsByName.get(unbindName)) != null) {
                ild.removeDescriptor(systemDescriptor);
                if (ild.isEmpty()) {
                    this.descriptorsByName.remove(unbindName);
                }
            }
            if (!systemDescriptor.getAdvertisedContracts().contains(ValidationService.class.getName())) continue;
            ServiceHandle handle = this.getServiceHandle(systemDescriptor);
            ValidationService vs = (ValidationService)handle.getService();
            this.allValidators.remove(vs);
        }
    }

    private List<SystemDescriptor<?>> addConfigurationInternal(DynamicConfigurationImpl dci) {
        LinkedList thingsAdded = new LinkedList();
        for (SystemDescriptor systemDescriptor : dci.getAllDescriptors()) {
            thingsAdded.add(systemDescriptor);
            this.allDescriptors.addDescriptor(systemDescriptor);
            LinkedList<String> allContracts = new LinkedList<String>(systemDescriptor.getAdvertisedContracts());
            allContracts.addAll(systemDescriptor.getQualifiers());
            String scope = systemDescriptor.getScope() == null ? PerLookup.class.getName() : systemDescriptor.getScope();
            allContracts.add(scope);
            for (String advertisedContract : allContracts) {
                IndexedListData ild = this.descriptorsByAdvertisedContract.get(advertisedContract);
                if (ild == null) {
                    ild = new IndexedListData();
                    this.descriptorsByAdvertisedContract.put(advertisedContract, ild);
                }
                ild.addDescriptor(systemDescriptor);
            }
            if (systemDescriptor.getName() != null) {
                String name = systemDescriptor.getName();
                IndexedListData ild = this.descriptorsByName.get(name);
                if (ild == null) {
                    ild = new IndexedListData();
                    this.descriptorsByName.put(name, ild);
                }
                ild.addDescriptor(systemDescriptor);
            }
            if (!systemDescriptor.getAdvertisedContracts().contains(ValidationService.class.getName())) continue;
            ServiceHandle handle = this.getServiceHandle(systemDescriptor);
            ValidationService vs = (ValidationService)handle.getService();
            this.allValidators.add(vs);
        }
        return thingsAdded;
    }

    private void reupInjectionResolvers() {
        HashMap<Class<? extends Annotation>, InjectionResolver> newResolvers = new HashMap<Class<? extends Annotation>, InjectionResolver>();
        IndexedFilter injectionResolverFilter = BuilderHelper.createContractFilter((String)InjectionResolver.class.getName());
        List<ActiveDescriptor<?>> resolverDescriptors = this.protectedGetDescriptors((Filter)injectionResolverFilter);
        for (ActiveDescriptor<?> resolverDescriptor : resolverDescriptors) {
            Class<? extends Annotation> iResolve = Utilities.getInjectionResolverType(resolverDescriptor);
            if (iResolve == null || newResolvers.containsKey(iResolve)) continue;
            InjectionResolver resolver = (InjectionResolver)this.getServiceHandle(resolverDescriptor).getService();
            newResolvers.put(iResolve, resolver);
        }
        this.allResolvers.clear();
        this.allResolvers.putAll(newResolvers);
    }

    private void reupErrorHandlers() {
        List allErrorServices = this.protectedGetAllServices((Type)((Object)ErrorService.class), new Annotation[0]);
        this.errorHandlers.clear();
        this.errorHandlers.addAll(allErrorServices);
    }

    private void reupInstanceListenersHandlers(List<SystemDescriptor<?>> checkList) {
        List<InstanceLifecycleListener> allLifecycleListeners = this.protectedGetAllServices((Type)((Object)InstanceLifecycleListener.class), new Annotation[0]);
        for (SystemDescriptor<?> descriptor : checkList) {
            descriptor.reupInstanceListeners(allLifecycleListeners);
        }
    }

    private void reup(List<SystemDescriptor<?>> thingsAdded, boolean instanceListenersModified, boolean injectionResolversModified, boolean errorHandlersModified) {
        if (injectionResolversModified) {
            this.reupInjectionResolvers();
        }
        if (errorHandlersModified) {
            this.reupErrorHandlers();
        }
        if (instanceListenersModified) {
            this.reupInstanceListenersHandlers(this.allDescriptors.getSortedList());
        } else {
            this.reupInstanceListenersHandlers(thingsAdded);
        }
        this.contextCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConfiguration(DynamicConfigurationImpl dci) {
        Object object = this.lock;
        synchronized (object) {
            CheckConfigurationData checkData = this.checkConfiguration(dci);
            this.removeConfigurationInternal(checkData.getUnbinds());
            List<SystemDescriptor<?>> thingsAdded = this.addConfigurationInternal(dci);
            this.reup(thingsAdded, checkData.getInstanceLifecycleModificationsMade(), checkData.getInjectionResolverModificationMade(), checkData.getErrorHandlerModificationMade());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInjectAnnotation(Annotation annotation) {
        Object object = this.lock;
        synchronized (object) {
            return this.allResolvers.containsKey(annotation.annotationType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isInjectAnnotation(Annotation annotation, boolean isConstructor) {
        Object object = this.lock;
        synchronized (object) {
            InjectionResolver<?> resolver = this.allResolvers.get(annotation.annotationType());
            if (resolver == null) {
                return false;
            }
            if (isConstructor) {
                return resolver.isConstructorParameterIndicator();
            }
            return resolver.isMethodParameterIndicator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InjectionResolver<?> getInjectionResolver(Class<? extends Annotation> annoType) {
        Object object = this.lock;
        synchronized (object) {
            return this.allResolvers.get(annoType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Context<?> resolveContext(Class<? extends Annotation> scope) throws IllegalStateException {
        if (scope.equals(Singleton.class)) {
            return this.singletonContext;
        }
        if (scope.equals(PerLookup.class)) {
            return this.perLookupContext;
        }
        Object object = this.lock;
        synchronized (object) {
            Context retVal = this.contextCache.get(scope);
            if (retVal != null) {
                return retVal;
            }
            Type[] actuals = new Type[]{scope};
            ParameterizedTypeImpl findContext = new ParameterizedTypeImpl(Context.class, actuals);
            List contextHandles = (List)Utilities.cast(this.protectedGetAllServiceHandles((Type)findContext, new Annotation[0]));
            for (ServiceHandle contextHandle : contextHandles) {
                Context context = (Context)contextHandle.getService();
                if (!context.isActive()) continue;
                if (retVal != null) {
                    throw new IllegalStateException("There is more than one active context for " + scope.getName());
                }
                retVal = context;
            }
            if (retVal == null) {
                throw new IllegalStateException("Could not find an active context for " + scope.getName());
            }
            this.contextCache.put(scope, retVal);
            return retVal;
        }
    }

    private Class<?> loadClass(Descriptor descriptor, Injectee injectee) {
        Class retVal;
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        HK2Loader loader = descriptor.getLoader();
        if (loader == null) {
            return Utilities.loadClass(descriptor.getImplementation(), injectee);
        }
        try {
            retVal = loader.loadClass(descriptor.getImplementation());
        }
        catch (MultiException me) {
            me.addError((Throwable)new IllegalStateException("Could not load descriptor " + descriptor));
            throw me;
        }
        catch (Throwable th) {
            MultiException me = new MultiException(th);
            me.addError((Throwable)new IllegalStateException("Could not load descriptor " + descriptor));
            throw me;
        }
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    private static NarrowResults narrow(ServiceLocator locator, List<ActiveDescriptor<?>> candidates, Type requiredType, String name, boolean getAll, Injectee injectee, Annotation ... qualifiers) {
        NarrowResults retVal = new NarrowResults();
        Set<Annotation> requiredAnnotations = Utilities.fixAndCheckQualifiers(qualifiers, name);
        for (ActiveDescriptor<?> activeDescriptor : candidates) {
            void var10_10;
            if (!activeDescriptor.isReified()) {
                try {
                    ActiveDescriptor activeDescriptor2 = locator.reifyDescriptor(activeDescriptor, injectee);
                }
                catch (MultiException me) {
                    retVal.addError(activeDescriptor, injectee, me);
                    continue;
                }
                catch (Throwable th) {
                    retVal.addError(activeDescriptor, injectee, new MultiException(th));
                    continue;
                }
            }
            if (requiredType != null) {
                boolean safe = false;
                for (Type candidateType : var10_10.getContractTypes()) {
                    if (!TypeChecker.isTypeSafe(requiredType, candidateType)) continue;
                    safe = true;
                    break;
                }
                if (!safe) continue;
            }
            Set candidateAnnotations = var10_10.getQualifierAnnotations();
            if (!requiredAnnotations.isEmpty() && !Utilities.annotationContainsAll(candidateAnnotations, requiredAnnotations)) continue;
            retVal.addGoodResult((ActiveDescriptor<?>)var10_10);
            if (getAll) continue;
            break;
        }
        return retVal;
    }

    public long getLocatorId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNextServiceId() {
        Object object = this.lock;
        synchronized (object) {
            return this.nextServiceId++;
        }
    }

    private void checkState() {
        if (this.shutdown) {
            throw new IllegalStateException(this + " has been shut down");
        }
    }

    public String toString() {
        return "ServiceLocatorImpl(" + this.locatorName + "," + this.id + "," + System.identityHashCode(this) + ")";
    }

    private static class CheckConfigurationData {
        private final SortedSet<SystemDescriptor<?>> unbinds;
        private final boolean instanceLifeycleModificationMade;
        private final boolean injectionResolverModificationMade;
        private final boolean errorHandlerModificationMade;

        private CheckConfigurationData(SortedSet<SystemDescriptor<?>> unbinds, boolean instanceLifecycleModificationMade, boolean injectionResolverModificationMade, boolean errorHandlerModificationMade) {
            this.unbinds = unbinds;
            this.instanceLifeycleModificationMade = instanceLifecycleModificationMade;
            this.injectionResolverModificationMade = injectionResolverModificationMade;
            this.errorHandlerModificationMade = errorHandlerModificationMade;
        }

        private SortedSet<SystemDescriptor<?>> getUnbinds() {
            return this.unbinds;
        }

        private boolean getInstanceLifecycleModificationsMade() {
            return this.instanceLifeycleModificationMade;
        }

        private boolean getInjectionResolverModificationMade() {
            return this.injectionResolverModificationMade;
        }

        private boolean getErrorHandlerModificationMade() {
            return this.errorHandlerModificationMade;
        }
    }
}

