/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemDescriptor;

public class SingletonContext
implements Context<Singleton> {
    private int generationNumber = Integer.MIN_VALUE;
    private final ServiceLocatorImpl locator;

    SingletonContext(ServiceLocatorImpl impl) {
        this.locator = impl;
    }

    public Class<? extends Annotation> getScope() {
        return Singleton.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T findOrCreate(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) {
        if (activeDescriptor.isCacheSet()) {
            return (T)activeDescriptor.getCache();
        }
        ActiveDescriptor<T> activeDescriptor2 = activeDescriptor;
        synchronized (activeDescriptor2) {
            if (activeDescriptor.isCacheSet()) {
                return (T)activeDescriptor.getCache();
            }
            Object t = activeDescriptor.create(root);
            activeDescriptor.setCache(t);
            if (activeDescriptor instanceof SystemDescriptor) {
                ((SystemDescriptor)activeDescriptor).setSingletonGeneration(this.generationNumber++);
            }
            return (T)t;
        }
    }

    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        return descriptor.isCacheSet();
    }

    public boolean isActive() {
        return true;
    }

    public boolean supportsNullCreation() {
        return false;
    }

    public void shutdown() {
        List<ActiveDescriptor<?>> all = this.locator.getDescriptors(BuilderHelper.allFilter());
        long myLocatorId = this.locator.getLocatorId();
        TreeSet<SystemDescriptor<Object>> singlesOnly = new TreeSet<SystemDescriptor<Object>>(new GenerationComparator());
        for (ActiveDescriptor<?> activeDescriptor : all) {
            if (activeDescriptor.getScope() == null || !activeDescriptor.getScope().equals(Singleton.class.getName()) || !activeDescriptor.isCacheSet() || activeDescriptor.getLocatorId() == null || activeDescriptor.getLocatorId() != myLocatorId) continue;
            SystemDescriptor oneAsObject = (SystemDescriptor)activeDescriptor;
            singlesOnly.add(oneAsObject);
        }
        for (SystemDescriptor systemDescriptor : singlesOnly) {
            this.destroyOne(systemDescriptor);
        }
    }

    public void destroyOne(ActiveDescriptor<?> one) {
        if (!one.isCacheSet()) {
            return;
        }
        Object value = one.getCache();
        one.releaseCache();
        try {
            one.dispose(value);
        }
        catch (Throwable th) {
            Logger.getLogger().debug("SingletonContext", "releaseOne", th);
        }
    }

    private static class GenerationComparator
    implements Comparator<SystemDescriptor<Object>> {
        private GenerationComparator() {
        }

        @Override
        public int compare(SystemDescriptor<Object> o1, SystemDescriptor<Object> o2) {
            if (o1.getSingletonGeneration() > o2.getSingletonGeneration()) {
                return -1;
            }
            if (o1.getSingletonGeneration() == o2.getSingletonGeneration()) {
                return 0;
            }
            return 1;
        }
    }
}

