/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.Proxiable;
import org.glassfish.hk2.api.ProxyCtl;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.NamedImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.internal.AutoActiveDescriptor;
import org.jvnet.hk2.internal.ClazzCreator;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.ConstantActiveDescriptor;
import org.jvnet.hk2.internal.Constants;
import org.jvnet.hk2.internal.ErrorResults;
import org.jvnet.hk2.internal.InjecteeImpl;
import org.jvnet.hk2.internal.NarrowResults;
import org.jvnet.hk2.internal.ParameterizedTypeImpl;
import org.jvnet.hk2.internal.Pretty;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.ThreeThirtyResolver;

public class Utilities {
    private static final String PROVIDE_METHOD = "provide";
    private static final String CONVENTION_POST_CONSTRUCT = "postConstruct";
    private static final String CONVENTION_PRE_DESTROY = "preDestroy";

    static boolean annotationContainsAll(final Set<Annotation> candidateAnnotations, final Set<Annotation> requiredAnnotations) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return candidateAnnotations.containsAll(requiredAnnotations);
            }
        });
    }

    private static void setContextClassLoader(final Thread t, final ClassLoader l) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                t.setContextClassLoader(l);
                return null;
            }
        });
    }

    private static Field[] getDeclaredFields(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static Method[] getDeclaredMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    static void setAccessible(final AccessibleObject ao) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ao.setAccessible(true);
                return null;
            }
        });
    }

    public static Class<?> translatePrimitiveType(Class<?> type) {
        Class<?> translation = Constants.PRIMITIVE_MAP.get(type);
        if (translation == null) {
            return type;
        }
        return translation;
    }

    public static void handleErrors(NarrowResults results, LinkedList<ErrorService> callThese) {
        Collector collector = new Collector();
        for (ErrorResults errorResult : results.getErrors()) {
            for (ErrorService eService : callThese) {
                try {
                    eService.failureToReify(errorResult.getDescriptor(), errorResult.getInjectee(), errorResult.getMe());
                }
                catch (MultiException me) {
                    for (Throwable th : me.getErrors()) {
                        collector.addThrowable(th);
                    }
                }
                catch (Throwable th) {
                    collector.addThrowable(th);
                }
            }
        }
        collector.throwIfErrors();
    }

    public static Class<?> loadClass(String implementation, Injectee injectee) {
        AnnotatedElement parent;
        ClassLoader loader = injectee != null ? ((parent = injectee.getParent()) instanceof Constructor ? ((Constructor)parent).getDeclaringClass().getClassLoader() : (parent instanceof Method ? ((Method)parent).getDeclaringClass().getClassLoader() : ((Field)parent).getDeclaringClass().getClassLoader())) : Utilities.class.getClassLoader();
        try {
            return loader.loadClass(implementation);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    public static Class<? extends Annotation> getInjectionResolverType(ActiveDescriptor<?> desc) {
        for (Type advertisedType : desc.getContractTypes()) {
            Class rawClass = ReflectionHelper.getRawClass((Type)advertisedType);
            if (!InjectionResolver.class.equals((Object)rawClass)) continue;
            if (!(advertisedType instanceof ParameterizedType)) {
                return null;
            }
            Type firstType = Utilities.getFirstTypeArgument(advertisedType);
            if (!(firstType instanceof Class)) {
                return null;
            }
            Class retVal = (Class)firstType;
            if (!Annotation.class.isAssignableFrom(retVal)) {
                return null;
            }
            return retVal;
        }
        return null;
    }

    public static void checkFactoryType(Class<?> factoryClass, Collector collector) {
        for (Type type : factoryClass.getGenericInterfaces()) {
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !Factory.class.equals((Object)rawClass)) continue;
            Type firstType = Utilities.getFirstTypeArgument(type);
            if (firstType instanceof TypeVariable) {
                collector.addThrowable(new IllegalArgumentException("The class " + Pretty.clazz(factoryClass) + " has a TypeVariable as its type"));
            }
            if (!(firstType instanceof WildcardType)) continue;
            collector.addThrowable(new IllegalArgumentException("The class " + Pretty.clazz(factoryClass) + " has a Wildcard as its type"));
        }
    }

    private static Set<Type> getAutoAdvertisedTypes(Type t) {
        Class rawSuperclass;
        LinkedHashSet<Type> retVal = new LinkedHashSet<Type>();
        retVal.add(t);
        Class rawClass = ReflectionHelper.getRawClass((Type)t);
        if (rawClass == null) {
            return retVal;
        }
        Type genericSuperclass = rawClass.getGenericSuperclass();
        while (genericSuperclass != null && (rawSuperclass = ReflectionHelper.getRawClass((Type)genericSuperclass)) != null) {
            if (rawSuperclass.isAnnotationPresent(Contract.class)) {
                retVal.add(genericSuperclass);
            }
            genericSuperclass = rawSuperclass.getGenericSuperclass();
        }
        while (rawClass != null) {
            for (Type iface : rawClass.getGenericInterfaces()) {
                Class ifaceClass = ReflectionHelper.getRawClass((Type)iface);
                if (!ifaceClass.isAnnotationPresent(Contract.class)) continue;
                retVal.add(iface);
            }
            rawClass = rawClass.getSuperclass();
        }
        return retVal;
    }

    public static <T> ActiveDescriptor<T> createAutoDescriptor(Class<T> clazz, ServiceLocatorImpl locator) throws MultiException, IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        Set<Annotation> qualifiers = ReflectionHelper.getQualifierAnnotations(clazz);
        String name = Utilities.getNameFromAllQualifiers(qualifiers, clazz);
        qualifiers = Utilities.getAllQualifiers(clazz, name, collector);
        Set<Type> contracts = Utilities.getAutoAdvertisedTypes(clazz);
        Class<? extends Annotation> scope = Utilities.getScopeAnnotationType(clazz, collector);
        ClazzCreator creator = new ClazzCreator(locator, clazz, collector);
        collector.throwIfErrors();
        return new AutoActiveDescriptor(clazz, creator, contracts, scope, name, qualifiers, 0);
    }

    public static void justPreDestroy(Object preMe) {
        if (preMe == null) {
            throw new IllegalArgumentException();
        }
        Class<?> baseClass = preMe.getClass();
        Collector collector = new Collector();
        Method preDestroy = Utilities.findPreDestroy(baseClass, collector);
        collector.throwIfErrors();
        Utilities.setAccessible(preDestroy);
        try {
            Utilities.invoke(preMe, preDestroy, new Object[0]);
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justPostConstruct(Object postMe) {
        if (postMe == null) {
            throw new IllegalArgumentException();
        }
        Class<?> baseClass = postMe.getClass();
        Collector collector = new Collector();
        Method postConstruct = Utilities.findPostConstruct(baseClass, collector);
        collector.throwIfErrors();
        Utilities.setAccessible(postConstruct);
        try {
            Utilities.invoke(postMe, postConstruct, new Object[0]);
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justInject(Object injectMe, ServiceLocatorImpl locator) {
        InjectionResolver<?> resolver;
        if (injectMe == null) {
            throw new IllegalArgumentException();
        }
        Class<?> baseClass = injectMe.getClass();
        Collector collector = new Collector();
        Set<Field> fields = Utilities.findInitializerFields(baseClass, locator, collector);
        Set<Method> methods = Utilities.findInitializerMethods(baseClass, locator, collector);
        collector.throwIfErrors();
        for (Field field : fields) {
            resolver = Utilities.getInjectionResolver(locator, field);
            Injectee injectee = Utilities.getFieldInjectees(field).get(0);
            Object fieldValue = resolver.resolve(injectee, null);
            Utilities.setAccessible(field);
            try {
                field.set(injectMe, fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new MultiException((Throwable)e);
            }
        }
        for (Method method : methods) {
            resolver = Utilities.getInjectionResolver(locator, method);
            List<Injectee> injectees = Utilities.getMethodInjectees(method);
            Object[] args = new Object[injectees.size()];
            for (Injectee injectee : injectees) {
                args[injectee.getPosition()] = resolver.resolve(injectee, null);
            }
            Utilities.setAccessible(method);
            try {
                Utilities.invoke(injectMe, method, args);
            }
            catch (Throwable e) {
                throw new MultiException(e);
            }
        }
    }

    public static <T> T justCreate(Class<T> createMe, ServiceLocatorImpl locator) {
        if (createMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        Constructor<?> c = Utilities.findProducerConstructor(createMe, locator, collector);
        collector.throwIfErrors();
        InjectionResolver<?> resolver = Utilities.getInjectionResolver(locator, c);
        List<Injectee> injectees = Utilities.getConstructorInjectees(c);
        Object[] args = new Object[injectees.size()];
        for (Injectee injectee : injectees) {
            args[injectee.getPosition()] = resolver.resolve(injectee, null);
        }
        Utilities.setAccessible(c);
        try {
            return (T)Utilities.makeMe(c, args);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    public static Class<?>[] getInterfacesForProxy(Set<Type> contracts) {
        LinkedList<Class> retVal = new LinkedList<Class>();
        retVal.add(ProxyCtl.class);
        for (Type type : contracts) {
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !rawClass.isInterface()) continue;
            retVal.add(rawClass);
        }
        return retVal.toArray(new Class[retVal.size()]);
    }

    public static boolean isProxiableScope(Class<? extends Annotation> scope) {
        return scope.isAnnotationPresent(Proxiable.class);
    }

    public static <T> T getFirstThingInList(List<T> set) {
        Iterator<T> i$ = set.iterator();
        if (i$.hasNext()) {
            T t = i$.next();
            return t;
        }
        return null;
    }

    private static Set<Field> getAllFields(Class<?> clazz) {
        HashSet<Field> retVal = new HashSet<Field>();
        HashSet<MemberKey> keys = new HashSet<MemberKey>();
        Utilities.getAllFieldKeys(clazz, keys);
        for (MemberKey key : keys) {
            retVal.add((Field)key.getBackingMember());
        }
        return retVal;
    }

    private static void getAllFieldKeys(Class<?> clazz, Set<MemberKey> currentFields) {
        if (clazz == null) {
            return;
        }
        Utilities.getAllFieldKeys(clazz.getSuperclass(), currentFields);
        for (Field field : Utilities.getDeclaredFields(clazz)) {
            currentFields.add(new MemberKey(field));
        }
    }

    public static ActiveDescriptor<ServiceLocator> getLocatorDescriptor(ServiceLocator locator) {
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.add((Type)((Object)ServiceLocator.class));
        Set<Annotation> qualifiers = Collections.emptySet();
        ConstantActiveDescriptor<ServiceLocator> retVal = new ConstantActiveDescriptor<ServiceLocator>(locator, contracts, PerLookup.class, null, qualifiers, 0, locator.getLocatorId());
        return retVal;
    }

    public static ActiveDescriptor<InjectionResolver<Inject>> getThreeThirtyDescriptor(ServiceLocatorImpl locator) {
        ThreeThirtyResolver threeThirtyResolver = new ThreeThirtyResolver(locator);
        HashSet<Type> contracts = new HashSet<Type>();
        Type[] actuals = new Type[]{Inject.class};
        contracts.add(new ParameterizedTypeImpl((Type)((Object)InjectionResolver.class), actuals));
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new NamedImpl("SystemInjectResolver"));
        ConstantActiveDescriptor<ThreeThirtyResolver> retVal = new ConstantActiveDescriptor<ThreeThirtyResolver>(threeThirtyResolver, contracts, Singleton.class, "SystemInjectResolver", qualifiers, 0, locator.getLocatorId());
        return retVal;
    }

    public static Constructor<?> findProducerConstructor(Class<?> annotatedType, ServiceLocatorImpl locator, Collector collector) {
        Constructor<?> zeroArgConstructor = null;
        Constructor<?> aConstructorWithInjectAnnotation = null;
        Set<Constructor<?>> allConstructors = Utilities.getAllConstructors(annotatedType);
        for (Constructor<?> constructor : allConstructors) {
            Type[] rawParameters = constructor.getGenericParameterTypes();
            if (rawParameters.length <= 0) {
                zeroArgConstructor = constructor;
            }
            if (Utilities.getInjectAnnotation(locator, constructor) == null) continue;
            if (aConstructorWithInjectAnnotation != null) {
                collector.addThrowable(new IllegalArgumentException("There is more than one constructor on class " + Pretty.clazz(annotatedType)));
                return null;
            }
            aConstructorWithInjectAnnotation = constructor;
        }
        if (aConstructorWithInjectAnnotation != null) {
            return aConstructorWithInjectAnnotation;
        }
        if (zeroArgConstructor == null) {
            collector.addThrowable(new IllegalArgumentException("The class " + Pretty.clazz(annotatedType) + " has no constructor marked @Inject and no zero argument constructor"));
            return null;
        }
        return zeroArgConstructor;
    }

    public static Type getFirstTypeArgument(Type type) {
        if (type instanceof Class) {
            return Object.class;
        }
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] arguments = pt.getActualTypeArguments();
        if (arguments.length <= 0) {
            return Object.class;
        }
        return arguments[0];
    }

    private static Set<Constructor<?>> getAllConstructors(Class<?> clazz) {
        HashSet retVal = new HashSet();
        HashSet<MemberKey> keys = new HashSet<MemberKey>();
        Utilities.getAllConstructorKeys(clazz, keys);
        for (MemberKey key : keys) {
            retVal.add((Constructor)key.getBackingMember());
        }
        return retVal;
    }

    private static void getAllConstructorKeys(Class<?> clazz, Set<MemberKey> currentConstructors) {
        if (clazz == null) {
            return;
        }
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            currentConstructors.add(new MemberKey(constructor));
        }
    }

    private static Set<Method> getAllMethods(Class<?> clazz) {
        HashSet<Method> retVal = new HashSet<Method>();
        HashSet<MemberKey> keys = new HashSet<MemberKey>();
        Utilities.getAllMethodKeys(clazz, keys);
        for (MemberKey key : keys) {
            retVal.add((Method)key.getBackingMember());
        }
        return retVal;
    }

    private static void getAllMethodKeys(Class<?> clazz, Set<MemberKey> currentMethods) {
        if (clazz == null) {
            return;
        }
        Utilities.getAllMethodKeys(clazz.getSuperclass(), currentMethods);
        for (Method method : Utilities.getDeclaredMethods(clazz)) {
            currentMethods.add(new MemberKey(method));
        }
    }

    public static Set<Method> findInitializerMethods(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        HashSet<Method> retVal = new HashSet<Method>();
        for (Method method : Utilities.getAllMethods(annotatedType)) {
            if (Utilities.getInjectAnnotation(locator, method) == null) continue;
            if (!Utilities.hasCorrectInitializerMethodModifiers(method)) {
                errorCollector.addThrowable(new IllegalArgumentException("An initializer method " + Pretty.method(method) + " is static or abstract"));
                continue;
            }
            retVal.add(method);
        }
        return retVal;
    }

    public static Set<Field> findInitializerFields(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        HashSet<Field> retVal = new HashSet<Field>();
        for (Field field : Utilities.getAllFields(annotatedType)) {
            if (Utilities.getInjectAnnotation(locator, field) == null) continue;
            if (!Utilities.hasCorrectInitializerFieldModifiers(field)) {
                errorCollector.addThrowable(new IllegalArgumentException("The field " + Pretty.field(field) + " may not be static or final"));
                continue;
            }
            retVal.add(field);
        }
        return retVal;
    }

    private static Annotation getInjectAnnotation(ServiceLocatorImpl locator, AnnotatedElement annotated) {
        for (Annotation anno : annotated.getAnnotations()) {
            if (!locator.isInjectAnnotation(anno)) continue;
            return anno;
        }
        return null;
    }

    private static boolean hasCorrectInitializerMethodModifiers(Method member) {
        if (Utilities.isStatic(member)) {
            return false;
        }
        return !Utilities.isAbstract(member);
    }

    private static boolean hasCorrectInitializerFieldModifiers(Field field) {
        if (Utilities.isStatic(field)) {
            return false;
        }
        return !Utilities.isFinal(field);
    }

    public static boolean isStatic(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 8) != 0;
    }

    public static boolean isAbstract(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x400) != 0;
    }

    public static boolean isFinal(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x10) != 0;
    }

    public static Class<? extends Annotation> getScopeAnnotationType(AnnotatedElement annotatedGuy, Collector collector) {
        Class topLevelElement = annotatedGuy;
        Annotation winnerScope = null;
        block0: while (annotatedGuy != null) {
            Annotation current = Utilities.internalGetScopeAnnotationType(annotatedGuy, collector);
            if (current != null) {
                if (annotatedGuy.equals(topLevelElement)) {
                    winnerScope = current;
                    break;
                }
                if (!current.annotationType().isAnnotationPresent(Inherited.class)) break;
                winnerScope = current;
                break;
            }
            if (annotatedGuy instanceof Class) {
                annotatedGuy = ((Class)annotatedGuy).getSuperclass();
                continue;
            }
            Method theMethod = (Method)annotatedGuy;
            Class<?> methodClass = theMethod.getDeclaringClass();
            annotatedGuy = null;
            for (Class<?> methodSuperclass = methodClass.getSuperclass(); methodSuperclass != null; methodSuperclass = methodSuperclass.getSuperclass()) {
                if (!Factory.class.isAssignableFrom(methodSuperclass)) continue;
                annotatedGuy = Utilities.getFactoryProvideMethod(methodSuperclass);
                continue block0;
            }
        }
        if (winnerScope != null) {
            return winnerScope.annotationType();
        }
        if (topLevelElement.isAnnotationPresent(Service.class)) {
            return Singleton.class;
        }
        return PerLookup.class;
    }

    private static Annotation internalGetScopeAnnotationType(AnnotatedElement annotatedGuy, Collector collector) {
        boolean epicFail = false;
        Annotation retVal = null;
        for (Annotation annotation : annotatedGuy.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Scope.class)) continue;
            if (retVal != null) {
                collector.addThrowable(new IllegalArgumentException("The type " + annotatedGuy + " may not have more than one scope.  It has at least " + Pretty.clazz(retVal.annotationType()) + " and " + Pretty.clazz(annotation.annotationType())));
                epicFail = true;
                continue;
            }
            retVal = annotation;
        }
        if (epicFail) {
            return null;
        }
        return retVal;
    }

    public static InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, AnnotatedElement annotatedGuy) throws IllegalStateException {
        Annotation injectAnnotation = Utilities.getInjectAnnotation(locator, annotatedGuy);
        Class injectType = injectAnnotation == null ? Inject.class : injectAnnotation.annotationType();
        InjectionResolver<?> retVal = locator.getInjectionResolver(injectType);
        if (retVal == null) {
            throw new IllegalStateException("There is no installed injection resolver for " + Pretty.clazz(injectType) + " for type " + annotatedGuy);
        }
        return retVal;
    }

    public static Method getFactoryProvideMethod(Class<?> clazz) {
        try {
            return clazz.getMethod(PROVIDE_METHOD, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static String getNameFromAllQualifiers(Set<Annotation> qualifiers, AnnotatedElement parent) {
        for (Annotation qualifier : qualifiers) {
            if (!Named.class.equals(qualifier.annotationType())) continue;
            Named named = (Named)qualifier;
            if (named.value() == null || named.value().equals("")) {
                if (parent instanceof Class) {
                    return Pretty.clazz((Class)parent);
                }
                throw new MultiException((Throwable)new IllegalStateException("@Named must have a value for " + parent));
            }
            return named.value();
        }
        return null;
    }

    public static String getDefaultNameFromMethod(Method parent, Collector collector) {
        Named named = parent.getAnnotation(Named.class);
        if (named == null) {
            return null;
        }
        if (named.value() == null || named.value().equals("")) {
            collector.addThrowable(new IllegalArgumentException("@Named on the provide method of a factory must have an explicit value"));
        }
        return named.value();
    }

    public static Set<Annotation> getAllQualifiers(AnnotatedElement annotatedGuy, String name, Collector collector) {
        Named namedQualifier = null;
        Set retVal = ReflectionHelper.getQualifierAnnotations((AnnotatedElement)annotatedGuy);
        for (Annotation anno : retVal) {
            if (!(anno instanceof Named)) continue;
            namedQualifier = (Named)anno;
            break;
        }
        if (name == null) {
            if (namedQualifier != null) {
                collector.addThrowable(new IllegalArgumentException("No name was in the descriptor, but this element(" + annotatedGuy + " has a Named annotation with value: " + namedQualifier.value()));
                retVal.remove(namedQualifier);
            }
            return retVal;
        }
        if (namedQualifier == null || namedQualifier.value().equals("")) {
            if (namedQualifier != null) {
                retVal.remove(namedQualifier);
            }
            namedQualifier = new NamedImpl(name);
            retVal.add(namedQualifier);
        }
        if (!name.equals(namedQualifier.value())) {
            collector.addThrowable(new IllegalArgumentException("The class had an @Named qualifier that was inconsistent.  The expected name is " + name + " but the annotation has name " + namedQualifier.value()));
        }
        return retVal;
    }

    private static Set<Annotation> getAllQualifiers(Annotation[] memberAnnotations) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        for (Annotation annotation : memberAnnotations) {
            if (!ReflectionHelper.isAnnotationAQualifier((Annotation)annotation)) continue;
            retVal.add(annotation);
        }
        return retVal;
    }

    private static boolean isOptional(Annotation[] memberAnnotations) {
        for (Annotation annotation : memberAnnotations) {
            if (!annotation.annotationType().equals(Optional.class)) continue;
            return true;
        }
        return false;
    }

    public static List<Injectee> getConstructorInjectees(Constructor<?> c) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        for (int lcv = 0; lcv < genericTypeParams.length; ++lcv) {
            retVal.add(new InjecteeImpl(genericTypeParams[lcv], Utilities.getAllQualifiers(paramAnnotations[lcv]), lcv, c, Utilities.isOptional(paramAnnotations[lcv])));
        }
        return retVal;
    }

    public static List<Injectee> getMethodInjectees(Method c) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        for (int lcv = 0; lcv < genericTypeParams.length; ++lcv) {
            retVal.add(new InjecteeImpl(genericTypeParams[lcv], Utilities.getAllQualifiers(paramAnnotations[lcv]), lcv, c, Utilities.isOptional(paramAnnotations[lcv])));
        }
        return retVal;
    }

    public static List<Injectee> getFieldInjectees(Field f) {
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        retVal.add(new InjecteeImpl(f.getGenericType(), ReflectionHelper.getQualifierAnnotations((AnnotatedElement)f), -1, f, Utilities.isOptional(f.getAnnotations())));
        return retVal;
    }

    public static Method findPostConstruct(Class<?> clazz, Collector collector) {
        if (org.glassfish.hk2.api.PostConstruct.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Method method : Utilities.getAllMethods(clazz)) {
            if (method.isAnnotationPresent(PostConstruct.class)) {
                if (method.getParameterTypes().length != 0) {
                    collector.addThrowable(new IllegalArgumentException("The method " + Pretty.method(method) + " annotated with @PostConstruct must not have any arguments"));
                    return null;
                }
                return method;
            }
            if (method.getParameterTypes().length != 0 || !method.getName().equals(CONVENTION_POST_CONSTRUCT)) continue;
            return method;
        }
        return null;
    }

    public static Method findPreDestroy(Class<?> clazz, Collector collector) {
        if (PreDestroy.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Method method : Utilities.getAllMethods(clazz)) {
            if (method.isAnnotationPresent(javax.annotation.PreDestroy.class)) {
                if (method.getParameterTypes().length != 0) {
                    collector.addThrowable(new IllegalArgumentException("The method " + Pretty.method(method) + " annotated with @PreDestroy must not have any arguments"));
                    return null;
                }
                return method;
            }
            if (method.getParameterTypes().length != 0 || !method.getName().equals(CONVENTION_PRE_DESTROY)) continue;
            return method;
        }
        return null;
    }

    public static Object makeMe(Constructor<?> c, Object[] args) throws Throwable {
        ClassLoader currentCCL = Thread.currentThread().getContextClassLoader();
        try {
            Object obj = c.newInstance(args);
            return obj;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        finally {
            Utilities.setContextClassLoader(Thread.currentThread(), currentCCL);
        }
    }

    public static Object invoke(Object o, Method m, Object[] args) throws Throwable {
        if (Utilities.isStatic(m)) {
            o = null;
        }
        ClassLoader currentCCL = Thread.currentThread().getContextClassLoader();
        try {
            Object object = m.invoke(o, args);
            return object;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
        finally {
            Utilities.setContextClassLoader(Thread.currentThread(), currentCCL);
        }
    }

    public static Set<Annotation> fixAndCheckQualifiers(Annotation[] qualifiers, String name) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        HashSet<String> dupChecker = new HashSet<String>();
        Named named = null;
        for (Annotation qualifier : qualifiers) {
            if (!ReflectionHelper.isAnnotationAQualifier((Annotation)qualifier)) {
                throw new IllegalArgumentException(Pretty.clazz(qualifier.annotationType()) + " is not a qualifier");
            }
            String annotationType = qualifier.annotationType().getName();
            if (dupChecker.contains(annotationType)) {
                throw new IllegalArgumentException(annotationType + " appears more than once in the qualifier list");
            }
            dupChecker.add(annotationType);
            retVal.add(qualifier);
            if (!(qualifier instanceof Named)) continue;
            named = (Named)qualifier;
            if (named.value().equals("")) {
                throw new IllegalArgumentException("The @Named qualifier must have a value");
            }
            if (name == null || name.equals(named.value())) continue;
            throw new IllegalArgumentException("The name passed to the method (" + name + ") does not match the value of the @Named qualifier (" + named.value() + ")");
        }
        if (named == null && name != null) {
            retVal.add((Annotation)new NamedImpl(name));
        }
        return retVal;
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    private static class MemberKey {
        private final Member backingMember;

        private MemberKey(Member method) {
            this.backingMember = method;
        }

        private Member getBackingMember() {
            return this.backingMember;
        }

        public int hashCode() {
            int startCode = 0;
            if (this.backingMember instanceof Method) {
                startCode = 1;
            } else if (this.backingMember instanceof Constructor) {
                startCode = 2;
            }
            startCode ^= this.backingMember.getName().hashCode();
            Class<Object>[] parameters = this.backingMember instanceof Method ? ((Method)this.backingMember).getParameterTypes() : (this.backingMember instanceof Constructor ? ((Constructor)this.backingMember).getParameterTypes() : new Class[]{});
            for (Class<?> clazz : parameters) {
                startCode ^= clazz.hashCode();
            }
            return startCode;
        }

        public boolean equals(Object o) {
            Class<?>[] bParams;
            Class<?>[] oParams;
            if (o == null) {
                return false;
            }
            if (!(o instanceof MemberKey)) {
                return false;
            }
            MemberKey omk = (MemberKey)o;
            Member oMember = omk.backingMember;
            if (this.backingMember instanceof Method && !(oMember instanceof Method)) {
                return false;
            }
            if (this.backingMember instanceof Constructor && !(oMember instanceof Constructor)) {
                return false;
            }
            if (!oMember.getName().equals(this.backingMember.getName())) {
                return false;
            }
            if (this.backingMember instanceof Method) {
                oParams = ((Method)oMember).getParameterTypes();
                bParams = ((Method)this.backingMember).getParameterTypes();
            } else if (this.backingMember instanceof Constructor) {
                oParams = ((Constructor)oMember).getParameterTypes();
                bParams = ((Constructor)this.backingMember).getParameterTypes();
            } else {
                oParams = new Class[]{};
                bParams = new Class[]{};
            }
            if (oParams.length != bParams.length) {
                return false;
            }
            for (int i = 0; i < oParams.length; ++i) {
                if (oParams[i] == bParams[i]) continue;
                return false;
            }
            return true;
        }
    }
}

