/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.glassfish.hk2.utilities.reflection.Pretty;

public class CacheKey {
    private final Type lookupType;
    private final String name;
    private final Annotation[] qualifiers;

    public CacheKey(Type lookupType, String name, Annotation ... qualifiers) {
        this.lookupType = lookupType;
        this.name = name;
        this.qualifiers = qualifiers.length > 0 ? qualifiers : null;
    }

    public static boolean safeEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public int hashCode() {
        int retVal = 0;
        if (this.lookupType != null) {
            retVal ^= this.lookupType.hashCode();
        }
        if (this.name != null) {
            retVal ^= this.name.hashCode();
        }
        if (this.qualifiers != null) {
            for (Annotation anno : this.qualifiers) {
                retVal ^= ((Object)anno).hashCode();
            }
        }
        return retVal;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof CacheKey)) {
            return false;
        }
        final CacheKey other = (CacheKey)o;
        if (!CacheKey.safeEquals(this.lookupType, other.lookupType)) {
            return false;
        }
        if (!CacheKey.safeEquals(this.name, other.name)) {
            return false;
        }
        if (this.qualifiers != null) {
            if (other.qualifiers == null) {
                return false;
            }
            if (this.qualifiers.length != other.qualifiers.length) {
                return false;
            }
            boolean isEqual = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    for (int lcv = 0; lcv < CacheKey.this.qualifiers.length; ++lcv) {
                        if (CacheKey.safeEquals(CacheKey.this.qualifiers[lcv], other.qualifiers[lcv])) continue;
                        return false;
                    }
                    return true;
                }
            });
            if (!isEqual) {
                return false;
            }
        } else if (other.qualifiers != null) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "CacheKey(" + Pretty.type((Type)this.lookupType) + "," + this.name + "," + this.qualifiers + "," + System.identityHashCode(this) + ")";
    }
}

