/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.internal.Creator;
import org.jvnet.hk2.internal.InstanceLifecycleEventImpl;

public class FactoryCreator<T>
implements Creator<T> {
    private final ServiceLocator locator;
    private final ActiveDescriptor<?> factoryDescriptor;

    FactoryCreator(ServiceLocator locator, ActiveDescriptor<?> factoryDescriptor) {
        this.locator = locator;
        this.factoryDescriptor = factoryDescriptor;
    }

    @Override
    public List<Injectee> getInjectees() {
        return Collections.emptyList();
    }

    private ServiceHandle<Factory<T>> getFactoryHandle() {
        try {
            return this.locator.getServiceHandle(this.factoryDescriptor);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    @Override
    public InstanceLifecycleEventImpl create(ServiceHandle<?> root) throws MultiException {
        ServiceHandle<Factory<T>> handle = this.getFactoryHandle();
        Factory retVal = (Factory)handle.getService();
        return new InstanceLifecycleEventImpl(InstanceLifecycleEventType.POST_PRODUCTION, retVal.provide());
    }

    @Override
    public void dispose(T instance) {
        try {
            ServiceHandle<Factory<T>> handle = this.getFactoryHandle();
            Factory factory = (Factory)handle.getService();
            factory.dispose(instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static class FactoryFilter
    implements IndexedFilter {
        private final String implClass;

        private FactoryFilter(String implClass) {
            this.implClass = implClass;
        }

        public boolean matches(Descriptor d) {
            return d.getDescriptorType().equals((Object)DescriptorType.CLASS);
        }

        public String getAdvertisedContract() {
            return this.implClass;
        }

        public String getName() {
            return null;
        }
    }
}

