/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.InstanceLifecycleEventType;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.reflection.Logger;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.Creator;
import org.jvnet.hk2.internal.InstanceLifecycleEventImpl;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.Utilities;

public class ClazzCreator<T>
implements Creator<T> {
    private final ServiceLocatorImpl locator;
    private final Class<?> implClass;
    private final Set<ResolutionInfo> myInitializers = new HashSet<ResolutionInfo>();
    private final Set<ResolutionInfo> myFields = new HashSet<ResolutionInfo>();
    private final ActiveDescriptor<?> selfDescriptor;
    private final ResolutionInfo myConstructor;
    private List<Injectee> allInjectees;
    private Method postConstructMethod;
    private Method preDestroyMethod;

    ClazzCreator(ServiceLocatorImpl locator, Class<?> implClass, ActiveDescriptor<?> selfDescriptor, Collector collector) {
        this.locator = locator;
        this.implClass = implClass;
        this.selfDescriptor = selfDescriptor;
        LinkedList<Injectee> baseAllInjectees = new LinkedList<Injectee>();
        AccessibleObject element = Utilities.findProducerConstructor(implClass, locator, collector);
        if (element == null) {
            this.myConstructor = null;
            return;
        }
        List<Injectee> injectees = Utilities.getConstructorInjectees(element);
        if (injectees == null) {
            this.myConstructor = null;
            return;
        }
        baseAllInjectees.addAll(injectees);
        this.myConstructor = new ResolutionInfo(element, injectees);
        Set<Method> initMethods = Utilities.findInitializerMethods(implClass, locator, collector);
        for (Method initMethod : initMethods) {
            element = initMethod;
            injectees = Utilities.getMethodInjectees(initMethod);
            if (injectees == null) {
                return;
            }
            baseAllInjectees.addAll(injectees);
            this.myInitializers.add(new ResolutionInfo(element, injectees));
        }
        Set<Field> fields = Utilities.findInitializerFields(implClass, locator, collector);
        for (Field field : fields) {
            element = field;
            injectees = Utilities.getFieldInjectees(field);
            if (injectees == null) {
                return;
            }
            baseAllInjectees.addAll(injectees);
            this.myFields.add(new ResolutionInfo(element, injectees));
        }
        this.postConstructMethod = Utilities.findPostConstruct(implClass, collector);
        this.preDestroyMethod = Utilities.findPreDestroy(implClass, collector);
        this.allInjectees = Collections.unmodifiableList(baseAllInjectees);
        Utilities.validateSelfInjectees(selfDescriptor, this.allInjectees, collector);
    }

    private void resolve(Map<Injectee, Object> addToMe, InjectionResolver<?> resolver, Injectee injectee, ServiceHandle<?> root, Collector errorCollection) {
        if (injectee.isSelf()) {
            addToMe.put(injectee, this.selfDescriptor);
            return;
        }
        Object addIn = null;
        try {
            addIn = resolver.resolve(injectee, root);
        }
        catch (Throwable th) {
            errorCollection.addThrowable(th);
        }
        if (addIn != null) {
            addToMe.put(injectee, addIn);
        }
    }

    private Map<Injectee, Object> resolveAllDependencies(ServiceHandle<?> root) throws IllegalStateException {
        InjectionResolver<?> resolver;
        Collector errorCollector = new Collector();
        HashMap<Injectee, Object> retVal = new HashMap<Injectee, Object>();
        for (Injectee injectee : this.myConstructor.injectees) {
            resolver = Utilities.getInjectionResolver(this.locator, injectee);
            this.resolve(retVal, resolver, injectee, root, errorCollector);
        }
        for (ResolutionInfo fieldRI : this.myFields) {
            resolver = Utilities.getInjectionResolver(this.locator, fieldRI.baseElement);
            for (Injectee injectee : fieldRI.injectees) {
                this.resolve(retVal, resolver, injectee, root, errorCollector);
            }
        }
        for (ResolutionInfo methodRI : this.myInitializers) {
            for (Injectee injectee : methodRI.injectees) {
                InjectionResolver<?> resolver2 = Utilities.getInjectionResolver(this.locator, injectee);
                this.resolve(retVal, resolver2, injectee, root, errorCollector);
            }
        }
        if (errorCollector.hasErrors()) {
            errorCollector.addThrowable(new IllegalArgumentException("While attempting to resolve the dependencies of " + this.implClass.getName() + " errors were found"));
            errorCollector.throwIfErrors();
        }
        return retVal;
    }

    private Object createMe(Map<Injectee, Object> resolved) throws Throwable {
        Constructor c = (Constructor)this.myConstructor.baseElement;
        List injectees = this.myConstructor.injectees;
        Object[] args = new Object[injectees.size()];
        for (Injectee injectee : injectees) {
            args[injectee.getPosition()] = resolved.get(injectee);
        }
        return ReflectionHelper.makeMe((Constructor)c, (Object[])args);
    }

    private void fieldMe(Map<Injectee, Object> resolved, T t) throws Throwable {
        for (ResolutionInfo ri : this.myFields) {
            Field field = (Field)ri.baseElement;
            List injectees = ri.injectees;
            Injectee fieldInjectee = null;
            Iterator i$ = injectees.iterator();
            while (i$.hasNext()) {
                Injectee candidate;
                fieldInjectee = candidate = (Injectee)i$.next();
            }
            Object putMeIn = resolved.get(fieldInjectee);
            ReflectionHelper.setField((Field)field, t, (Object)putMeIn);
        }
    }

    private void methodMe(Map<Injectee, Object> resolved, T t) throws Throwable {
        for (ResolutionInfo ri : this.myInitializers) {
            Method m = (Method)ri.baseElement;
            List injectees = ri.injectees;
            Object[] args = new Object[injectees.size()];
            for (Injectee injectee : injectees) {
                args[injectee.getPosition()] = resolved.get(injectee);
            }
            ReflectionHelper.invoke(t, (Method)m, (Object[])args);
        }
    }

    private void postConstructMe(T t) throws Throwable {
        if (t == null) {
            return;
        }
        if (t instanceof PostConstruct) {
            ((PostConstruct)t).postConstruct();
            return;
        }
        if (this.postConstructMethod == null) {
            return;
        }
        ReflectionHelper.invoke(t, (Method)this.postConstructMethod, (Object[])new Object[0]);
    }

    private void preDestroyMe(T t) throws Throwable {
        if (t == null) {
            return;
        }
        if (t instanceof PreDestroy) {
            ((PreDestroy)t).preDestroy();
            return;
        }
        if (this.preDestroyMethod == null) {
            return;
        }
        ReflectionHelper.invoke(t, (Method)this.preDestroyMethod, (Object[])new Object[0]);
    }

    @Override
    public InstanceLifecycleEventImpl create(ServiceHandle<?> root) {
        try {
            Map<Injectee, Object> allResolved = this.resolveAllDependencies(root);
            Object retVal = this.createMe(allResolved);
            this.fieldMe(allResolved, retVal);
            this.methodMe(allResolved, retVal);
            this.postConstructMe(retVal);
            return new InstanceLifecycleEventImpl(InstanceLifecycleEventType.POST_PRODUCTION, retVal, allResolved);
        }
        catch (Throwable th) {
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                me.addError((Throwable)new IllegalStateException("Unable to create or inject " + this.implClass.getName()));
                throw me;
            }
            MultiException me = new MultiException(th);
            me.addError((Throwable)new IllegalStateException("Unable to create or inject " + this.implClass.getName()));
            throw me;
        }
    }

    @Override
    public void dispose(T instance) {
        try {
            this.preDestroyMe(instance);
        }
        catch (Throwable th) {
            Logger.getLogger().debug("ClazzCreator", "dispose", th);
        }
    }

    @Override
    public List<Injectee> getInjectees() {
        return this.allInjectees;
    }

    private static class ResolutionInfo {
        private final AnnotatedElement baseElement;
        private final List<Injectee> injectees = new LinkedList<Injectee>();

        private ResolutionInfo(AnnotatedElement baseElement, List<Injectee> injectees) {
            this.baseElement = baseElement;
            this.injectees.addAll(injectees);
        }
    }
}

