/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.util.LinkedList;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.FactoryDescriptors;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.MultiException;
import org.jvnet.hk2.internal.Pretty;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemDescriptor;
import org.jvnet.hk2.internal.Utilities;

public class DynamicConfigurationImpl
implements DynamicConfiguration {
    private final ServiceLocatorImpl locator;
    private final LinkedList<SystemDescriptor<?>> allDescriptors = new LinkedList();
    private final LinkedList<Filter> allUnbindFilters = new LinkedList();
    private final Object lock = new Object();
    private boolean committed = false;

    public DynamicConfigurationImpl(ServiceLocatorImpl locator) {
        this.locator = locator;
    }

    public ActiveDescriptor<?> bind(Descriptor key) {
        this.checkState();
        DynamicConfigurationImpl.checkDescriptor(key);
        SystemDescriptor sd = new SystemDescriptor(key, new Long(this.locator.getLocatorId()), new Long(this.locator.getNextServiceId()));
        this.allDescriptors.add(sd);
        return sd;
    }

    public FactoryDescriptors bind(FactoryDescriptors factoryDescriptors) {
        if (factoryDescriptors == null) {
            throw new IllegalArgumentException("factoryDescriptors is null");
        }
        Descriptor asService = factoryDescriptors.getFactoryAsAService();
        Descriptor asFactory = factoryDescriptors.getFactoryAsAFactory();
        DynamicConfigurationImpl.checkDescriptor(asService);
        DynamicConfigurationImpl.checkDescriptor(asFactory);
        String implClassService = asService.getImplementation();
        String implClassFactory = asFactory.getImplementation();
        if (!implClassService.equals(implClassFactory)) {
            throw new IllegalArgumentException("The implementation classes must match (" + implClassService + "/" + implClassFactory + ")");
        }
        if (!asService.getDescriptorType().equals((Object)DescriptorType.CLASS)) {
            throw new IllegalArgumentException("The getFactoryAsService descriptor must be of type CLASS");
        }
        if (!asFactory.getDescriptorType().equals((Object)DescriptorType.FACTORY)) {
            throw new IllegalArgumentException("The getFactoryAsFactory descriptor must be of type FACTORY");
        }
        final ActiveDescriptor<?> boundAsFactory = this.bind(asFactory);
        final ActiveDescriptor<?> boundAsService = this.bind(asService);
        return new FactoryDescriptors(){

            public Descriptor getFactoryAsAService() {
                return boundAsService;
            }

            public Descriptor getFactoryAsAFactory() {
                return boundAsFactory;
            }
        };
    }

    public <T> ActiveDescriptor<T> addActiveDescriptor(ActiveDescriptor<T> activeDescriptor) throws IllegalArgumentException {
        this.checkState();
        DynamicConfigurationImpl.checkDescriptor(activeDescriptor);
        if (!activeDescriptor.isReified()) {
            throw new IllegalArgumentException();
        }
        SystemDescriptor retVal = new SystemDescriptor((Descriptor)activeDescriptor, new Long(this.locator.getLocatorId()), new Long(this.locator.getNextServiceId()));
        this.allDescriptors.add(retVal);
        return retVal;
    }

    public <T> ActiveDescriptor<T> addActiveDescriptor(Class<T> rawClass) throws IllegalArgumentException {
        ActiveDescriptor<T> ad = Utilities.createAutoDescriptor(rawClass, this.locator);
        return this.addActiveDescriptor(ad);
    }

    public void addUnbindFilter(Filter unbindFilter) throws IllegalArgumentException {
        if (unbindFilter == null) {
            throw new IllegalArgumentException();
        }
        this.allUnbindFilters.add(unbindFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws MultiException {
        Object object = this.lock;
        synchronized (object) {
            this.checkState();
            this.committed = true;
        }
        this.locator.addConfiguration(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() {
        Object object = this.lock;
        synchronized (object) {
            if (this.committed) {
                throw new IllegalStateException();
            }
        }
    }

    private static void checkDescriptor(Descriptor d) {
        if (d == null) {
            throw new IllegalArgumentException();
        }
        if (d.getImplementation() == null) {
            throw new IllegalArgumentException();
        }
        if (d.getAdvertisedContracts() == null) {
            throw new IllegalArgumentException();
        }
        if (d.getDescriptorType() == null) {
            throw new IllegalArgumentException();
        }
        if (d.getMetadata() == null) {
            throw new IllegalArgumentException();
        }
        if (d.getQualifiers() == null) {
            throw new IllegalArgumentException();
        }
    }

    LinkedList<SystemDescriptor<?>> getAllDescriptors() {
        return this.allDescriptors;
    }

    LinkedList<Filter> getUnbindFilters() {
        return this.allUnbindFilters;
    }

    public String toString() {
        return "DynamicConfigurationImpl(" + this.locator + "," + Pretty.collection(this.allDescriptors) + "," + Pretty.collection(this.allUnbindFilters) + "," + System.identityHashCode(this) + ")";
    }
}

