/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.jvnet.hk2.internal.MethodInterceptorImpl;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.Utilities;

public class ServiceHandleImpl<T>
implements ServiceHandle<T> {
    private ActiveDescriptor<T> root;
    private final ServiceLocatorImpl locator;
    private final Injectee injectee;
    private final Object lock = new Object();
    private boolean serviceDestroyed = false;
    private boolean serviceSet = false;
    private T service;
    private final List<ServiceHandleImpl<?>> subHandles = new LinkedList();

    ServiceHandleImpl(ServiceLocatorImpl locator, ActiveDescriptor<T> root, Injectee injectee) {
        this.root = root;
        this.locator = locator;
        this.injectee = injectee;
    }

    private Object secureCreate(final Class<?> superclass, final Class<?>[] interfaces, final Callback callback) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Enhancer.create((Class)superclass, (Class[])interfaces, (Callback)callback);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getService() {
        Object object = this.lock;
        synchronized (object) {
            Context<?> context;
            if (this.serviceDestroyed) {
                throw new IllegalStateException("Service has been disposed");
            }
            if (this.serviceSet) {
                return this.service;
            }
            if (!this.root.isReified()) {
                this.root = this.locator.reifyDescriptor((Descriptor)this.root, this.injectee);
            }
            if (Utilities.isProxiableScope(this.root.getScopeAnnotation())) {
                Object proxy = this.secureCreate(this.root.getImplementationClass(), Utilities.getInterfacesForProxy(this.root.getContractTypes()), (Callback)new MethodInterceptorImpl(this.locator, this.root, this));
                this.serviceSet = true;
                this.service = proxy;
                return (T)proxy;
            }
            try {
                context = this.locator.resolveContext(this.root.getScopeAnnotation());
            }
            catch (Throwable th) {
                throw new MultiException(th);
            }
            this.service = context.findOrCreate(this.root, (ServiceHandle)this);
            if (this.service == null) {
                throw new MultiException((Throwable)new IllegalStateException("Context " + context + " findOrCreate returned a null for descriptor " + this.root + " and handle " + this));
            }
            this.serviceSet = true;
            return this.service;
        }
    }

    public ActiveDescriptor<T> getActiveDescriptor() {
        return this.root;
    }

    public boolean isActive() {
        if (this.serviceDestroyed) {
            return false;
        }
        if (this.serviceSet) {
            return true;
        }
        try {
            Context<?> context = this.locator.resolveContext(this.root.getScopeAnnotation());
            return context.find(this.root) != null;
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.serviceDestroyed) {
                return;
            }
            this.serviceDestroyed = true;
            if (!this.serviceSet) {
                return;
            }
        }
        if (this.root.getScopeAnnotation().equals(PerLookup.class)) {
            this.root.dispose(this.service);
        }
        for (ServiceHandleImpl<?> subHandle : this.subHandles) {
            subHandle.destroy();
        }
    }

    public void addSubHandle(ServiceHandleImpl<?> subHandle) {
        this.subHandles.add(subHandle);
    }

    public String toString() {
        return "ServiceHandle(" + this.root + "," + System.identityHashCode(this) + ")";
    }
}

