/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.inject.Singleton;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ClassAnalyzer;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.ErrorInformation;
import org.glassfish.hk2.api.ErrorService;
import org.glassfish.hk2.api.ErrorType;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.Proxiable;
import org.glassfish.hk2.api.ProxyCtl;
import org.glassfish.hk2.api.ProxyForSameScope;
import org.glassfish.hk2.api.Self;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Unproxiable;
import org.glassfish.hk2.api.Unqualified;
import org.glassfish.hk2.api.UseProxy;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.NamedImpl;
import org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.glassfish.hk2.utilities.reflection.Pretty;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.internal.AutoActiveDescriptor;
import org.jvnet.hk2.internal.ClazzCreator;
import org.jvnet.hk2.internal.Collector;
import org.jvnet.hk2.internal.ConstantActiveDescriptor;
import org.jvnet.hk2.internal.Constants;
import org.jvnet.hk2.internal.DelegatingClassLoader;
import org.jvnet.hk2.internal.EnhancerWithClassLoader;
import org.jvnet.hk2.internal.ErrorInformationImpl;
import org.jvnet.hk2.internal.ErrorResults;
import org.jvnet.hk2.internal.InjecteeImpl;
import org.jvnet.hk2.internal.MethodInterceptorImpl;
import org.jvnet.hk2.internal.NarrowResults;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.ThreeThirtyResolver;

public class Utilities {
    private static final Object lock = new Object();
    private static final Map<Class<?>, LinkedHashSet<MemberKey>> methodKeyCache = new WeakHashMap();
    private static Map<Class<?>, LinkedHashSet<MemberKey>> fieldCache = new WeakHashMap();
    private static final Map<Class<?>, Method> postConstructCache = new WeakHashMap();
    private static final Map<Class<?>, Method> preDestroyCache = new WeakHashMap();
    private static final String CONVENTION_POST_CONSTRUCT = "postConstruct";
    private static final String CONVENTION_PRE_DESTROY = "preDestroy";
    private static final String PROVIDE_METHOD = "provide";

    public static ClassAnalyzer getClassAnalyzer(ServiceLocatorImpl sli, String analyzerName, Collector errorCollector) {
        return sli.getAnalyzer(analyzerName, errorCollector);
    }

    public static <T> Constructor<T> getConstructor(Class<T> implClass, ClassAnalyzer analyzer, Collector collector) {
        Constructor element = null;
        try {
            element = analyzer.getConstructor(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return element;
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return element;
        }
        if (element == null) {
            collector.addThrowable((Throwable)((Object)new AssertionError((Object)("null return from getConstructor method of analyzer " + analyzer + " for class " + implClass.getName()))));
            return element;
        }
        return element;
    }

    public static Set<Method> getInitMethods(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        Set retVal;
        try {
            retVal = analyzer.getInitializerMethods(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return Collections.emptySet();
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return Collections.emptySet();
        }
        if (retVal == null) {
            collector.addThrowable((Throwable)((Object)new AssertionError((Object)("null return from getInitializerMethods method of analyzer " + analyzer + " for class " + implClass.getName()))));
            return Collections.emptySet();
        }
        return retVal;
    }

    public static Set<Field> getInitFields(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        Set retVal;
        try {
            retVal = analyzer.getFields(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return Collections.emptySet();
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return Collections.emptySet();
        }
        if (retVal == null) {
            collector.addThrowable((Throwable)((Object)new AssertionError((Object)("null return from getFields method of analyzer " + analyzer + " for class " + implClass.getName()))));
            return Collections.emptySet();
        }
        return retVal;
    }

    public static Method getPostConstruct(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        try {
            return analyzer.getPostConstructMethod(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return null;
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return null;
        }
    }

    public static Method getPreDestroy(Class<?> implClass, ClassAnalyzer analyzer, Collector collector) {
        try {
            return analyzer.getPreDestroyMethod(implClass);
        }
        catch (MultiException me) {
            collector.addMultiException(me);
            return null;
        }
        catch (Throwable th) {
            collector.addThrowable(th);
            return null;
        }
    }

    private static Class<?> getFactoryAwareImplementationClass(ActiveDescriptor<?> descriptor) {
        if (descriptor.getDescriptorType().equals((Object)DescriptorType.CLASS)) {
            return descriptor.getImplementationClass();
        }
        return Utilities.getFactoryProductionClass(descriptor.getImplementationClass());
    }

    public static void checkLookupType(Class<?> checkMe) {
        if (!checkMe.isAnnotation()) {
            return;
        }
        if (checkMe.isAnnotationPresent(Scope.class)) {
            return;
        }
        if (checkMe.isAnnotationPresent(Qualifier.class)) {
            return;
        }
        throw new IllegalArgumentException("Lookup type " + checkMe + " must be a scope or annotation");
    }

    static boolean annotationContainsAll(final Set<Annotation> candidateAnnotations, final Set<Annotation> requiredAnnotations) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return candidateAnnotations.containsAll(requiredAnnotations);
            }
        });
    }

    private static Field[] getDeclaredFields(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static Method[] getDeclaredMethods(final Class<?> clazz) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        });
    }

    public static Class<?> translatePrimitiveType(Class<?> type) {
        Class<?> translation = Constants.PRIMITIVE_MAP.get(type);
        if (translation == null) {
            return type;
        }
        return translation;
    }

    public static void handleErrors(NarrowResults results, LinkedList<ErrorService> callThese) {
        Collector collector = new Collector();
        for (ErrorResults errorResult : results.getErrors()) {
            for (ErrorService eService : callThese) {
                try {
                    eService.onFailure((ErrorInformation)new ErrorInformationImpl(ErrorType.FAILURE_TO_REIFY, (Descriptor)errorResult.getDescriptor(), errorResult.getInjectee(), errorResult.getMe()));
                }
                catch (MultiException me) {
                    for (Throwable th : me.getErrors()) {
                        collector.addThrowable(th);
                    }
                }
                catch (Throwable th) {
                    collector.addThrowable(th);
                }
            }
        }
        collector.throwIfErrors();
    }

    public static Class<?> loadClass(String loadMe, Descriptor fromMe, Collector collector) {
        HK2Loader loader = fromMe.getLoader();
        if (loader == null) {
            ClassLoader cl = Utilities.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                return cl.loadClass(loadMe);
            }
            catch (Throwable th) {
                collector.addThrowable(th);
                return null;
            }
        }
        try {
            return loader.loadClass(loadMe);
        }
        catch (Throwable th) {
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                for (Throwable th2 : me.getErrors()) {
                    collector.addThrowable(th2);
                }
            } else {
                collector.addThrowable(th);
            }
            return null;
        }
    }

    public static Class<?> loadClass(String implementation, Injectee injectee) {
        AnnotatedElement parent;
        ClassLoader loader = injectee != null ? ((parent = injectee.getParent()) instanceof Constructor ? ((Constructor)parent).getDeclaringClass().getClassLoader() : (parent instanceof Method ? ((Method)parent).getDeclaringClass().getClassLoader() : (parent instanceof Field ? ((Field)parent).getDeclaringClass().getClassLoader() : injectee.getClass().getClassLoader()))) : Utilities.class.getClassLoader();
        try {
            return loader.loadClass(implementation);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    public static Class<? extends Annotation> getInjectionResolverType(ActiveDescriptor<?> desc) {
        for (Type advertisedType : desc.getContractTypes()) {
            Class rawClass = ReflectionHelper.getRawClass((Type)advertisedType);
            if (!InjectionResolver.class.equals((Object)rawClass)) continue;
            if (!(advertisedType instanceof ParameterizedType)) {
                return null;
            }
            Type firstType = Utilities.getFirstTypeArgument(advertisedType);
            if (!(firstType instanceof Class)) {
                return null;
            }
            Class retVal = (Class)firstType;
            if (!Annotation.class.isAssignableFrom(retVal)) {
                return null;
            }
            return retVal;
        }
        return null;
    }

    private static Class<?> getFactoryProductionClass(Class<?> factoryClass) {
        Type factoryProvidedType = Utilities.getFactoryProductionType(factoryClass);
        Class retVal = ReflectionHelper.getRawClass((Type)factoryProvidedType);
        if (retVal != null) {
            return retVal;
        }
        throw new MultiException((Throwable)((Object)new AssertionError((Object)("Could not find true produced type of factory " + factoryClass.getName()))));
    }

    public static Type getFactoryProductionType(Class<?> factoryClass) {
        Set factoryTypes = ReflectionHelper.getTypeClosure(factoryClass, Collections.singleton(Factory.class.getName()));
        ParameterizedType parameterizedType = (ParameterizedType)factoryTypes.iterator().next();
        Type factoryProvidedType = parameterizedType.getActualTypeArguments()[0];
        return factoryProvidedType;
    }

    public static void checkFactoryType(Class<?> factoryClass, Collector collector) {
        for (Type type : factoryClass.getGenericInterfaces()) {
            Type firstType;
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !Factory.class.equals((Object)rawClass) || !((firstType = Utilities.getFirstTypeArgument(type)) instanceof WildcardType)) continue;
            collector.addThrowable(new IllegalArgumentException("The class " + Pretty.clazz(factoryClass) + " has a Wildcard as its type"));
        }
    }

    private static Set<Type> getAutoAdvertisedTypes(Type t) {
        Class rawSuperclass;
        LinkedHashSet<Type> retVal = new LinkedHashSet<Type>();
        retVal.add(t);
        Class rawClass = ReflectionHelper.getRawClass((Type)t);
        if (rawClass == null) {
            return retVal;
        }
        Type genericSuperclass = rawClass.getGenericSuperclass();
        while (genericSuperclass != null && (rawSuperclass = ReflectionHelper.getRawClass((Type)genericSuperclass)) != null) {
            if (rawSuperclass.isAnnotationPresent(Contract.class)) {
                retVal.add(genericSuperclass);
            }
            genericSuperclass = rawSuperclass.getGenericSuperclass();
        }
        while (rawClass != null) {
            for (Type iface : rawClass.getGenericInterfaces()) {
                Class ifaceClass = ReflectionHelper.getRawClass((Type)iface);
                if (!ifaceClass.isAnnotationPresent(Contract.class)) continue;
                retVal.add(iface);
            }
            rawClass = rawClass.getSuperclass();
        }
        return retVal;
    }

    public static <T> AutoActiveDescriptor<T> createAutoDescriptor(Class<T> clazz, ServiceLocatorImpl locator) throws MultiException, IllegalArgumentException, IllegalStateException {
        ProxyForSameScope pfss;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        Boolean proxy = null;
        Boolean proxyForSameScope = null;
        Set<Annotation> qualifiers = ReflectionHelper.getQualifierAnnotations(clazz);
        String name = ReflectionHelper.getNameFromAllQualifiers((Set)qualifiers, clazz);
        qualifiers = Utilities.getAllQualifiers(clazz, name, collector);
        Set<Type> contracts = Utilities.getAutoAdvertisedTypes(clazz);
        ScopeInfo scopeInfo = Utilities.getScopeInfo(clazz, null, collector);
        Class scope = scopeInfo.getAnnoType();
        String analyzerName = Utilities.getAutoAnalyzerName(clazz);
        ClazzCreator creator = new ClazzCreator(locator, clazz);
        collector.throwIfErrors();
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        if (scopeInfo.getScope() != null) {
            BuilderHelper.getMetadataValues((Annotation)scopeInfo.getScope(), metadata);
        }
        for (Annotation qualifier : qualifiers) {
            BuilderHelper.getMetadataValues((Annotation)qualifier, metadata);
        }
        UseProxy useProxy = clazz.getAnnotation(UseProxy.class);
        if (useProxy != null) {
            proxy = useProxy.value();
        }
        if ((pfss = clazz.getAnnotation(ProxyForSameScope.class)) != null) {
            proxyForSameScope = pfss.value();
        }
        DescriptorVisibility visibility = DescriptorVisibility.NORMAL;
        Visibility vi = clazz.getAnnotation(Visibility.class);
        if (vi != null) {
            visibility = vi.value();
        }
        AutoActiveDescriptor retVal = new AutoActiveDescriptor(clazz, creator, contracts, scope, name, qualifiers, visibility, 0, proxy, proxyForSameScope, analyzerName, metadata);
        creator.initialize((ActiveDescriptor<?>)retVal, analyzerName, collector);
        collector.throwIfErrors();
        return retVal;
    }

    public static void justPreDestroy(Object preMe, ServiceLocatorImpl locator, String strategy) {
        if (preMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        collector.throwIfErrors();
        Class<?> baseClass = preMe.getClass();
        Method preDestroy = Utilities.getPreDestroy(baseClass, analyzer, collector);
        collector.throwIfErrors();
        if (preDestroy == null) {
            return;
        }
        try {
            ReflectionHelper.invoke((Object)preMe, (Method)preDestroy, (Object[])new Object[0]);
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justPostConstruct(Object postMe, ServiceLocatorImpl locator, String strategy) {
        if (postMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        Class<?> baseClass = postMe.getClass();
        Method postConstruct = Utilities.getPostConstruct(baseClass, analyzer, collector);
        collector.throwIfErrors();
        if (postConstruct == null) {
            return;
        }
        try {
            ReflectionHelper.invoke((Object)postMe, (Method)postConstruct, (Object[])new Object[0]);
        }
        catch (Throwable e) {
            throw new MultiException(e);
        }
    }

    public static void justInject(Object injectMe, ServiceLocatorImpl locator, String strategy) {
        if (injectMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        Class<?> baseClass = injectMe.getClass();
        Set<Field> fields = Utilities.getInitFields(baseClass, analyzer, collector);
        Set<Method> methods = Utilities.getInitMethods(baseClass, analyzer, collector);
        collector.throwIfErrors();
        for (Field field : fields) {
            InjectionResolver<?> resolver = Utilities.getInjectionResolver(locator, field);
            List<Injectee> injecteeFields = Utilities.getFieldInjectees(field, null);
            Utilities.validateSelfInjectees(null, injecteeFields, collector);
            collector.throwIfErrors();
            Injectee injectee = injecteeFields.get(0);
            Object fieldValue = resolver.resolve(injectee, null);
            try {
                ReflectionHelper.setField((Field)field, (Object)injectMe, (Object)fieldValue);
            }
            catch (Throwable th) {
                throw new MultiException(th);
            }
        }
        for (Method method : methods) {
            List<Injectee> injectees = Utilities.getMethodInjectees(method, null);
            Utilities.validateSelfInjectees(null, injectees, collector);
            collector.throwIfErrors();
            Object[] args = new Object[injectees.size()];
            for (Injectee injectee : injectees) {
                InjectionResolver<?> resolver = Utilities.getInjectionResolver(locator, injectee);
                args[injectee.getPosition()] = resolver.resolve(injectee, null);
            }
            try {
                ReflectionHelper.invoke((Object)injectMe, (Method)method, (Object[])args);
            }
            catch (Throwable e) {
                throw new MultiException(e);
            }
        }
    }

    public static <T> T justCreate(Class<T> createMe, ServiceLocatorImpl locator, String strategy) {
        if (createMe == null) {
            throw new IllegalArgumentException();
        }
        Collector collector = new Collector();
        ClassAnalyzer analyzer = Utilities.getClassAnalyzer(locator, strategy, collector);
        collector.throwIfErrors();
        Constructor<T> c = Utilities.getConstructor(createMe, analyzer, collector);
        collector.throwIfErrors();
        List<Injectee> injectees = Utilities.getConstructorInjectees(c, null);
        Utilities.validateSelfInjectees(null, injectees, collector);
        collector.throwIfErrors();
        Object[] args = new Object[injectees.size()];
        for (Injectee injectee : injectees) {
            InjectionResolver<?> resolver = Utilities.getInjectionResolver(locator, injectee);
            args[injectee.getPosition()] = resolver.resolve(injectee, null);
        }
        try {
            return (T)ReflectionHelper.makeMe(c, (Object[])args);
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
    }

    public static Class<?>[] getInterfacesForProxy(Set<Type> contracts) {
        LinkedList<Class> retVal = new LinkedList<Class>();
        retVal.add(ProxyCtl.class);
        for (Type type : contracts) {
            Class rawClass = ReflectionHelper.getRawClass((Type)type);
            if (rawClass == null || !rawClass.isInterface()) continue;
            retVal.add(rawClass);
        }
        return retVal.toArray(new Class[retVal.size()]);
    }

    public static boolean isProxiableScope(Class<? extends Annotation> scope) {
        return scope.isAnnotationPresent(Proxiable.class);
    }

    public static boolean isUnproxiableScope(Class<? extends Annotation> scope) {
        return scope.isAnnotationPresent(Unproxiable.class);
    }

    public static boolean isProxiable(ActiveDescriptor<?> desc, Injectee injectee) {
        Boolean directed = desc.isProxiable();
        if (directed != null) {
            if (injectee == null) {
                return directed;
            }
            if (!directed.booleanValue()) {
                return false;
            }
            ActiveDescriptor injecteeDescriptor = injectee.getInjecteeDescriptor();
            if (injecteeDescriptor == null) {
                return true;
            }
            Boolean sameScope = desc.isProxyForSameScope();
            if (sameScope == null || sameScope.booleanValue()) {
                return true;
            }
            return !desc.getScope().equals(injecteeDescriptor.getScope());
        }
        if (!Utilities.isProxiableScope(desc.getScopeAnnotation())) {
            return false;
        }
        if (injectee == null) {
            return true;
        }
        ActiveDescriptor injecteeDescriptor = injectee.getInjecteeDescriptor();
        if (injecteeDescriptor == null) {
            return true;
        }
        Boolean proxyForSameScope = desc.isProxyForSameScope();
        Proxiable proxiable = desc.getScopeAnnotation().getAnnotation(Proxiable.class);
        if (proxyForSameScope != null ? proxyForSameScope != false : proxiable == null || proxiable.proxyForSameScope()) {
            return true;
        }
        return !desc.getScope().equals(injecteeDescriptor.getScope());
    }

    public static <T> T getFirstThingInList(List<T> set) {
        Iterator<T> i$ = set.iterator();
        if (i$.hasNext()) {
            T t = i$.next();
            return t;
        }
        return null;
    }

    private static Set<Field> getAllFields(Class<?> clazz, Collector collector) {
        LinkedHashSet<Field> retVal = new LinkedHashSet<Field>();
        LinkedHashSet<MemberKey> keys = new LinkedHashSet<MemberKey>();
        Utilities.getAllFieldKeys(clazz, keys, collector);
        for (MemberKey key : keys) {
            retVal.add((Field)key.getBackingMember());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getAllFieldKeys(Class<?> clazz, LinkedHashSet<MemberKey> currentFields, Collector collector) {
        Set discovered;
        if (clazz == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            discovered = fieldCache.get(clazz);
        }
        if (discovered != null) {
            currentFields.addAll(discovered);
            return;
        }
        Utilities.getAllFieldKeys(clazz.getSuperclass(), currentFields, collector);
        try {
            for (Field field : Utilities.getDeclaredFields(clazz)) {
                currentFields.add(new MemberKey(field, false, false));
            }
            Object object2 = lock;
            synchronized (object2) {
                fieldCache.put(clazz, new LinkedHashSet<MemberKey>(currentFields));
            }
        }
        catch (Throwable throwable) {
            collector.addThrowable(new IllegalStateException("Error while getting fields of class " + clazz.getName(), throwable));
        }
    }

    public static ActiveDescriptor<ServiceLocator> getLocatorDescriptor(ServiceLocator locator) {
        HashSet<Type> contracts = new HashSet<Type>();
        contracts.add((Type)((Object)ServiceLocator.class));
        Set<Annotation> qualifiers = Collections.emptySet();
        ConstantActiveDescriptor<ServiceLocator> retVal = new ConstantActiveDescriptor<ServiceLocator>(locator, contracts, PerLookup.class, null, qualifiers, DescriptorVisibility.LOCAL, 0, null, null, null, locator.getLocatorId(), null);
        return retVal;
    }

    public static ActiveDescriptor<InjectionResolver<Inject>> getThreeThirtyDescriptor(ServiceLocatorImpl locator) {
        ThreeThirtyResolver threeThirtyResolver = new ThreeThirtyResolver(locator);
        HashSet<Type> contracts = new HashSet<Type>();
        Type[] actuals = new Type[]{Inject.class};
        contracts.add((Type)new ParameterizedTypeImpl(InjectionResolver.class, actuals));
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new NamedImpl("SystemInjectResolver"));
        ConstantActiveDescriptor<ThreeThirtyResolver> retVal = new ConstantActiveDescriptor<ThreeThirtyResolver>(threeThirtyResolver, contracts, Singleton.class, "SystemInjectResolver", qualifiers, DescriptorVisibility.NORMAL, 0, null, null, null, locator.getLocatorId(), null);
        return retVal;
    }

    public static Constructor<?> findProducerConstructor(Class<?> annotatedType, ServiceLocatorImpl locator, Collector collector) {
        Constructor<?> zeroArgConstructor = null;
        Constructor<?> aConstructorWithInjectAnnotation = null;
        Set<Constructor<?>> allConstructors = Utilities.getAllConstructors(annotatedType);
        for (Constructor<?> constructor : allConstructors) {
            Type[] rawParameters = constructor.getGenericParameterTypes();
            if (rawParameters.length <= 0) {
                zeroArgConstructor = constructor;
            }
            if (Utilities.hasInjectAnnotation(locator, constructor, true)) {
                if (aConstructorWithInjectAnnotation != null) {
                    collector.addThrowable(new IllegalArgumentException("There is more than one constructor on class " + Pretty.clazz(annotatedType)));
                    return null;
                }
                aConstructorWithInjectAnnotation = constructor;
            }
            if (Utilities.isProperConstructor(constructor)) continue;
            collector.addThrowable(new IllegalArgumentException("The constructor for " + Pretty.clazz(annotatedType) + " may not have an annotation as a parameter"));
            return null;
        }
        if (aConstructorWithInjectAnnotation != null) {
            return aConstructorWithInjectAnnotation;
        }
        if (zeroArgConstructor == null) {
            collector.addThrowable(new NoSuchMethodException("The class " + Pretty.clazz(annotatedType) + " has no constructor marked @Inject and no zero argument constructor"));
            return null;
        }
        return zeroArgConstructor;
    }

    private static boolean isProperConstructor(Constructor<?> c) {
        for (Class<?> pClazz : c.getParameterTypes()) {
            if (!pClazz.isAnnotation()) continue;
            return false;
        }
        return true;
    }

    public static Type getFirstTypeArgument(Type type) {
        if (type instanceof Class) {
            return Object.class;
        }
        if (!(type instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] arguments = pt.getActualTypeArguments();
        if (arguments.length <= 0) {
            return Object.class;
        }
        return arguments[0];
    }

    private static Set<Constructor<?>> getAllConstructors(Class<?> clazz) {
        HashSet retVal = new HashSet();
        HashSet<MemberKey> keys = new HashSet<MemberKey>();
        Utilities.getAllConstructorKeys(clazz, keys);
        for (MemberKey key : keys) {
            retVal.add((Constructor)key.getBackingMember());
        }
        return retVal;
    }

    private static void getAllConstructorKeys(final Class<?> clazz, Set<MemberKey> currentConstructors) {
        Constructor<?>[] constructors;
        if (clazz == null) {
            return;
        }
        for (Constructor<?> constructor : constructors = AccessController.doPrivileged(new PrivilegedAction<Constructor<?>[]>(){

            @Override
            public Constructor<?>[] run() {
                return clazz.getDeclaredConstructors();
            }
        })) {
            currentConstructors.add(new MemberKey(constructor, false, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Method> getAllMethods(Class<?> clazz) {
        LinkedHashSet<Method> retVal = new LinkedHashSet<Method>();
        LinkedHashSet<MemberKey> keys = new LinkedHashSet<MemberKey>();
        Utilities.getAllMethodKeys(clazz, keys);
        Method postConstructMethod = null;
        Method preDestroyMethod = null;
        for (MemberKey key : keys) {
            retVal.add((Method)key.getBackingMember());
            if (key.isPostConstruct()) {
                postConstructMethod = (Method)key.getBackingMember();
            }
            if (!key.isPreDestroy()) continue;
            preDestroyMethod = (Method)key.getBackingMember();
        }
        Object object = lock;
        synchronized (object) {
            postConstructCache.put(clazz, postConstructMethod);
            preDestroyCache.put(clazz, preDestroyMethod);
        }
        return retVal;
    }

    private static boolean isPostConstruct(Method m) {
        if (m.isAnnotationPresent(javax.annotation.PostConstruct.class)) {
            return true;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return CONVENTION_POST_CONSTRUCT.equals(m.getName());
    }

    private static boolean isPreDestroy(Method m) {
        if (m.isAnnotationPresent(javax.annotation.PreDestroy.class)) {
            return true;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return CONVENTION_PRE_DESTROY.equals(m.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getAllMethodKeys(Class<?> clazz, LinkedHashSet<MemberKey> currentMethods) {
        Set discoveredMethods;
        if (clazz == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            discoveredMethods = methodKeyCache.get(clazz);
        }
        if (discoveredMethods != null) {
            currentMethods.addAll(discoveredMethods);
            return;
        }
        Utilities.getAllMethodKeys(clazz.getSuperclass(), currentMethods);
        for (Method method : Utilities.getDeclaredMethods(clazz)) {
            boolean isPostConstruct = Utilities.isPostConstruct(method);
            boolean isPreDestroy = Utilities.isPreDestroy(method);
            currentMethods.add(new MemberKey(method, isPostConstruct, isPreDestroy));
        }
        object = lock;
        synchronized (object) {
            methodKeyCache.put(clazz, new LinkedHashSet<MemberKey>(currentMethods));
        }
    }

    public static Set<Method> findInitializerMethods(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        LinkedHashSet<Method> retVal = new LinkedHashSet<Method>();
        for (Method method : Utilities.getAllMethods(annotatedType)) {
            if (!Utilities.hasInjectAnnotation(locator, method, true)) continue;
            if (!Utilities.isProperMethod(method)) {
                errorCollector.addThrowable(new IllegalArgumentException("An initializer method " + Pretty.method((Method)method) + " is static, abstract or has a parameter that is an annotation"));
                continue;
            }
            retVal.add(method);
        }
        return retVal;
    }

    public static Set<Field> findInitializerFields(Class<?> annotatedType, ServiceLocatorImpl locator, Collector errorCollector) {
        LinkedHashSet<Field> retVal = new LinkedHashSet<Field>();
        for (Field field : Utilities.getAllFields(annotatedType, errorCollector)) {
            if (!Utilities.hasInjectAnnotation(locator, field, false)) continue;
            if (!Utilities.isProperField(field)) {
                errorCollector.addThrowable(new IllegalArgumentException("The field " + Pretty.field((Field)field) + " may not be static, final or have an Annotation type"));
                continue;
            }
            retVal.add(field);
        }
        return retVal;
    }

    private static boolean hasInjectAnnotation(ServiceLocatorImpl locator, AnnotatedElement annotated, boolean checkParams) {
        Annotation[][] allAnnotations;
        boolean isConstructor;
        for (Annotation anno : annotated.getAnnotations()) {
            if (!locator.isInjectAnnotation(anno)) continue;
            return true;
        }
        if (!checkParams) {
            return false;
        }
        if (annotated instanceof Method) {
            Method m = (Method)annotated;
            isConstructor = false;
            allAnnotations = m.getParameterAnnotations();
        } else if (annotated instanceof Constructor) {
            Constructor c = (Constructor)annotated;
            isConstructor = true;
            allAnnotations = c.getParameterAnnotations();
        } else {
            return false;
        }
        Annotation[][] arr$ = allAnnotations;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] allParamAnnotations;
            for (Annotation paramAnno : allParamAnnotations = arr$[i$]) {
                if (!locator.isInjectAnnotation(paramAnno, isConstructor)) continue;
                return true;
            }
        }
        return false;
    }

    private static Annotation getInjectAnnotation(ServiceLocatorImpl locator, AnnotatedElement annotated, boolean checkParams, int position) {
        if (checkParams) {
            boolean isConstructor = false;
            boolean hasParams = false;
            Annotation[][] allAnnotations = null;
            if (annotated instanceof Method) {
                Method m = (Method)annotated;
                isConstructor = false;
                allAnnotations = m.getParameterAnnotations();
                hasParams = true;
            } else if (annotated instanceof Constructor) {
                Constructor c = (Constructor)annotated;
                isConstructor = true;
                allAnnotations = c.getParameterAnnotations();
                hasParams = true;
            }
            if (hasParams) {
                for (Annotation paramAnno : allAnnotations[position]) {
                    if (!locator.isInjectAnnotation(paramAnno, isConstructor)) continue;
                    return paramAnno;
                }
            }
        }
        for (Annotation anno : annotated.getAnnotations()) {
            if (!locator.isInjectAnnotation(anno)) continue;
            return anno;
        }
        return null;
    }

    private static boolean isProperMethod(Method member) {
        if (ReflectionHelper.isStatic((Member)member)) {
            return false;
        }
        if (Utilities.isAbstract(member)) {
            return false;
        }
        for (Class<?> paramClazz : member.getParameterTypes()) {
            if (!paramClazz.isAnnotation()) continue;
            return false;
        }
        return true;
    }

    private static boolean isProperField(Field field) {
        if (ReflectionHelper.isStatic((Member)field)) {
            return false;
        }
        if (Utilities.isFinal(field)) {
            return false;
        }
        Class<?> type = field.getType();
        return !type.isAnnotation();
    }

    public static boolean isPrivate(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 2) != 0;
    }

    public static boolean isAbstract(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x400) != 0;
    }

    public static boolean isFinal(Member member) {
        int modifiers = member.getModifiers();
        return (modifiers & 0x10) != 0;
    }

    public static String getAutoAnalyzerName(Class<?> c) {
        Service s = c.getAnnotation(Service.class);
        if (s == null) {
            return null;
        }
        return s.analyzer();
    }

    private static ScopeInfo getScopeInfo(AnnotatedElement annotatedGuy, Descriptor defaultScope, Collector collector) {
        Class<?> descScope;
        Class topLevelElement = annotatedGuy;
        Annotation winnerScope = null;
        block0: while (annotatedGuy != null) {
            Annotation current = Utilities.internalGetScopeAnnotationType(annotatedGuy, collector);
            if (current != null) {
                if (annotatedGuy.equals(topLevelElement)) {
                    winnerScope = current;
                    break;
                }
                if (!current.annotationType().isAnnotationPresent(Inherited.class)) break;
                winnerScope = current;
                break;
            }
            if (annotatedGuy instanceof Class) {
                annotatedGuy = ((Class)annotatedGuy).getSuperclass();
                continue;
            }
            Method theMethod = (Method)annotatedGuy;
            Class<?> methodClass = theMethod.getDeclaringClass();
            annotatedGuy = null;
            for (Class<?> methodSuperclass = methodClass.getSuperclass(); methodSuperclass != null; methodSuperclass = methodSuperclass.getSuperclass()) {
                if (!Factory.class.isAssignableFrom(methodSuperclass)) continue;
                annotatedGuy = Utilities.getFactoryProvideMethod(methodSuperclass);
                continue block0;
            }
        }
        if (winnerScope != null) {
            return new ScopeInfo(winnerScope, winnerScope.annotationType());
        }
        if (topLevelElement.isAnnotationPresent(Service.class)) {
            return new ScopeInfo(null, Singleton.class);
        }
        if (defaultScope != null && defaultScope.getScope() != null && (descScope = Utilities.loadClass(defaultScope.getScope(), defaultScope, collector)) != null) {
            return new ScopeInfo(null, descScope);
        }
        return new ScopeInfo(null, PerLookup.class);
    }

    public static Class<? extends Annotation> getScopeAnnotationType(Class<?> fromThis, Descriptor defaultScope) {
        Collector collector = new Collector();
        ScopeInfo si = Utilities.getScopeInfo(fromThis, defaultScope, collector);
        collector.throwIfErrors();
        return si.getAnnoType();
    }

    public static Class<? extends Annotation> getScopeAnnotationType(AnnotatedElement annotatedGuy, Descriptor defaultScope, Collector collector) {
        ScopeInfo si = Utilities.getScopeInfo(annotatedGuy, defaultScope, collector);
        return si.getAnnoType();
    }

    private static Annotation internalGetScopeAnnotationType(AnnotatedElement annotatedGuy, Collector collector) {
        boolean epicFail = false;
        Annotation retVal = null;
        for (Annotation annotation : annotatedGuy.getDeclaredAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(Scope.class)) continue;
            if (retVal != null) {
                collector.addThrowable(new IllegalArgumentException("The type " + annotatedGuy + " may not have more than one scope.  It has at least " + Pretty.clazz(retVal.annotationType()) + " and " + Pretty.clazz(annotation.annotationType())));
                epicFail = true;
                continue;
            }
            retVal = annotation;
        }
        if (epicFail) {
            return null;
        }
        return retVal;
    }

    public static InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, Injectee injectee) throws IllegalStateException {
        return Utilities.getInjectionResolver(locator, injectee.getParent(), injectee.getPosition());
    }

    private static InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, AnnotatedElement annotatedGuy, int position) throws IllegalStateException {
        boolean methodOrConstructor = annotatedGuy instanceof Method || annotatedGuy instanceof Constructor;
        Annotation injectAnnotation = Utilities.getInjectAnnotation(locator, annotatedGuy, methodOrConstructor, position);
        Class injectType = injectAnnotation == null ? Inject.class : injectAnnotation.annotationType();
        InjectionResolver<?> retVal = locator.getInjectionResolver(injectType);
        if (retVal == null) {
            throw new IllegalStateException("There is no installed injection resolver for " + Pretty.clazz(injectType) + " for type " + annotatedGuy);
        }
        return retVal;
    }

    public static InjectionResolver<?> getInjectionResolver(ServiceLocatorImpl locator, AnnotatedElement annotatedGuy) throws IllegalStateException {
        if (annotatedGuy instanceof Method || annotatedGuy instanceof Constructor) {
            throw new IllegalArgumentException("Annotated element '" + annotatedGuy + "' cannot be Method neither Constructor.");
        }
        return Utilities.getInjectionResolver(locator, annotatedGuy, -1);
    }

    public static Method getFactoryProvideMethod(Class<?> clazz) {
        try {
            return clazz.getMethod(PROVIDE_METHOD, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static String getDefaultNameFromMethod(Method parent, Collector collector) {
        Named named = parent.getAnnotation(Named.class);
        if (named == null) {
            return null;
        }
        if (named.value() == null || named.value().equals("")) {
            collector.addThrowable(new IllegalArgumentException("@Named on the provide method of a factory must have an explicit value"));
        }
        return named.value();
    }

    public static Set<Annotation> getAllQualifiers(AnnotatedElement annotatedGuy, String name, Collector collector) {
        Named namedQualifier = null;
        Set retVal = ReflectionHelper.getQualifierAnnotations((AnnotatedElement)annotatedGuy);
        for (Annotation anno : retVal) {
            if (!(anno instanceof Named)) continue;
            namedQualifier = (Named)anno;
            break;
        }
        if (name == null) {
            if (namedQualifier != null) {
                collector.addThrowable(new IllegalArgumentException("No name was in the descriptor, but this element(" + annotatedGuy + " has a Named annotation with value: " + namedQualifier.value()));
                retVal.remove(namedQualifier);
            }
            return retVal;
        }
        if (namedQualifier == null || namedQualifier.value().equals("")) {
            if (namedQualifier != null) {
                retVal.remove(namedQualifier);
            }
            namedQualifier = new NamedImpl(name);
            retVal.add(namedQualifier);
        }
        if (!name.equals(namedQualifier.value())) {
            collector.addThrowable(new IllegalArgumentException("The class had an @Named qualifier that was inconsistent.  The expected name is " + name + " but the annotation has name " + namedQualifier.value()));
        }
        return retVal;
    }

    private static Set<Annotation> getAllQualifiers(Annotation[] memberAnnotations) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        for (Annotation annotation : memberAnnotations) {
            if (!ReflectionHelper.isAnnotationAQualifier((Annotation)annotation)) continue;
            retVal.add(annotation);
        }
        return retVal;
    }

    private static boolean isOptional(Annotation[] memberAnnotations) {
        for (Annotation annotation : memberAnnotations) {
            if (!annotation.annotationType().equals(Optional.class)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSelf(Annotation[] memberAnnotations) {
        for (Annotation annotation : memberAnnotations) {
            if (!annotation.annotationType().equals(Self.class)) continue;
            return true;
        }
        return false;
    }

    public static List<Injectee> getConstructorInjectees(Constructor<?> c, ActiveDescriptor<?> injecteeDescriptor) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        Unqualified unqualified = c.getAnnotation(Unqualified.class);
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        for (int lcv = 0; lcv < genericTypeParams.length; ++lcv) {
            retVal.add(new InjecteeImpl(genericTypeParams[lcv], Utilities.getAllQualifiers(paramAnnotations[lcv]), lcv, c, Utilities.isOptional(paramAnnotations[lcv]), Utilities.isSelf(paramAnnotations[lcv]), unqualified, injecteeDescriptor));
        }
        return retVal;
    }

    public static List<Injectee> getMethodInjectees(Method c, ActiveDescriptor<?> injecteeDescriptor) {
        Type[] genericTypeParams = c.getGenericParameterTypes();
        Annotation[][] paramAnnotations = c.getParameterAnnotations();
        Unqualified unqualified = c.getAnnotation(Unqualified.class);
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        for (int lcv = 0; lcv < genericTypeParams.length; ++lcv) {
            retVal.add(new InjecteeImpl(genericTypeParams[lcv], Utilities.getAllQualifiers(paramAnnotations[lcv]), lcv, c, Utilities.isOptional(paramAnnotations[lcv]), Utilities.isSelf(paramAnnotations[lcv]), unqualified, injecteeDescriptor));
        }
        return retVal;
    }

    private static Set<Annotation> getFieldAdjustedQualifierAnnotations(Field f) {
        Set unadjustedAnnotations = ReflectionHelper.getQualifierAnnotations((AnnotatedElement)f);
        Named n = f.getAnnotation(Named.class);
        if (n == null) {
            return unadjustedAnnotations;
        }
        if (n.value() == null || "".equals(n.value())) {
            unadjustedAnnotations.add(new NamedImpl(f.getName()));
        }
        return unadjustedAnnotations;
    }

    public static List<Injectee> getFieldInjectees(Field f, ActiveDescriptor<?> injecteeDescriptor) {
        LinkedList<Injectee> retVal = new LinkedList<Injectee>();
        Unqualified unqualified = f.getAnnotation(Unqualified.class);
        retVal.add(new InjecteeImpl(f.getGenericType(), Utilities.getFieldAdjustedQualifierAnnotations(f), -1, f, Utilities.isOptional(f.getAnnotations()), Utilities.isSelf(f.getAnnotations()), unqualified, injecteeDescriptor));
        return retVal;
    }

    public static void validateSelfInjectees(ActiveDescriptor<?> givenDescriptor, List<Injectee> injectees, Collector collector) {
        for (Injectee injectee : injectees) {
            if (!injectee.isSelf()) continue;
            Class requiredRawClass = ReflectionHelper.getRawClass((Type)injectee.getRequiredType());
            if (requiredRawClass == null || !ActiveDescriptor.class.equals((Object)requiredRawClass)) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " does not have the required type of ActiveDescriptor"));
            }
            if (injectee.isOptional()) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " is marked both @Optional and @Self"));
            }
            if (!injectee.getRequiredQualifiers().isEmpty()) {
                collector.addThrowable(new IllegalArgumentException("Injection point " + injectee + " is marked @Self but has other qualifiers"));
            }
            if (givenDescriptor != null) continue;
            collector.addThrowable(new IllegalArgumentException("A class with injection point " + injectee + " is being created or injected via the non-managed ServiceLocator API"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method findPostConstruct(Class<?> clazz, Collector collector) {
        Method retVal;
        boolean containsKey;
        if (PostConstruct.class.isAssignableFrom(clazz)) {
            try {
                return clazz.getMethod(CONVENTION_POST_CONSTRUCT, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        Object object = lock;
        synchronized (object) {
            containsKey = postConstructCache.containsKey(clazz);
            retVal = postConstructCache.get(clazz);
        }
        if (!containsKey) {
            Utilities.getAllMethods(clazz);
            object = lock;
            synchronized (object) {
                retVal = postConstructCache.get(clazz);
            }
        }
        if (retVal == null) {
            return null;
        }
        if (retVal.isAnnotationPresent(javax.annotation.PostConstruct.class) && retVal.getParameterTypes().length != 0) {
            collector.addThrowable(new IllegalArgumentException("The method " + Pretty.method((Method)retVal) + " annotated with @PostConstruct must not have any arguments"));
            return null;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method findPreDestroy(Class<?> clazz, Collector collector) {
        Method retVal;
        boolean containsKey;
        if (PreDestroy.class.isAssignableFrom(clazz)) {
            try {
                return clazz.getMethod(CONVENTION_PRE_DESTROY, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        Object object = lock;
        synchronized (object) {
            containsKey = preDestroyCache.containsKey(clazz);
            retVal = preDestroyCache.get(clazz);
        }
        if (!containsKey) {
            Utilities.getAllMethods(clazz);
            object = lock;
            synchronized (object) {
                retVal = preDestroyCache.get(clazz);
            }
        }
        if (retVal == null) {
            return null;
        }
        if (retVal.isAnnotationPresent(javax.annotation.PreDestroy.class) && retVal.getParameterTypes().length != 0) {
            collector.addThrowable(new IllegalArgumentException("The method " + Pretty.method((Method)retVal) + " annotated with @PreDestroy must not have any arguments"));
            return null;
        }
        return retVal;
    }

    public static Set<Annotation> fixAndCheckQualifiers(Annotation[] qualifiers, String name) {
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        HashSet<String> dupChecker = new HashSet<String>();
        Named named = null;
        for (Annotation qualifier : qualifiers) {
            String annotationType = qualifier.annotationType().getName();
            if (dupChecker.contains(annotationType)) {
                throw new IllegalArgumentException(annotationType + " appears more than once in the qualifier list");
            }
            dupChecker.add(annotationType);
            retVal.add(qualifier);
            if (!(qualifier instanceof Named)) continue;
            named = (Named)qualifier;
            if (named.value().equals("")) {
                throw new IllegalArgumentException("The @Named qualifier must have a value");
            }
            if (name == null || name.equals(named.value())) continue;
            throw new IllegalArgumentException("The name passed to the method (" + name + ") does not match the value of the @Named qualifier (" + named.value() + ")");
        }
        if (named == null && name != null) {
            retVal.add((Annotation)new NamedImpl(name));
        }
        return retVal;
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    private static <T> T secureCreate(final Class<?> superclass, final Class<?>[] interfaces, final MethodInterceptor callback, boolean useJDKProxy) {
        final ClassLoader delegatingLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new DelegatingClassLoader(Enhancer.class.getClassLoader(), superclass.getClassLoader());
            }
        });
        if (useJDKProxy) {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    return Proxy.newProxyInstance(delegatingLoader, interfaces, (InvocationHandler)new MethodInterceptorInvocationHandler(callback));
                }
            });
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                EnhancerWithClassLoader e = new EnhancerWithClassLoader(delegatingLoader);
                e.setSuperclass(superclass);
                e.setInterfaces(interfaces);
                e.setCallback((Callback)callback);
                return e.create();
            }
        });
    }

    public static <T> T createService(ActiveDescriptor<T> root, Injectee injectee, ServiceLocatorImpl locator, ServiceHandle<T> handle, Class<?> requestedClass) {
        Context<?> context;
        if (root == null) {
            throw new IllegalArgumentException();
        }
        Object service = null;
        if (!root.isReified()) {
            root = locator.reifyDescriptor((Descriptor)root, injectee);
        }
        if (Utilities.isProxiable(root, injectee)) {
            T proxy;
            Class[] iFaces;
            Class<?> proxyClass;
            boolean isInterface;
            boolean bl = isInterface = requestedClass == null ? false : requestedClass.isInterface();
            if (isInterface) {
                proxyClass = requestedClass;
                iFaces = new Class[]{proxyClass, ProxyCtl.class};
            } else {
                proxyClass = Utilities.getFactoryAwareImplementationClass(root);
                iFaces = Utilities.getInterfacesForProxy(root.getContractTypes());
            }
            try {
                proxy = Utilities.secureCreate(proxyClass, iFaces, new MethodInterceptorImpl(locator, (ActiveDescriptor<?>)root, handle), isInterface);
            }
            catch (Throwable th) {
                IllegalArgumentException addMe = new IllegalArgumentException("While attempting to create a Proxy for " + proxyClass.getName() + " in proxiable scope " + root.getScope() + " an error occured while creating the proxy");
                if (th instanceof MultiException) {
                    MultiException me = (MultiException)th;
                    me.addError((Throwable)addMe);
                    throw me;
                }
                MultiException me = new MultiException(th);
                me.addError((Throwable)addMe);
                throw me;
            }
            return proxy;
        }
        try {
            context = locator.resolveContext(root.getScopeAnnotation());
        }
        catch (Throwable th) {
            IllegalStateException addMe = new IllegalStateException("While attempting to create a service for " + root + " in scope " + root.getScope() + " an error occured while locating the context");
            if (th instanceof MultiException) {
                MultiException me = (MultiException)th;
                me.addError((Throwable)addMe);
                throw me;
            }
            MultiException me = new MultiException(th);
            me.addError((Throwable)addMe);
            throw me;
        }
        try {
            service = context.findOrCreate(root, handle);
        }
        catch (MultiException me) {
            throw me;
        }
        catch (Throwable th) {
            throw new MultiException(th);
        }
        if (service == null && !context.supportsNullCreation()) {
            throw new MultiException((Throwable)new IllegalStateException("Context " + context + " findOrCreate returned a null for descriptor " + root + " and handle " + handle));
        }
        return (T)service;
    }

    private static class MethodInterceptorInvocationHandler
    implements InvocationHandler {
        private final MethodInterceptor interceptor;

        private MethodInterceptorInvocationHandler(MethodInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.interceptor.intercept(proxy, method, args, null);
        }
    }

    private static class ScopeInfo {
        private final Annotation scope;
        private final Class<? extends Annotation> annoType;

        private ScopeInfo(Annotation scope, Class<? extends Annotation> annoType) {
            this.scope = scope;
            this.annoType = annoType;
        }

        private Annotation getScope() {
            return this.scope;
        }

        private Class<? extends Annotation> getAnnoType() {
            return this.annoType;
        }
    }

    private static class MemberKey {
        private final Member backingMember;
        private final int hashCode;
        private final boolean postConstruct;
        private final boolean preDestroy;

        private MemberKey(Member method, boolean isPostConstruct, boolean isPreDestroy) {
            this.backingMember = method;
            this.hashCode = this.calculateHashCode();
            this.postConstruct = isPostConstruct;
            this.preDestroy = isPreDestroy;
        }

        private Member getBackingMember() {
            return this.backingMember;
        }

        private boolean isPostConstruct() {
            return this.postConstruct;
        }

        private boolean isPreDestroy() {
            return this.preDestroy;
        }

        private int calculateHashCode() {
            int startCode = 0;
            if (this.backingMember instanceof Method) {
                startCode = 1;
            } else if (this.backingMember instanceof Constructor) {
                startCode = 2;
            }
            startCode ^= this.backingMember.getName().hashCode();
            Class<Object>[] parameters = this.backingMember instanceof Method ? ((Method)this.backingMember).getParameterTypes() : (this.backingMember instanceof Constructor ? ((Constructor)this.backingMember).getParameterTypes() : new Class[]{});
            for (Class<?> clazz : parameters) {
                startCode ^= clazz.hashCode();
            }
            return startCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            Class<?>[] bParams;
            Class<?>[] oParams;
            if (o == null) {
                return false;
            }
            if (!(o instanceof MemberKey)) {
                return false;
            }
            MemberKey omk = (MemberKey)o;
            if (this.hashCode != omk.hashCode) {
                return false;
            }
            Member oMember = omk.backingMember;
            if (oMember.equals(this.backingMember)) {
                return true;
            }
            if (this.backingMember instanceof Field || oMember instanceof Field) {
                return false;
            }
            if (this.backingMember instanceof Method && !(oMember instanceof Method)) {
                return false;
            }
            if (this.backingMember instanceof Constructor && !(oMember instanceof Constructor)) {
                return false;
            }
            if (!oMember.getName().equals(this.backingMember.getName())) {
                return false;
            }
            if (Utilities.isPrivate(this.backingMember) || Utilities.isPrivate(oMember)) {
                return false;
            }
            if (this.backingMember instanceof Method) {
                oParams = ((Method)oMember).getParameterTypes();
                bParams = ((Method)this.backingMember).getParameterTypes();
            } else if (this.backingMember instanceof Constructor) {
                oParams = ((Constructor)oMember).getParameterTypes();
                bParams = ((Constructor)this.backingMember).getParameterTypes();
            } else {
                oParams = new Class[]{};
                bParams = new Class[]{};
            }
            if (oParams.length != bParams.length) {
                return false;
            }
            for (int i = 0; i < oParams.length; ++i) {
                if (oParams[i] == bParams[i]) continue;
                return false;
            }
            return true;
        }
    }
}

