/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import javassist.util.proxy.MethodHandler;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.internal.ServiceLocatorImpl;

public class MethodInterceptorHandler
implements MethodHandler {
    private final ServiceLocatorImpl locator;
    private final Map<Method, List<MethodInterceptor>> interceptorLists;
    private final ActiveDescriptor<?> underlyingDescriptor;

    MethodInterceptorHandler(ServiceLocatorImpl locator, ActiveDescriptor<?> underlyingDescriptor, Map<Method, List<MethodInterceptor>> interceptorLists) {
        this.locator = locator;
        this.interceptorLists = interceptorLists;
        this.underlyingDescriptor = underlyingDescriptor;
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (thisMethod.getName().equals("__getUnderlyingDescriptor")) {
            return this.underlyingDescriptor;
        }
        List<MethodInterceptor> interceptors = this.interceptorLists.get(thisMethod);
        if (interceptors == null || interceptors.isEmpty()) {
            return ReflectionHelper.invoke((Object)self, (Method)proceed, (Object[])args, (boolean)this.locator.getNeutralContextClassLoader());
        }
        if (!(interceptors instanceof RandomAccess)) {
            interceptors = new ArrayList<MethodInterceptor>(interceptors);
        }
        MethodInterceptor nextInterceptor = interceptors.get(0);
        return nextInterceptor.invoke((MethodInvocation)new MethodInvocationImpl(args, thisMethod, self, interceptors, 0, proceed));
    }

    private class MethodInvocationImpl
    implements MethodInvocation {
        private final Object[] arguments;
        private final Method method;
        private final Object myself;
        private final List<MethodInterceptor> interceptors;
        private final int index;
        private final Method proceed;

        private MethodInvocationImpl(Object[] arguments, Method method, Object myself, List<MethodInterceptor> interceptors, int index, Method proceed) {
            this.arguments = arguments;
            this.method = method;
            this.myself = myself;
            this.interceptors = interceptors;
            this.index = index;
            this.proceed = proceed;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public AccessibleObject getStaticPart() {
            return this.method;
        }

        public Object getThis() {
            return this.myself;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object proceed() throws Throwable {
            int newIndex = this.index + 1;
            if (newIndex >= this.interceptors.size()) {
                return ReflectionHelper.invoke((Object)this.myself, (Method)this.proceed, (Object[])this.arguments, (boolean)MethodInterceptorHandler.this.locator.getNeutralContextClassLoader());
            }
            MethodInterceptor nextInterceptor = this.interceptors.get(newIndex);
            return nextInterceptor.invoke((MethodInvocation)new MethodInvocationImpl(this.arguments, this.method, this.myself, this.interceptors, newIndex, this.proceed));
        }
    }
}

