/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import org.glassfish.hk2.api.Descriptor;
import org.jvnet.hk2.internal.DescriptorComparator;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.SystemDescriptor;

public class IndexedListData {
    private static final DescriptorComparator UNSORTED_COMPARATOR = new DescriptorComparator();
    private final LinkedList<SystemDescriptor<?>> unsortedList = new LinkedList();
    private volatile LinkedList<SystemDescriptor<?>> sortedList = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SystemDescriptor<?>> getSortedList() {
        if (this.sortedList != null) {
            return this.sortedList;
        }
        IndexedListData indexedListData = this;
        synchronized (indexedListData) {
            if (this.sortedList != null) {
                return this.sortedList;
            }
            if (this.unsortedList.size() <= 1) {
                this.sortedList = new LinkedList(this.unsortedList);
                return this.sortedList;
            }
            TreeSet<Descriptor> sorter = new TreeSet<Descriptor>(ServiceLocatorImpl.DESCRIPTOR_COMPARATOR);
            sorter.addAll(this.unsortedList);
            this.sortedList = new LinkedList<Descriptor>(sorter);
            return this.sortedList;
        }
    }

    public synchronized void addDescriptor(SystemDescriptor<?> descriptor) {
        this.unsortedList.add(descriptor);
        this.sortedList = null;
        descriptor.addList(this);
    }

    public synchronized void removeDescriptor(SystemDescriptor<?> descriptor) {
        ListIterator iterator = this.unsortedList.listIterator();
        while (iterator.hasNext()) {
            SystemDescriptor candidate = (SystemDescriptor)iterator.next();
            if (UNSORTED_COMPARATOR.compare((Descriptor)descriptor, (Descriptor)candidate) != 0) continue;
            iterator.remove();
            break;
        }
        this.sortedList = null;
        descriptor.removeList(this);
    }

    public synchronized boolean isEmpty() {
        return this.unsortedList.isEmpty();
    }

    public synchronized void unSort() {
        this.sortedList = null;
    }

    public synchronized void clear() {
        this.sortedList = null;
        for (SystemDescriptor systemDescriptor : this.unsortedList) {
            systemDescriptor.removeList(this);
        }
        this.unsortedList.clear();
    }

    public synchronized int size() {
        return this.unsortedList.size();
    }
}

