/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.maven.MavenModuleDefinition;
import com.sun.enterprise.module.maven.MavenProjectRepository;
import com.sun.enterprise.tools.verifier.hk2.ModuleDependencyAnalyser;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class DependencyAnalyserMojo
extends AbstractMojo {
    private static Logger logger = Logger.getAnonymousLogger();
    protected MavenProject project;
    protected Artifact artifact;
    private ArtifactResolver artifactResolver;
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    protected File outputDirectory;
    protected String finalName;
    private boolean failOnVerificationError;
    private boolean analyseDependency;
    private HashSet<String> excludedPatterns;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.analyseDependency || Boolean.getBoolean("do-not-analyse-dependency")) {
            logger.logp(Level.INFO, "DependencyAnalyserMojo", "execute", "Skipping analyse-dependency goal");
            return;
        }
        logger.logp(Level.INFO, "DependencyAnalyserMojo", "execute", "Verifying module dependencies");
        if (!this.project.getPackaging().equals("hk2-jar")) {
            System.out.println("Skipping this project as it does not use hk2-jar packaging");
            return;
        }
        try {
            MavenProjectRepository repo = new MavenProjectRepository(this.project, this.artifactResolver, this.localRepository, this.artifactFactory);
            repo.initialize();
            File location = this.artifact.getFile();
            if (location == null && !(location = new File(this.outputDirectory, this.finalName + ".jar")).exists()) {
                throw new MojoExecutionException(location + " does not exist, so can't execute. Package the artifact first.");
            }
            MavenModuleDefinition moduleDef = new MavenModuleDefinition(repo, location);
            ModuleDependencyAnalyser analyser = new ModuleDependencyAnalyser((ModuleDefinition)moduleDef, (Repository)repo);
            if (this.excludedPatterns != null) {
                analyser.excludePatterns(this.excludedPatterns);
            }
            if (!analyser.analyse()) {
                String msg = "Missing dependency. See details below:\n" + analyser.getResultAsString();
                if (this.failOnVerificationError) {
                    throw new MojoExecutionException(msg);
                }
                logger.logp(Level.WARNING, "DependencyAnalyserMojo", "execute", msg);
            } else {
                logger.logp(Level.INFO, "DependencyAnalyserMojo", "execute", "Dependency correctly set up");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unexpected exception", (Exception)e);
        }
    }
}

