/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.osgi.framework.Version;

class VersionTranslator {
    private static Logger logger = Logger.getAnonymousLogger();

    VersionTranslator() {
    }

    public static String MavenToOSGi(String mvs) {
        try {
            DefaultArtifactVersion mv = new DefaultArtifactVersion(mvs);
            int major = mv.getMajorVersion();
            int minor = mv.getMinorVersion();
            int micro = mv.getIncrementalVersion();
            String qualifier = mv.getBuildNumber() != 0 ? Integer.toString(mv.getBuildNumber()) : mv.getQualifier();
            logger.logp(Level.INFO, "VersionTranslator", "MavenToOSGi", "qualifier = {0}", qualifier);
            Version ov = qualifier == null ? new Version(major, minor, micro) : new Version(major, minor, micro, qualifier);
            logger.logp(Level.INFO, "VersionTranslator", "MavenToOSGi", "{0} -> {1}", new Object[]{mvs, ov});
            return ov.toString();
        }
        catch (RuntimeException e) {
            logger.logp(Level.INFO, "VersionTranslator", "MavenToOSGi", "Following exception was raised while translating Maven version {0} to OSGi version: {1}", new Object[]{mvs, e});
            throw e;
        }
    }

    public static String OSGiToMaven(String ovs) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Enter maven version:");
        DataInputStream in = new DataInputStream(System.in);
        String mvs = in.readLine();
        System.out.println("OSGI version: " + VersionTranslator.MavenToOSGi(mvs));
    }
}

