/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelController;
import org.glassfish.hk2.runlevel.RunLevelException;
import org.glassfish.hk2.runlevel.utilities.Utilities;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RunLevelContext
implements Context<RunLevel> {
    private Map<String, Map<ActiveDescriptor<?>, Object>> backingMaps = new HashMap();
    @Inject
    private IterableProvider<RunLevelController> allRunLevelControllers;

    public Class<? extends Annotation> getScope() {
        return RunLevel.class;
    }

    public <T> T findOrCreate(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) {
        String rlsName = Utilities.getRunLevelControllerName(activeDescriptor);
        Map<ActiveDescriptor<?>, Object> backingMap = this.getBackingMap(rlsName);
        if (backingMap.containsKey(activeDescriptor)) {
            return (T)backingMap.get(activeDescriptor);
        }
        int mode = Utilities.getRunLevelMode(activeDescriptor);
        RunLevelController RunLevelController2 = this.getRunLevelController(rlsName);
        if (RunLevelController2 == null) {
            throw new RunLevelException("Can't find a run level controller for " + rlsName);
        }
        if (mode == 1) {
            this.validate(activeDescriptor, RunLevelController2);
        }
        Object service = activeDescriptor.create(root);
        backingMap.put(activeDescriptor, service);
        RunLevelController2.recordActivation(activeDescriptor);
        return (T)service;
    }

    public boolean containsKey(ActiveDescriptor<?> activeDescriptor) {
        Map<ActiveDescriptor<?>, Object> backingStore = this.getBackingMap(Utilities.getRunLevelControllerName(activeDescriptor));
        return backingStore.containsKey(activeDescriptor);
    }

    public boolean isActive() {
        return true;
    }

    public void shutdown() {
    }

    public <T> void deactivate(ActiveDescriptor<T> activeDescriptor) {
        Map<ActiveDescriptor<?>, Object> backingStore = this.getBackingMap(Utilities.getRunLevelControllerName(activeDescriptor));
        if (backingStore.containsKey(activeDescriptor)) {
            activeDescriptor.dispose(backingStore.get(activeDescriptor));
            backingStore.remove(activeDescriptor);
        }
    }

    private void validate(ActiveDescriptor<?> descriptor, RunLevelController service) throws RunLevelException {
        Integer runLevel = Utilities.getRunLevelValue(descriptor);
        Integer planned = service.getPlannedRunLevel();
        Integer current = service.getCurrentRunLevel();
        if (runLevel > current && (planned == null || runLevel > planned)) {
            throw new RunLevelException("Unable to activate " + descriptor + "; minimum expected RunLevel is: " + runLevel + "; planned is: " + planned + "; current is: " + current + ".");
        }
    }

    private Map<ActiveDescriptor<?>, Object> getBackingMap(String name) {
        Map<ActiveDescriptor<?>, Object> backingMap = this.backingMaps.get(name);
        if (backingMap == null) {
            backingMap = new HashMap();
            this.backingMaps.put(name, backingMap);
        }
        return backingMap;
    }

    private <T> RunLevelController getRunLevelController(String name) {
        RunLevelController controller = (RunLevelController)this.allRunLevelControllers.named(name).get();
        return controller == null ? (RunLevelController)this.allRunLevelControllers.get() : controller;
    }

    public boolean supportsNullCreation() {
        return false;
    }
}

