/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.Activator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelController;
import org.glassfish.hk2.runlevel.RunLevelException;
import org.glassfish.hk2.runlevel.RunLevelListener;
import org.glassfish.hk2.runlevel.Sorter;
import org.glassfish.hk2.runlevel.internal.RunLevelContext;
import org.glassfish.hk2.runlevel.utilities.Utilities;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;

@Service
public class RunLevelControllerImpl
implements RunLevelController,
Activator {
    public static final long DEFAULT_ASYNC_WAIT = 3000L;
    private static final Logger logger = Logger.getLogger(RunLevelControllerImpl.class.getName());
    private static final Level LEVEL = Level.FINE;
    private final Object lock = new Object();
    private final boolean asyncMode;
    private final ExecutorService exec;
    private String name;
    private Integer currentRunLevel = -2;
    private final HashMap<Integer, Stack<ActiveDescriptor<?>>> recorders = new LinkedHashMap();
    private Worker worker;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private IterableProvider<RunLevelListener> allRunLevelListeners;
    @Inject
    private IterableProvider<Activator> allActivators;
    @Inject
    private IterableProvider<Sorter> allSorters;
    @Inject
    private Provider<RunLevelContext> contextProvider;

    public RunLevelControllerImpl() {
        this(false);
    }

    private RunLevelControllerImpl(boolean async) {
        this.asyncMode = async;
        this.exec = this.asyncMode ? Executors.newCachedThreadPool(new ThreadFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(Runnable runnable) {
                RunLevelControllerThread activeThread = new RunLevelControllerThread(runnable);
                Object object = RunLevelControllerImpl.this.lock;
                synchronized (object) {
                    logger.log(Level.FINE, "new thread: {0}", activeThread);
                }
                return activeThread;
            }
        }) : null;
    }

    @PostConstruct
    public void postConstruct() {
        Named named = this.getClass().getAnnotation(Named.class);
        this.name = named == null ? "__runLevelControllerDefaultName" : named.value();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getCurrentRunLevel() {
        return this.currentRunLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getPlannedRunLevel() {
        Object object = this.lock;
        synchronized (object) {
            return null == this.worker ? null : this.worker.getPlannedRunLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordActivation(ActiveDescriptor<?> descriptor) {
        Stack<Object> activeRecorder;
        Integer activeRunLevel = Utilities.getRunLevelValue(descriptor);
        Object object = this.lock;
        synchronized (object) {
            activeRecorder = this.recorders.get(activeRunLevel);
            if (null == activeRecorder) {
                activeRecorder = new Stack();
                this.recorders.put(activeRunLevel, activeRecorder);
            }
        }
        activeRecorder.push(descriptor);
    }

    @Override
    public void proceedTo(int runLevel) {
        this.proceedTo(runLevel, false);
    }

    @Override
    public void interrupt() {
        this.proceedTo(null, true);
    }

    @Override
    public void activate(ActiveDescriptor<?> descriptor) {
        this.serviceLocator.getServiceHandle(descriptor).getService();
    }

    @Override
    public void deactivate(ActiveDescriptor<?> descriptor) {
        ((RunLevelContext)this.contextProvider.get()).deactivate(descriptor);
    }

    @Override
    public void awaitCompletion() throws InterruptedException, ExecutionException, TimeoutException {
    }

    @Override
    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "-" + System.identityHashCode(this) + "(" + this.getDescription(false) + ")";
    }

    public String getDescription(boolean extended) {
        StringBuilder b = new StringBuilder();
        b.append("curr=").append(this.getCurrentRunLevel()).append(", ");
        b.append("act=").append(this.getActivatingRunLevel()).append(", ");
        b.append("plan=").append(this.getPlannedRunLevel()).append(", ");
        b.append("scope=").append(this.getName()).append(", ");
        if (extended) {
            b.append("thrd=").append(Thread.currentThread()).append(", ");
        }
        return b.toString();
    }

    public HashMap<Integer, Stack<ActiveDescriptor<?>>> getRecorders() {
        return this.recorders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getActivatingRunLevel() {
        Object object = this.lock;
        synchronized (object) {
            return null == this.worker ? null : this.worker.getActivatingRunLevel();
        }
    }

    protected boolean accept(ActiveDescriptor<?> descriptor, int activeRunLevel) {
        Integer runLevel = Utilities.getRunLevelValue(descriptor);
        if (runLevel != null && runLevel != activeRunLevel) {
            return false;
        }
        return this.getName().equals(Utilities.getRunLevelControllerName(descriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCancelled(Worker worker) {
        Object object = this.lock;
        synchronized (object) {
            return this.worker != worker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(Worker worker) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCancelled(worker)) {
                this.worker = null;
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrent(Worker worker, Integer current) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCancelled(worker)) {
                return;
            }
            this.currentRunLevel = current;
        }
        this.event(worker, ListenerEvent.PROGRESS, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> getRecordersToRelease(int runLevel) {
        ArrayList<Integer> qualifying = new ArrayList<Integer>();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<Integer, Stack<ActiveDescriptor<?>>> entry : this.recorders.entrySet()) {
                int entryKey = entry.getKey();
                if (entryKey < runLevel) continue;
                qualifying.add(entry.getKey());
            }
        }
        Collections.sort(qualifying);
        Collections.reverse(qualifying);
        return qualifying;
    }

    protected void event(Worker worker, ListenerEvent event, Throwable error, boolean isHardInterrupt) {
        logger.log(LEVEL, "event {0} - " + this.getDescription(true), (Object)event);
        if (this.isCancelled(worker)) {
            logger.log(LEVEL, "Ignoring this notification!");
        } else {
            Interrupt lastInterrupt = null;
            Collection<RunLevelListener> activeListeners = this.getListeners();
            for (RunLevelListener listener : activeListeners) {
                try {
                    if (ListenerEvent.PROGRESS == event) {
                        listener.onProgress(this);
                        continue;
                    }
                    if (ListenerEvent.CANCEL == event) {
                        listener.onCancelled(this, this.currentRunLevel, isHardInterrupt);
                        continue;
                    }
                    listener.onError(this, error, true);
                }
                catch (Interrupt interrupt) {
                    lastInterrupt = interrupt;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "swallowing exception - " + this.getDescription(true), new RunLevelException(e));
                }
            }
            if (lastInterrupt != null) {
                throw lastInterrupt;
            }
            if (error != null) {
                logger.log(LEVEL, "swallowing error - " + error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proceedTo(Integer runLevel, boolean isHardInterrupt) {
        if (null != runLevel && runLevel < -1) {
            throw new IllegalArgumentException();
        }
        Worker worker = this.worker;
        if (worker != null && worker.interrupt(isHardInterrupt, runLevel)) {
            return;
        }
        if (runLevel != null) {
            Object object = this.lock;
            synchronized (object) {
                worker = this.asyncMode ? new AsyncProceedToWorker(runLevel) : new SyncProceedToWorker(runLevel);
                this.worker = worker;
            }
            worker.proceedTo(runLevel);
        }
    }

    protected synchronized Activator getActivator() {
        ArrayList<Object> activators = new ArrayList<Object>();
        for (ServiceHandle serviceHandle : this.allActivators.handleIterator()) {
            if (!this.name.equals(Utilities.getRunLevelControllerName((Descriptor)serviceHandle.getActiveDescriptor()))) continue;
            activators.add(serviceHandle.getService());
        }
        return activators.isEmpty() ? this : (Activator)activators.iterator().next();
    }

    protected synchronized Collection<RunLevelListener> getListeners() {
        ArrayList<RunLevelListener> listeners = new ArrayList<RunLevelListener>();
        for (ServiceHandle serviceHandle : this.allRunLevelListeners.handleIterator()) {
            if (!this.name.equals(Utilities.getRunLevelControllerName((Descriptor)serviceHandle.getActiveDescriptor()))) continue;
            listeners.add((RunLevelListener)serviceHandle.getService());
        }
        return listeners;
    }

    protected synchronized Sorter getSorter() {
        ArrayList<Object> sorters = new ArrayList<Object>();
        for (ServiceHandle serviceHandle : this.allSorters.handleIterator()) {
            if (!this.name.equals(Utilities.getRunLevelControllerName((Descriptor)serviceHandle.getActiveDescriptor()))) continue;
            sorters.add(serviceHandle.getService());
        }
        return sorters.isEmpty() ? null : (Sorter)sorters.iterator().next();
    }

    public static class Interrupt
    extends RuntimeException {
        private Interrupt() {
        }
    }

    private static class RunLevelControllerThread
    extends Thread {
        private RunLevelControllerThread(Runnable r) {
            super(r);
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName() + "-" + System.currentTimeMillis());
        }
    }

    private class AsyncProceedToWorker
    extends Worker {
        private Future<?> activeFuture;

        private AsyncProceedToWorker(int runLevel) {
            super(runLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean interrupt(boolean isHard, Integer runLevel) {
            boolean haveFuture;
            Object object = RunLevelControllerImpl.this.lock;
            synchronized (object) {
                boolean bl = haveFuture = null != this.activeFuture;
                if (haveFuture) {
                    this.activeFuture.cancel(false);
                    this.activeFuture = null;
                }
            }
            if (haveFuture) {
                RunLevelControllerImpl.this.event(this, ListenerEvent.CANCEL, null, isHard);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            super.run();
            Object object = RunLevelControllerImpl.this.lock;
            synchronized (object) {
                this.activeFuture = null;
                this.isHardInterrupt = null;
            }
        }

        @Override
        public void proceedTo(int runLevel) {
            assert (null == this.activeFuture);
            this.activeFuture = RunLevelControllerImpl.this.exec.submit(this);
        }

        @Override
        protected void checkInterrupt(Exception e, ActiveDescriptor<?> descriptor, Boolean isHard) {
            if (RunLevelControllerImpl.this.isCancelled(this)) {
                throw new Interrupt();
            }
            super.checkInterrupt(e, descriptor, isHard);
        }
    }

    private class SyncProceedToWorker
    extends Worker {
        private final Thread activeThread;
        protected Integer nextPlannedAfterInterrupt;
        private boolean cancelIssued;

        private SyncProceedToWorker(int runLevel) {
            super(runLevel);
            this.activeThread = Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean interrupt(boolean isHard, Integer runLevel) {
            Thread ourThread = Thread.currentThread();
            Object object = RunLevelControllerImpl.this.lock;
            synchronized (object) {
                Integer planned = this.getPlannedRunLevel();
                if (!isHard && null != planned && planned.equals(runLevel)) {
                    return true;
                }
                this.nextPlannedAfterInterrupt = runLevel;
                if (ourThread == this.activeThread) {
                    this.checkInterrupt(null, null, isHard);
                } else {
                    logger.log(LEVEL, "Interrupting thread {0} - " + RunLevelControllerImpl.this.getDescription(true), this.activeThread);
                    this.isHardInterrupt = isHard;
                    this.activeThread.interrupt();
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void proceedTo(int runLevel) {
            Object object = RunLevelControllerImpl.this.lock;
            synchronized (object) {
                this.planned = runLevel;
                this.nextPlannedAfterInterrupt = null;
                this.cancelIssued = false;
                this.isHardInterrupt = null;
            }
            try {
                this.run();
            }
            catch (Exception e) {
                this.handleInterruptException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void checkInterrupt(Exception e, ActiveDescriptor<?> descriptor, Boolean isHard) {
            Object object = RunLevelControllerImpl.this.lock;
            synchronized (object) {
                boolean cancelled = RunLevelControllerImpl.this.isCancelled(this);
                if (cancelled || null != this.nextPlannedAfterInterrupt) {
                    if (!cancelled && this.canUpdateProceedTo(this.nextPlannedAfterInterrupt)) {
                        this.planned = this.nextPlannedAfterInterrupt;
                        this.nextPlannedAfterInterrupt = null;
                        e = null;
                    } else {
                        if (!this.cancelIssued) {
                            this.cancelIssued = true;
                            boolean wasHardInterrupt = this.isHardInterrupt(isHard, e);
                            this.isHardInterrupt = null;
                            RunLevelControllerImpl.this.event(this, ListenerEvent.CANCEL, null, wasHardInterrupt);
                        }
                        throw new Interrupt();
                    }
                }
            }
            super.checkInterrupt(e, descriptor, isHard);
        }

        private boolean canUpdateProceedTo(Integer proposed) {
            if (null != this.upSide) {
                Integer planned = this.getPlannedRunLevel();
                Integer active = this.getActivatingRunLevel();
                if (null != planned && null != active && null != proposed) {
                    if (this.upSide.booleanValue() && proposed > active) {
                        return true;
                    }
                    if (!this.upSide.booleanValue() && proposed < active) {
                        return true;
                    }
                }
            }
            return false;
        }

        private void handleInterruptException(Exception e) {
            logger.log(LEVEL, "Interrupt caught - " + RunLevelControllerImpl.this.getDescription(true), e);
            Thread currentThread = Thread.currentThread();
            Integer next = null;
            if (this.activeThread == currentThread) {
                next = this.nextPlannedAfterInterrupt;
            }
            if (null != next) {
                this.proceedTo(next);
            } else {
                logger.log(LEVEL, "swallowing exception - " + RunLevelControllerImpl.this.getDescription(true), new RunLevelException(e));
            }
        }
    }

    private abstract class Worker
    implements Runnable {
        protected volatile Integer planned;
        private Integer activeRunLevel;
        protected Boolean upSide;
        protected Boolean isHardInterrupt;

        protected Worker(int runLevel) {
            this.planned = runLevel;
        }

        @Override
        public void run() {
            logger.log(LEVEL, "proceedTo({0}) - " + RunLevelControllerImpl.this.getDescription(true), this.planned);
            this.upSide = null;
            if (null != this.planned) {
                int current = RunLevelControllerImpl.this.getCurrentRunLevel();
                if (this.planned > current) {
                    this.upSide = true;
                    for (int rl = current + 1; rl <= this.planned; ++rl) {
                        this.upActiveRecorder(rl);
                    }
                } else if (this.planned < current) {
                    this.upSide = false;
                    RunLevelControllerImpl.this.setCurrent(this, current);
                    this.down(current);
                } else {
                    this.upSide = false;
                    this.down(current + 1);
                }
            }
            RunLevelControllerImpl.this.finished(this);
        }

        public abstract boolean interrupt(boolean var1, Integer var2);

        public abstract void proceedTo(int var1);

        public Integer getPlannedRunLevel() {
            return this.planned;
        }

        public Integer getActivatingRunLevel() {
            return this.activeRunLevel;
        }

        protected void checkInterrupt(Exception e, ActiveDescriptor<?> descriptor, Boolean isHard) {
            if (e != null) {
                boolean isHardInterrupt = this.isHardInterrupt(isHard, e);
                if (isHardInterrupt) {
                    RunLevelControllerImpl.this.event(this, ListenerEvent.CANCEL, e, isHardInterrupt);
                } else {
                    RunLevelControllerImpl.this.event(this, ListenerEvent.ERROR, e, isHardInterrupt);
                }
            }
        }

        protected void downActiveRecorder(int runLevel) {
            this.activeRunLevel = runLevel;
            this.deactivateRunLevel(runLevel);
            this.activeRunLevel = runLevel - 1;
            RunLevelControllerImpl.this.setCurrent(this, this.activeRunLevel);
        }

        protected boolean isHardInterrupt(Boolean isHard, Throwable e) {
            if (null != isHard) {
                return isHard;
            }
            return null == this.isHardInterrupt ? false : this.isHardInterrupt;
        }

        private void down(int runLevel) {
            while (runLevel > this.planned) {
                this.downActiveRecorder(runLevel);
                --runLevel;
            }
        }

        private void upActiveRecorder(int runLevel) {
            this.activeRunLevel = runLevel;
            this.activateRunLevel();
            RunLevelControllerImpl.this.setCurrent(this, runLevel);
        }

        private void activateRunLevel() {
            ArrayList activations = new ArrayList();
            IndexedFilter filter = BuilderHelper.createContractFilter((String)RunLevel.class.getName());
            List descriptors = RunLevelControllerImpl.this.serviceLocator.getDescriptors((Filter)filter);
            for (ActiveDescriptor descriptor : descriptors) {
                if (!RunLevelControllerImpl.this.accept(descriptor, this.activeRunLevel)) continue;
                activations.add(descriptor);
            }
            if (!activations.isEmpty()) {
                Sorter sorter;
                if (logger.isLoggable(LEVEL)) {
                    logger.log(LEVEL, "sorting {0}", activations);
                }
                if ((sorter = RunLevelControllerImpl.this.getSorter()) != null) {
                    sorter.sort(activations);
                }
                Activator ia = RunLevelControllerImpl.this.getActivator();
                for (ActiveDescriptor activeDescriptor : activations) {
                    if (logger.isLoggable(LEVEL)) {
                        logger.log(LEVEL, "activating {0} - " + RunLevelControllerImpl.this.getDescription(true), activeDescriptor);
                    }
                    try {
                        ia.activate(activeDescriptor);
                        this.checkInterrupt(null, activeDescriptor, null);
                    }
                    catch (Exception e) {
                        this.checkInterrupt(e, activeDescriptor, null);
                    }
                }
                try {
                    ia.awaitCompletion(3000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    this.checkInterrupt(e, null, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deactivateRunLevel(int runLevel) {
            List<Integer> downRecorders = RunLevelControllerImpl.this.getRecordersToRelease(runLevel);
            for (int current : downRecorders) {
                Stack downRecorder;
                Object object = RunLevelControllerImpl.this.lock;
                synchronized (object) {
                    downRecorder = (Stack)RunLevelControllerImpl.this.recorders.get(current);
                }
                if (downRecorder == null) continue;
                Activator ia = RunLevelControllerImpl.this.getActivator();
                while (!downRecorder.isEmpty()) {
                    ActiveDescriptor descriptor = (ActiveDescriptor)downRecorder.pop();
                    if (logger.isLoggable(LEVEL)) {
                        logger.log(LEVEL, "releasing {0} - " + RunLevelControllerImpl.this.getDescription(true), descriptor);
                    }
                    try {
                        ia.deactivate(descriptor);
                        this.checkInterrupt(null, descriptor, null);
                    }
                    catch (Exception e) {
                        this.checkInterrupt(e, descriptor, null);
                    }
                }
                try {
                    ia.awaitCompletion();
                }
                catch (Exception e) {
                    this.checkInterrupt(e, null, null);
                }
            }
        }
    }

    private static enum ListenerEvent {
        PROGRESS,
        CANCEL,
        ERROR;

    }
}

