/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelController;
import org.glassfish.hk2.runlevel.RunLevelException;
import org.glassfish.hk2.runlevel.utilities.Utilities;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RunLevelContext
implements Context<RunLevel> {
    private final Map<ActiveDescriptor<?>, Object> backingMap = new HashMap();
    @Inject
    private Provider<RunLevelController> runLevelController;

    public Class<? extends Annotation> getScope() {
        return RunLevel.class;
    }

    public <T> T findOrCreate(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) {
        if (this.backingMap.containsKey(activeDescriptor)) {
            return (T)this.backingMap.get(activeDescriptor);
        }
        int mode = Utilities.getRunLevelMode(activeDescriptor);
        if (mode == 1) {
            this.validate(activeDescriptor, (RunLevelController)this.runLevelController.get());
        }
        Object service = activeDescriptor.create(root);
        this.backingMap.put(activeDescriptor, service);
        ((RunLevelController)this.runLevelController.get()).recordActivation(activeDescriptor);
        return (T)service;
    }

    public boolean containsKey(ActiveDescriptor<?> activeDescriptor) {
        return this.backingMap.containsKey(activeDescriptor);
    }

    public boolean isActive() {
        return true;
    }

    public void shutdown() {
    }

    public <T> void deactivate(ActiveDescriptor<T> activeDescriptor) {
        if (this.backingMap.containsKey(activeDescriptor)) {
            activeDescriptor.dispose(this.backingMap.get(activeDescriptor));
            this.backingMap.remove(activeDescriptor);
        }
    }

    private void validate(ActiveDescriptor<?> descriptor, RunLevelController service) throws RunLevelException {
        Integer runLevel = Utilities.getRunLevelValue(descriptor);
        Integer planned = service.getPlannedRunLevel();
        Integer current = service.getCurrentRunLevel();
        if (runLevel > current && (planned == null || runLevel > planned)) {
            throw new RunLevelException("Unable to activate " + descriptor + "; minimum expected RunLevel is: " + runLevel + "; planned is: " + planned + "; current is: " + current + ".");
        }
    }

    public boolean supportsNullCreation() {
        return false;
    }

    public void destroyOne(ActiveDescriptor<?> descriptor) {
    }
}

