/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelFuture;
import org.glassfish.hk2.runlevel.RunLevelListener;
import org.glassfish.hk2.runlevel.internal.AsyncRunLevelContext;
import org.glassfish.hk2.runlevel.utilities.Utilities;

public class CurrentTaskFuture
implements RunLevelFuture {
    private final AsyncRunLevelContext parent;
    private final Executor executor;
    private final ServiceLocator locator;
    private final int proposedLevel;
    private final boolean useThreads;
    private final UpAllTheWay upAllTheWay;
    private final DownAllTheWay downAllTheWay;
    private boolean done = false;
    private boolean cancelled = false;

    CurrentTaskFuture(AsyncRunLevelContext parent, Executor executor, ServiceLocator locator, int proposedLevel, int maxThreads, boolean useThreads) {
        this.parent = parent;
        this.executor = useThreads ? executor : null;
        this.locator = locator;
        this.proposedLevel = proposedLevel;
        this.useThreads = useThreads;
        int currentLevel = parent.getCurrentLevel();
        List allListenerHandles = locator.getAllServiceHandles(RunLevelListener.class, new Annotation[0]);
        if (currentLevel == proposedLevel) {
            this.upAllTheWay = null;
            this.downAllTheWay = null;
            this.done = true;
            parent.jobDone();
        } else if (currentLevel < proposedLevel) {
            this.upAllTheWay = new UpAllTheWay(proposedLevel, this, allListenerHandles, maxThreads, useThreads);
            this.downAllTheWay = null;
        } else {
            this.downAllTheWay = new DownAllTheWay(proposedLevel, this, allListenerHandles);
            this.upAllTheWay = null;
        }
    }

    void go() {
        if (this.upAllTheWay != null) {
            this.upAllTheWay.go();
        } else if (this.downAllTheWay != null) {
            if (this.useThreads) {
                this.executor.execute(this.downAllTheWay);
            } else {
                this.downAllTheWay.run();
            }
        }
    }

    @Override
    public boolean isUp() {
        return this.upAllTheWay != null;
    }

    @Override
    public boolean isDown() {
        return this.downAllTheWay != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            if (this.done) {
                return false;
            }
            if (this.cancelled) {
                return false;
            }
            this.cancelled = true;
            if (this.upAllTheWay != null) {
                this.upAllTheWay.cancel();
            } else if (this.downAllTheWay != null) {
                this.downAllTheWay.cancel();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.done;
        }
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new AssertionError((Object)te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.upAllTheWay != null) {
            try {
                boolean result = this.upAllTheWay.waitForResult(timeout, unit);
                if (!result) {
                    throw new TimeoutException();
                }
                CurrentTaskFuture currentTaskFuture = this;
                synchronized (currentTaskFuture) {
                    this.done = true;
                }
                return null;
            }
            catch (MultiException me) {
                CurrentTaskFuture currentTaskFuture = this;
                synchronized (currentTaskFuture) {
                    this.done = true;
                }
                throw new ExecutionException(me);
            }
        }
        if (this.downAllTheWay != null) {
            try {
                boolean result = this.downAllTheWay.waitForResult(timeout, unit);
                if (!result) {
                    throw new TimeoutException();
                }
                CurrentTaskFuture currentTaskFuture = this;
                synchronized (currentTaskFuture) {
                    this.done = true;
                }
                return null;
            }
            catch (MultiException me) {
                CurrentTaskFuture currentTaskFuture = this;
                synchronized (currentTaskFuture) {
                    this.done = true;
                }
                throw new ExecutionException(me);
            }
        }
        return null;
    }

    private static void invokeOnProgress(RunLevelFuture job, int level, List<ServiceHandle<RunLevelListener>> listeners) {
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                ((RunLevelListener)listener.getService()).onProgress(job, level);
            }
            catch (Throwable th) {}
        }
    }

    private static void invokeOnCancelled(RunLevelFuture job, int levelAchieved, List<ServiceHandle<RunLevelListener>> listeners) {
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                ((RunLevelListener)listener.getService()).onCancelled(job, levelAchieved);
            }
            catch (Throwable th) {}
        }
    }

    private static void invokeOnError(RunLevelFuture job, Throwable th, List<ServiceHandle<RunLevelListener>> listeners) {
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                ((RunLevelListener)listener.getService()).onError(job, th);
            }
            catch (Throwable th2) {}
        }
    }

    @Override
    public int getProposedLevel() {
        return this.proposedLevel;
    }

    public String toString() {
        return "RunLevelFuture(proposedLevel=" + this.proposedLevel + "," + System.identityHashCode(this) + ")";
    }

    private static class QueueRunner
    implements Runnable {
        private final Object queueLock;
        private final List<ServiceHandle<?>> queue;
        private final UpOneJob parent;
        private final Object parentLock;

        private QueueRunner(Object queueLock, List<ServiceHandle<?>> queue, UpOneJob parent, Object parentLock) {
            this.queueLock = queueLock;
            this.queue = queue;
            this.parent = parent;
            this.parentLock = parentLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                ServiceHandle<?> job;
                Object object = this.queueLock;
                synchronized (object) {
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    job = this.queue.remove(0);
                }
                this.oneJob(job);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void oneJob(ServiceHandle<?> fService) {
            try {
                boolean ok;
                Object object = this.parentLock;
                synchronized (object) {
                    ok = !this.parent.cancelled && this.parent.exception == null;
                }
                if (ok) {
                    fService.getService();
                }
            }
            catch (Throwable th) {
                this.parent.fail(th);
            }
            finally {
                this.parent.jobComplete();
            }
        }
    }

    public class DownAllTheWay
    implements Runnable {
        private final int goingTo;
        private final RunLevelFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private int workingOn;
        private boolean cancelled = false;
        private boolean done = false;

        public DownAllTheWay(int goingTo, RunLevelFuture future, List<ServiceHandle<RunLevelListener>> listeners) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.workingOn = future == null ? CurrentTaskFuture.this.parent.getCurrentLevel() + 1 : CurrentTaskFuture.this.parent.getCurrentLevel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                this.cancelled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.workingOn > this.goingTo) {
                DownAllTheWay downAllTheWay = this;
                synchronized (downAllTheWay) {
                    if (this.cancelled) {
                        if (this.future != null) {
                            CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn, this.listeners);
                        }
                        this.done = true;
                        this.notifyAll();
                        return;
                    }
                }
                int proceedingTo = this.workingOn - 1;
                CurrentTaskFuture.this.parent.setCurrentLevel(proceedingTo);
                List<ActiveDescriptor<?>> toRemove = CurrentTaskFuture.this.parent.getOrderedListOfServicesAtLevel(this.workingOn);
                for (ActiveDescriptor<?> removeMe : toRemove) {
                    try {
                        CurrentTaskFuture.this.locator.getServiceHandle(removeMe).destroy();
                    }
                    catch (Throwable th) {
                        if (this.future == null) continue;
                        CurrentTaskFuture.invokeOnError(this.future, th, this.listeners);
                    }
                }
                --this.workingOn;
                if (this.future == null) continue;
                CurrentTaskFuture.invokeOnProgress(this.future, proceedingTo, this.listeners);
            }
            if (this.future == null) {
                return;
            }
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                CurrentTaskFuture.this.parent.jobDone();
                this.done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.wait(totalWaitTimeMillis);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                return this.done;
            }
        }
    }

    private class UpOneJob
    implements Runnable {
        private final Object lock = new Object();
        private final int upToThisLevel;
        private final UpAllTheWay master;
        private final int maxThreads;
        private int numJobs;
        private int completedJobs;
        private MultiException exception = null;
        private boolean cancelled = false;

        private UpOneJob(int paramUpToThisLevel, UpAllTheWay master, int maxThreads) {
            this.upToThisLevel = paramUpToThisLevel;
            this.master = master;
            this.maxThreads = maxThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
            }
        }

        @Override
        public void run() {
            Object jobsLock = new Object();
            List jobs = CurrentTaskFuture.this.locator.getAllServiceHandles((Filter)new IndexedFilter(){

                public boolean matches(Descriptor d) {
                    return UpOneJob.this.upToThisLevel == Utilities.getRunLevelValue(d);
                }

                public String getAdvertisedContract() {
                    return RunLevel.class.getName();
                }

                public String getName() {
                    return null;
                }
            });
            this.numJobs = jobs.size();
            if (this.numJobs <= 0) {
                this.jobComplete();
                return;
            }
            int runnersToCreate = (this.numJobs < this.maxThreads ? this.numJobs : this.maxThreads) - 1;
            if (!CurrentTaskFuture.this.useThreads) {
                runnersToCreate = 0;
            }
            for (int lcv = 0; lcv < runnersToCreate; ++lcv) {
                QueueRunner runner = new QueueRunner(jobsLock, jobs, this, this.lock);
                CurrentTaskFuture.this.executor.execute(runner);
            }
            QueueRunner myRunner = new QueueRunner(jobsLock, jobs, this, this.lock);
            myRunner.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable th) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exception == null) {
                    this.exception = new MultiException(th);
                } else {
                    this.exception.addError(th);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void jobComplete() {
            boolean complete = false;
            Object object = this.lock;
            synchronized (object) {
                ++this.completedJobs;
                if (this.completedJobs >= this.numJobs) {
                    complete = true;
                }
            }
            if (complete) {
                this.master.currentJobComplete(this.exception);
            }
        }
    }

    private class UpAllTheWay {
        private final Object lock = new Object();
        private final int goingTo;
        private final int maxThreads;
        private final boolean useThreads;
        private final RunLevelFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private int workingOn;
        private UpOneJob currentJob;
        private boolean cancelled = false;
        private boolean done = false;
        private MultiException exception = null;

        private UpAllTheWay(int goingTo, RunLevelFuture future, List<ServiceHandle<RunLevelListener>> listeners, int maxThreads, boolean useThreads) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.maxThreads = maxThreads;
            this.useThreads = useThreads;
            this.workingOn = CurrentTaskFuture.this.parent.getCurrentLevel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
                this.currentJob.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            Object object = this.lock;
            synchronized (object) {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.lock.wait(totalWaitTimeMillis);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.done && this.exception != null) {
                    throw this.exception;
                }
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void go() {
            Object object;
            if (this.useThreads) {
                Object object2 = this.lock;
                synchronized (object2) {
                    ++this.workingOn;
                    if (this.workingOn > this.goingTo) {
                        CurrentTaskFuture.this.parent.jobDone();
                        this.done = true;
                        this.lock.notifyAll();
                        return;
                    }
                    this.currentJob = new UpOneJob(this.workingOn, this, this.maxThreads);
                    CurrentTaskFuture.this.executor.execute(this.currentJob);
                    return;
                }
            }
            ++this.workingOn;
            while (this.workingOn <= this.goingTo) {
                object = this.lock;
                synchronized (object) {
                    if (this.done) {
                        break;
                    }
                    this.currentJob = new UpOneJob(this.workingOn, this, this.maxThreads);
                }
                this.currentJob.run();
                ++this.workingOn;
            }
            object = this.lock;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                CurrentTaskFuture.this.parent.jobDone();
                this.done = true;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void currentJobComplete(MultiException exception) {
            DownAllTheWay downer = null;
            if (exception != null) {
                downer = new DownAllTheWay(this.workingOn - 1, null, null);
                downer.run();
                Object object = this.lock;
                synchronized (object) {
                    CurrentTaskFuture.invokeOnError(this.future, (Throwable)exception, this.listeners);
                    this.done = true;
                    this.exception = exception;
                    this.lock.notifyAll();
                    CurrentTaskFuture.this.parent.jobDone();
                }
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                if (this.cancelled) {
                    downer = new DownAllTheWay(this.workingOn - 1, null, null);
                }
            }
            if (downer != null) {
                downer.run();
            }
            object = this.lock;
            synchronized (object) {
                if (downer != null) {
                    CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn - 1, this.listeners);
                    this.done = true;
                    this.lock.notifyAll();
                    CurrentTaskFuture.this.parent.jobDone();
                    return;
                }
                CurrentTaskFuture.this.parent.setCurrentLevel(this.workingOn);
                CurrentTaskFuture.invokeOnProgress(this.future, this.workingOn, this.listeners);
                if (this.useThreads) {
                    this.go();
                }
            }
        }
    }
}

