/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.ChangeableRunLevelFuture;
import org.glassfish.hk2.runlevel.ErrorInformation;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelListener;
import org.glassfish.hk2.runlevel.Sorter;
import org.glassfish.hk2.runlevel.internal.AsyncRunLevelContext;
import org.glassfish.hk2.runlevel.internal.CurrentTaskFutureWrapper;
import org.glassfish.hk2.runlevel.internal.ErrorInformationImpl;
import org.glassfish.hk2.runlevel.internal.WouldBlockException;
import org.glassfish.hk2.runlevel.utilities.Utilities;

public class CurrentTaskFuture
implements ChangeableRunLevelFuture {
    private final AsyncRunLevelContext parent;
    private final Executor executor;
    private final ServiceLocator locator;
    private int proposedLevel;
    private final boolean useThreads;
    private final List<ServiceHandle<RunLevelListener>> allListenerHandles;
    private final List<ServiceHandle<Sorter>> allSorterHandles;
    private final int maxThreads;
    private UpAllTheWay upAllTheWay;
    private DownAllTheWay downAllTheWay;
    private boolean done = false;
    private boolean cancelled = false;
    private boolean inCallback = false;

    CurrentTaskFuture(AsyncRunLevelContext parent, Executor executor, ServiceLocator locator, int proposedLevel, int maxThreads, boolean useThreads) {
        this.parent = parent;
        this.executor = useThreads ? executor : null;
        this.locator = locator;
        this.proposedLevel = proposedLevel;
        this.useThreads = useThreads;
        this.maxThreads = maxThreads;
        int currentLevel = parent.getCurrentLevel();
        this.allListenerHandles = locator.getAllServiceHandles(RunLevelListener.class, new Annotation[0]);
        this.allSorterHandles = locator.getAllServiceHandles(Sorter.class, new Annotation[0]);
        if (currentLevel == proposedLevel) {
            this.done = true;
            parent.jobDone();
        } else if (currentLevel < proposedLevel) {
            this.upAllTheWay = new UpAllTheWay(proposedLevel, this, this.allListenerHandles, this.allSorterHandles, maxThreads, useThreads);
        } else {
            this.downAllTheWay = new DownAllTheWay(proposedLevel, this, this.allListenerHandles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void go() {
        DownAllTheWay localDownAllTheWay;
        UpAllTheWay localUpAllTheWay;
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            localUpAllTheWay = this.upAllTheWay;
            localDownAllTheWay = this.downAllTheWay;
        }
        if (localUpAllTheWay != null) {
            localUpAllTheWay.go();
        } else if (localDownAllTheWay != null) {
            if (this.useThreads) {
                this.executor.execute(localDownAllTheWay);
            } else {
                localDownAllTheWay.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUp() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.upAllTheWay != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDown() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.downAllTheWay != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            if (this.done) {
                return false;
            }
            if (this.cancelled) {
                return false;
            }
            this.cancelled = true;
            if (this.upAllTheWay != null) {
                this.upAllTheWay.cancel();
            } else if (this.downAllTheWay != null) {
                this.downAllTheWay.cancel();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.done;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProposedLevel() {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            return this.proposedLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int changeProposedLevel(int proposedLevel) {
        int oldProposedVal;
        boolean needGo = false;
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            if (this.done) {
                throw new IllegalStateException("Cannot change the proposed level of a future that is already complete");
            }
            if (!this.inCallback) {
                throw new IllegalStateException("changeProposedLevel must only be called from inside a RunLevelListener callback method");
            }
            oldProposedVal = this.proposedLevel;
            int currentLevel = this.parent.getCurrentLevel();
            this.proposedLevel = proposedLevel;
            if (this.upAllTheWay != null) {
                if (currentLevel <= proposedLevel) {
                    this.upAllTheWay.setGoingTo(proposedLevel, false);
                } else {
                    this.upAllTheWay.setGoingTo(currentLevel, true);
                    this.upAllTheWay = null;
                    this.downAllTheWay = new DownAllTheWay(proposedLevel, this, this.allListenerHandles);
                    needGo = true;
                }
            } else if (this.downAllTheWay != null) {
                if (currentLevel >= proposedLevel) {
                    this.downAllTheWay.setGoingTo(proposedLevel, false);
                } else {
                    this.downAllTheWay.setGoingTo(currentLevel, true);
                    this.downAllTheWay = null;
                    this.upAllTheWay = new UpAllTheWay(proposedLevel, this, this.allListenerHandles, this.allSorterHandles, this.maxThreads, this.useThreads);
                    needGo = true;
                }
            } else if (proposedLevel > currentLevel) {
                this.upAllTheWay = new UpAllTheWay(proposedLevel, this, this.allListenerHandles, this.allSorterHandles, this.maxThreads, this.useThreads);
                needGo = true;
            } else if (proposedLevel < currentLevel) {
                this.downAllTheWay = new DownAllTheWay(proposedLevel, this, this.allListenerHandles);
                needGo = true;
            }
        }
        if (needGo) {
            this.go();
        }
        return oldProposedVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInCallback(boolean inCallback) {
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            this.inCallback = inCallback;
        }
    }

    @Override
    public Object get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            throw new AssertionError((Object)te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AllTheWay allTheWay = null;
        CurrentTaskFuture currentTaskFuture = this;
        synchronized (currentTaskFuture) {
            if (this.upAllTheWay != null) {
                allTheWay = this.upAllTheWay;
            } else if (this.downAllTheWay != null) {
                allTheWay = this.downAllTheWay;
            }
        }
        if (allTheWay == null) {
            return null;
        }
        Boolean result = null;
        while (result == null) {
            try {
                CurrentTaskFuture currentTaskFuture2;
                result = allTheWay.waitForResult(timeout, unit);
                if (result == null) {
                    currentTaskFuture2 = this;
                    synchronized (currentTaskFuture2) {
                        if (this.upAllTheWay != null) {
                            allTheWay = this.upAllTheWay;
                        } else if (this.downAllTheWay != null) {
                            allTheWay = this.downAllTheWay;
                        }
                    }
                    if (allTheWay != null) continue;
                    return null;
                }
                if (!result.booleanValue()) {
                    throw new TimeoutException();
                }
                currentTaskFuture2 = this;
                synchronized (currentTaskFuture2) {
                    this.done = true;
                }
                return null;
            }
            catch (MultiException me) {
                CurrentTaskFuture currentTaskFuture3 = this;
                synchronized (currentTaskFuture3) {
                    this.done = true;
                }
                throw new ExecutionException(me);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeOnProgress(ChangeableRunLevelFuture job, int level, List<ServiceHandle<RunLevelListener>> listeners) {
        this.setInCallback(true);
        try {
            for (ServiceHandle<RunLevelListener> listener : listeners) {
                try {
                    ((RunLevelListener)listener.getService()).onProgress(job, level);
                }
                catch (Throwable th) {}
            }
        }
        finally {
            this.setInCallback(false);
        }
    }

    private static void invokeOnCancelled(CurrentTaskFuture job, int levelAchieved, List<ServiceHandle<RunLevelListener>> listeners) {
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                ((RunLevelListener)listener.getService()).onCancelled(new CurrentTaskFutureWrapper(job), levelAchieved);
            }
            catch (Throwable th) {}
        }
    }

    private static ErrorInformation invokeOnError(CurrentTaskFuture job, Throwable th, ErrorInformation.ErrorAction action, List<ServiceHandle<RunLevelListener>> listeners) {
        ErrorInformationImpl errorInfo = new ErrorInformationImpl(th, action);
        for (ServiceHandle<RunLevelListener> listener : listeners) {
            try {
                ((RunLevelListener)listener.getService()).onError(new CurrentTaskFutureWrapper(job), errorInfo);
            }
            catch (Throwable th2) {}
        }
        return errorInfo;
    }

    private static final boolean isWouldBlock(MultiException me) {
        for (Throwable th : me.getErrors()) {
            if (!(th instanceof WouldBlockException)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "RunLevelFuture(proposedLevel=" + this.proposedLevel + "," + System.identityHashCode(this) + ")";
    }

    private static class QueueRunner
    implements Runnable {
        private final Object queueLock;
        private final List<ServiceHandle<?>> queue;
        private final UpOneJob parent;
        private final Object parentLock;
        private final int maxThreads;
        private ServiceHandle<?> wouldHaveBlocked;
        private HashSet<ActiveDescriptor<?>> alreadyTried = new HashSet();

        private QueueRunner(Object queueLock, List<ServiceHandle<?>> queue, UpOneJob parent, Object parentLock, int maxThreads) {
            this.queueLock = queueLock;
            this.queue = queue;
            this.parent = parent;
            this.parentLock = parentLock;
            this.maxThreads = maxThreads;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean didUp = false;
            while (true) {
                ServiceHandle<?> job;
                boolean block;
                Object object = this.queueLock;
                synchronized (object) {
                    if (didUp) {
                        this.parent.jobFinished();
                    }
                    if (this.wouldHaveBlocked != null) {
                        this.alreadyTried.add(this.wouldHaveBlocked.getActiveDescriptor());
                        this.queue.add(this.queue.size(), this.wouldHaveBlocked);
                        this.wouldHaveBlocked = null;
                    }
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    if (this.maxThreads <= 0) {
                        block = true;
                    } else {
                        int currentlyEmptyThreads = this.maxThreads - this.parent.getJobsRunning();
                        boolean bl = block = this.queue.size() <= currentlyEmptyThreads;
                    }
                    if (block) {
                        job = this.queue.remove(0);
                    } else {
                        job = null;
                        for (int lcv = 0; lcv < this.queue.size(); ++lcv) {
                            ActiveDescriptor candidate = this.queue.get(lcv).getActiveDescriptor();
                            if (this.alreadyTried.contains(candidate)) continue;
                            job = this.queue.remove(lcv);
                            break;
                        }
                        if (job == null) {
                            job = this.queue.remove(0);
                            block = true;
                        }
                    }
                    this.parent.jobRunning();
                    didUp = true;
                }
                this.oneJob(job, block);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void oneJob(ServiceHandle<?> fService, boolean block) {
            fService.setServiceData((Object)new Boolean(!block));
            boolean completed = true;
            try {
                boolean ok;
                Object object = this.parentLock;
                synchronized (object) {
                    ok = !this.parent.cancelled && this.parent.exception == null;
                }
                if (ok) {
                    fService.getService();
                }
            }
            catch (MultiException me) {
                if (!block && CurrentTaskFuture.isWouldBlock(me)) {
                    this.wouldHaveBlocked = fService;
                    completed = false;
                } else {
                    this.parent.fail(me);
                }
            }
            catch (Throwable th) {
                this.parent.fail(th);
            }
            finally {
                fService.setServiceData(null);
                if (completed) {
                    this.parent.jobComplete();
                }
            }
        }
    }

    private class DownAllTheWay
    implements Runnable,
    AllTheWay {
        private volatile int goingTo;
        private CurrentTaskFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private int workingOn;
        private boolean cancelled = false;
        private boolean done = false;
        private boolean repurposed = false;

        public DownAllTheWay(int goingTo, CurrentTaskFuture future, List<ServiceHandle<RunLevelListener>> listeners) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.workingOn = future == null ? CurrentTaskFuture.this.parent.getCurrentLevel() + 1 : CurrentTaskFuture.this.parent.getCurrentLevel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                this.cancelled = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setGoingTo(int goingTo, boolean repurposed) {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                this.goingTo = goingTo;
                if (repurposed) {
                    this.repurposed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.workingOn > this.goingTo) {
                boolean runOnCancelled;
                DownAllTheWay downAllTheWay = this;
                synchronized (downAllTheWay) {
                    runOnCancelled = this.cancelled && this.future != null;
                }
                if (runOnCancelled) {
                    CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn, this.listeners);
                }
                downAllTheWay = this;
                synchronized (downAllTheWay) {
                    if (this.cancelled) {
                        this.done = true;
                        this.notifyAll();
                        return;
                    }
                }
                int proceedingTo = this.workingOn - 1;
                CurrentTaskFuture.this.parent.setCurrentLevel(proceedingTo);
                List<ActiveDescriptor<?>> toRemove = CurrentTaskFuture.this.parent.getOrderedListOfServicesAtLevel(this.workingOn);
                ErrorInformation errorInfo = null;
                for (ActiveDescriptor<?> removeMe : toRemove) {
                    try {
                        CurrentTaskFuture.this.locator.getServiceHandle(removeMe).destroy();
                    }
                    catch (Throwable th) {
                        if (this.future == null) continue;
                        errorInfo = CurrentTaskFuture.invokeOnError(this.future, th, ErrorInformation.ErrorAction.IGNORE, this.listeners);
                    }
                }
                if (errorInfo != null && ErrorInformation.ErrorAction.GO_TO_NEXT_LOWER_LEVEL_AND_STOP.equals((Object)errorInfo.getAction())) {
                    this.goingTo = this.workingOn;
                }
                --this.workingOn;
                if (this.future == null) continue;
                CurrentTaskFuture.this.invokeOnProgress(this.future, proceedingTo, this.listeners);
            }
            if (this.future == null) {
                return;
            }
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                if (!this.repurposed) {
                    CurrentTaskFuture.this.parent.jobDone();
                    this.done = true;
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            DownAllTheWay downAllTheWay = this;
            synchronized (downAllTheWay) {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done && !this.repurposed; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.wait(totalWaitTimeMillis);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.repurposed) {
                    return null;
                }
                return this.done;
            }
        }
    }

    private class UpOneJob
    implements Runnable {
        private final Object lock = new Object();
        private final int upToThisLevel;
        private final CurrentTaskFuture currentTaskFuture;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private final List<ServiceHandle<Sorter>> sorters;
        private final UpAllTheWay master;
        private final int maxThreads;
        private int numJobs;
        private int completedJobs;
        private MultiException exception;
        private boolean cancelled = false;
        private int numJobsRunning = 0;

        private UpOneJob(int paramUpToThisLevel, UpAllTheWay master, CurrentTaskFuture currentTaskFuture2, List<ServiceHandle<RunLevelListener>> listeners, List<ServiceHandle<Sorter>> sorters, int maxThreads) {
            this.upToThisLevel = paramUpToThisLevel;
            this.master = master;
            this.maxThreads = maxThreads;
            this.currentTaskFuture = currentTaskFuture2;
            this.listeners = listeners;
            this.sorters = sorters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
            }
        }

        private void jobRunning() {
            ++this.numJobsRunning;
        }

        private void jobFinished() {
            --this.numJobsRunning;
        }

        private int getJobsRunning() {
            return this.numJobsRunning;
        }

        private List<ServiceHandle<?>> applySorters(List<ServiceHandle<?>> jobs) {
            List<ServiceHandle<?>> retVal = jobs;
            for (ServiceHandle<Sorter> sorterHandle : this.sorters) {
                List<ServiceHandle<?>> sortedList;
                Sorter sorter = (Sorter)sorterHandle.getService();
                if (sorter == null || (sortedList = sorter.sort(retVal)) == null) continue;
                retVal = sortedList;
            }
            return retVal;
        }

        @Override
        public void run() {
            Object jobsLock = new Object();
            List<ServiceHandle<?>> jobs = CurrentTaskFuture.this.locator.getAllServiceHandles((Filter)new IndexedFilter(){

                public boolean matches(Descriptor d) {
                    return UpOneJob.this.upToThisLevel == Utilities.getRunLevelValue(d);
                }

                public String getAdvertisedContract() {
                    return RunLevel.class.getName();
                }

                public String getName() {
                    return null;
                }
            });
            jobs = this.applySorters(jobs);
            this.numJobs = jobs.size();
            if (this.numJobs <= 0) {
                this.jobComplete();
                return;
            }
            int runnersToCreate = (this.numJobs < this.maxThreads ? this.numJobs : this.maxThreads) - 1;
            if (!CurrentTaskFuture.this.useThreads) {
                runnersToCreate = 0;
            }
            for (int lcv = 0; lcv < runnersToCreate; ++lcv) {
                QueueRunner runner = new QueueRunner(jobsLock, jobs, this, this.lock, this.maxThreads);
                CurrentTaskFuture.this.executor.execute(runner);
            }
            QueueRunner myRunner = new QueueRunner(jobsLock, jobs, this, this.lock, this.maxThreads);
            myRunner.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fail(Throwable th) {
            Object object = this.lock;
            synchronized (object) {
                ErrorInformation info = CurrentTaskFuture.invokeOnError(this.currentTaskFuture, th, ErrorInformation.ErrorAction.GO_TO_NEXT_LOWER_LEVEL_AND_STOP, this.listeners);
                if (ErrorInformation.ErrorAction.IGNORE.equals((Object)info.getAction())) {
                    return;
                }
                if (this.exception == null) {
                    this.exception = new MultiException();
                }
                this.exception.addError(th);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void jobComplete() {
            boolean complete = false;
            Object object = this.lock;
            synchronized (object) {
                ++this.completedJobs;
                if (this.completedJobs >= this.numJobs) {
                    complete = true;
                }
            }
            if (complete) {
                this.master.currentJobComplete(this.exception);
            }
        }
    }

    private class UpAllTheWay
    implements AllTheWay {
        private final Object lock = new Object();
        private int goingTo;
        private final int maxThreads;
        private final boolean useThreads;
        private final CurrentTaskFuture future;
        private final List<ServiceHandle<RunLevelListener>> listeners;
        private final List<ServiceHandle<Sorter>> sorters;
        private int workingOn;
        private UpOneJob currentJob;
        private boolean cancelled = false;
        private boolean done = false;
        private boolean repurposed = false;
        private MultiException exception = null;

        private UpAllTheWay(int goingTo, CurrentTaskFuture future, List<ServiceHandle<RunLevelListener>> listeners, List<ServiceHandle<Sorter>> sorters, int maxThreads, boolean useThreads) {
            this.goingTo = goingTo;
            this.future = future;
            this.listeners = listeners;
            this.maxThreads = maxThreads;
            this.useThreads = useThreads;
            this.sorters = sorters;
            this.workingOn = CurrentTaskFuture.this.parent.getCurrentLevel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.lock;
            synchronized (object) {
                this.cancelled = true;
                this.currentJob.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean waitForResult(long timeout, TimeUnit unit) throws InterruptedException, MultiException {
            Object object = this.lock;
            synchronized (object) {
                long elapsedTime;
                for (long totalWaitTimeMillis = TimeUnit.MILLISECONDS.convert(timeout, unit); totalWaitTimeMillis > 0L && !this.done && !this.repurposed; totalWaitTimeMillis -= elapsedTime) {
                    long startTime = System.currentTimeMillis();
                    this.lock.wait(totalWaitTimeMillis);
                    elapsedTime = System.currentTimeMillis() - startTime;
                }
                if (this.repurposed) {
                    return null;
                }
                if (this.done && this.exception != null) {
                    throw this.exception;
                }
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setGoingTo(int goingTo, boolean repurposed) {
            Object object = this.lock;
            synchronized (object) {
                this.goingTo = goingTo;
                if (repurposed) {
                    this.repurposed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void go() {
            Object object;
            if (this.useThreads) {
                Object object2 = this.lock;
                synchronized (object2) {
                    ++this.workingOn;
                    if (this.workingOn > this.goingTo) {
                        if (!this.repurposed) {
                            CurrentTaskFuture.this.parent.jobDone();
                            this.done = true;
                        }
                        this.lock.notifyAll();
                        return;
                    }
                    this.currentJob = new UpOneJob(this.workingOn, this, this.future, this.listeners, this.sorters, this.maxThreads);
                    CurrentTaskFuture.this.executor.execute(this.currentJob);
                    return;
                }
            }
            ++this.workingOn;
            while (this.workingOn <= this.goingTo) {
                object = this.lock;
                synchronized (object) {
                    if (this.done) {
                        break;
                    }
                    this.currentJob = new UpOneJob(this.workingOn, this, this.future, this.listeners, this.sorters, 0);
                }
                this.currentJob.run();
                ++this.workingOn;
            }
            object = this.lock;
            synchronized (object) {
                if (this.done) {
                    return;
                }
                if (!this.repurposed) {
                    CurrentTaskFuture.this.parent.jobDone();
                    this.done = true;
                }
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void currentJobComplete(MultiException exception) {
            ErrorInformation info;
            if (exception != null && !ErrorInformation.ErrorAction.IGNORE.equals((Object)(info = CurrentTaskFuture.invokeOnError(this.future, exception, ErrorInformation.ErrorAction.GO_TO_NEXT_LOWER_LEVEL_AND_STOP, this.listeners)).getAction())) {
                DownAllTheWay downer = new DownAllTheWay(this.workingOn - 1, null, null);
                downer.run();
                Object object = this.lock;
                synchronized (object) {
                    this.done = true;
                    this.exception = exception;
                    this.lock.notifyAll();
                    CurrentTaskFuture.this.parent.jobDone();
                }
                return;
            }
            DownAllTheWay downer = null;
            Object object = this.lock;
            synchronized (object) {
                if (this.cancelled) {
                    downer = new DownAllTheWay(this.workingOn - 1, null, null);
                }
            }
            if (downer != null) {
                downer.run();
                CurrentTaskFuture.invokeOnCancelled(this.future, this.workingOn - 1, this.listeners);
                object = this.lock;
                synchronized (object) {
                    this.done = true;
                    this.lock.notifyAll();
                    CurrentTaskFuture.this.parent.jobDone();
                    return;
                }
            }
            CurrentTaskFuture.this.parent.setCurrentLevel(this.workingOn);
            CurrentTaskFuture.this.invokeOnProgress(this.future, this.workingOn, this.listeners);
            if (this.useThreads) {
                this.go();
            }
        }
    }

    private static interface AllTheWay {
        public Boolean waitForResult(long var1, TimeUnit var3) throws InterruptedException, MultiException;
    }
}

