/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.runlevel.CurrentlyRunningException;
import org.glassfish.hk2.runlevel.RunLevelController;
import org.glassfish.hk2.runlevel.RunLevelFuture;
import org.glassfish.hk2.runlevel.internal.AsyncRunLevelContext;
import org.jvnet.hk2.annotations.ContractsProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractsProvided(value={RunLevelController.class})
public class RunLevelControllerImpl
implements RunLevelController {
    @Inject
    private AsyncRunLevelContext context;

    @Override
    public void proceedTo(int runLevel) {
        RunLevelFuture future = this.context.proceedTo(runLevel);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new MultiException((Throwable)e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new MultiException(cause);
        }
    }

    @Override
    public RunLevelFuture proceedToAsync(int runLevel) throws CurrentlyRunningException, IllegalStateException {
        if (this.context.getPolicy().equals((Object)RunLevelController.ThreadingPolicy.USE_NO_THREADS)) {
            throw new IllegalStateException("Cannot use proceedToAsync if the threading policy is USE_NO_THREADS");
        }
        return this.context.proceedTo(runLevel);
    }

    @Override
    public RunLevelFuture getCurrentProceeding() {
        return this.context.getCurrentFuture();
    }

    @Override
    public void cancel() {
        RunLevelFuture rlf = this.getCurrentProceeding();
        if (rlf == null) {
            return;
        }
        rlf.cancel(false);
    }

    @Override
    public int getCurrentRunLevel() {
        return this.context.getCurrentLevel();
    }

    @Override
    public void setMaximumUseableThreads(int maximumThreads) {
        if (maximumThreads < 1) {
            throw new IllegalArgumentException("maximumThreads must be at least 1, but it is " + maximumThreads);
        }
        this.context.setMaximumThreads(maximumThreads);
    }

    @Override
    public int getMaximumUseableThreads() {
        return this.context.getMaximumThreads();
    }

    @Override
    public void setThreadingPolicy(RunLevelController.ThreadingPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException();
        }
        this.context.setPolicy(policy);
    }

    @Override
    public RunLevelController.ThreadingPolicy getThreadingPolicy() {
        return this.context.getPolicy();
    }

    @Override
    public void setExecutor(Executor executor) {
        this.context.setExecutor(executor);
    }

    @Override
    public Executor getExecutor() {
        return this.context.getExecutor();
    }
}

