/*
 * Copyright (c) 2013, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.hk2.runlevel;

/**
 * @author jwells
 *
 */
public interface ChangeableRunLevelFuture extends RunLevelFuture {
    /**
     * Changes the proposedLevel of this future.  A future
     * cannot have its level changed if it is done
     * <p>
     * This method may be called from the {@link RunLevelListener#onProgress(ChangeableRunLevelFuture, int)}
     * callback
     * 
     * @param proposedLevel The new proposed level
     * @return The old proposed level
     * @throws IllegalStateException if this is called on a future that is done
     */
    public int changeProposedLevel(int proposedLevel) throws IllegalStateException;
}
