/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.testing.hk2testng;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.extras.ExtrasUtilities;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.testing.hk2testng.HK2;
import org.testng.IConfigurable;
import org.testng.IConfigureCallBack;
import org.testng.IExecutionListener;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestResult;

public class HK2TestListenerAdapter
implements IExecutionListener,
IHookable,
IConfigurable {
    private static final Map<String, ServiceLocator> serviceLocators = new ConcurrentHashMap<String, ServiceLocator>();
    private static final Map<Class<?>, Object> testClasses = new ConcurrentHashMap();
    private static final Map<Class<?>, Binder> binderClasses = new ConcurrentHashMap();

    public void onExecutionStart() {
    }

    public void onExecutionFinish() {
        for (Map.Entry<String, ServiceLocator> entry : serviceLocators.entrySet()) {
            ServiceLocatorFactory.getInstance().destroy(entry.getValue());
        }
        serviceLocators.clear();
        testClasses.clear();
        binderClasses.clear();
    }

    public void run(IHookCallBack callBack, ITestResult testResult) {
        try {
            this.injectTestInstance(testResult);
            callBack.runTestMethod(testResult);
        }
        catch (InstantiationException e) {
            testResult.setThrowable((Throwable)e);
        }
        catch (IllegalAccessException e) {
            testResult.setThrowable((Throwable)e);
        }
    }

    public void run(IConfigureCallBack callBack, ITestResult testResult) {
        try {
            this.injectTestInstance(testResult);
            callBack.runConfigurationMethod(testResult);
        }
        catch (InstantiationException e) {
            testResult.setThrowable((Throwable)e);
        }
        catch (IllegalAccessException e) {
            testResult.setThrowable((Throwable)e);
        }
    }

    private static void initializeServiceLocator(ServiceLocator locator, HK2 hk2) {
        if (hk2.enableImmediate()) {
            ServiceLocatorUtilities.enableImmediateScope((ServiceLocator)locator);
        }
        if (hk2.enablePerThread()) {
            ServiceLocatorUtilities.enablePerThreadScope((ServiceLocator)locator);
        }
        if (hk2.enableInheritableThread()) {
            ServiceLocatorUtilities.enableInheritableThreadScope((ServiceLocator)locator);
        }
        if (hk2.enableLookupExceptions()) {
            ServiceLocatorUtilities.enableLookupExceptions((ServiceLocator)locator);
        }
        if (hk2.enableEvents()) {
            ExtrasUtilities.enableTopicDistribution((ServiceLocator)locator);
        }
    }

    private void injectTestInstance(ITestResult testResult) throws InstantiationException, IllegalAccessException {
        HK2 hk2;
        ServiceLocator locator = null;
        Object testInstance = testResult.getMethod().getInstance();
        if (testInstance != null && (hk2 = testInstance.getClass().getAnnotation(HK2.class)) != null) {
            String locatorName = hk2.value();
            if ("hk2-testng-locator".equals(locatorName)) {
                locatorName = locatorName + "." + testInstance.getClass().getSimpleName();
            }
            ServiceLocator existingLocator = serviceLocators.get(locatorName);
            if (!testClasses.containsKey(testInstance.getClass())) {
                Class<? extends Binder>[] hk2BinderClasses = hk2.binders();
                if (hk2.populate()) {
                    if (existingLocator == null) {
                        locator = ServiceLocatorUtilities.createAndPopulateServiceLocator((String)locatorName);
                        HK2TestListenerAdapter.initializeServiceLocator(locator, hk2);
                        serviceLocators.put(locator.getName(), locator);
                    } else {
                        locator = existingLocator;
                    }
                }
                if (hk2BinderClasses.length > 0) {
                    Binder[] binders = new Binder[hk2BinderClasses.length];
                    int index = 0;
                    for (Class<? extends Binder> binderClass : hk2BinderClasses) {
                        Binder binder = binderClasses.get(binderClass);
                        if (binder == null) {
                            binder = binderClass.newInstance();
                            binderClasses.put(binderClass, binder);
                        }
                        binders[index++] = binder;
                    }
                    if (locator == null) {
                        if (existingLocator == null) {
                            locator = ServiceLocatorUtilities.bind((String)locatorName, (Binder[])binders);
                            HK2TestListenerAdapter.initializeServiceLocator(locator, hk2);
                            serviceLocators.put(locator.getName(), locator);
                        } else {
                            locator = existingLocator;
                            ServiceLocatorUtilities.bind((ServiceLocator)locator, (Binder[])binders);
                        }
                    } else {
                        ServiceLocatorUtilities.bind((ServiceLocator)locator, (Binder[])binders);
                    }
                }
                if (locator != null) {
                    locator.inject(testInstance);
                }
                testClasses.put(testInstance.getClass(), testInstance);
            }
        }
    }
}

