/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.glassfish.hk2.utilities.cache.Computable;

public class Cache<K, V>
implements Computable<K, V> {
    private final CycleHandler<K> cycleHandler;
    private final ConcurrentHashMap<K, OriginThreadAwareFuture> cache = new ConcurrentHashMap();
    private final Computable<K, V> computable;

    public Cache(Computable<K, V> computable) {
        this(computable, new CycleHandler<K>(){

            @Override
            public void handleCycle(K key) {
            }
        });
    }

    public Cache(Computable<K, V> computable, CycleHandler<K> cycleHandler) {
        this.computable = computable;
        this.cycleHandler = cycleHandler;
    }

    @Override
    public V compute(K key) {
        OriginThreadAwareFuture f = this.cache.get(key);
        if (f == null) {
            OriginThreadAwareFuture ft = new OriginThreadAwareFuture(this, key);
            f = this.cache.putIfAbsent(key, ft);
            if (f == null) {
                f = ft;
                ft.run();
            }
        } else if (Thread.currentThread().getId() == f.threadId) {
            this.cycleHandler.handleCycle(key);
        }
        try {
            return f.get();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        catch (ExecutionException ex) {
            this.cache.remove(key);
            throw new RuntimeException(ex);
        }
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public void remove(K key) {
        this.cache.remove(key);
    }

    private class OriginThreadAwareFuture
    implements Future<V> {
        long threadId = Thread.currentThread().getId();
        final FutureTask<V> future;

        OriginThreadAwareFuture(Cache<K, V> cache2, final K key) {
            Callable eval = new Callable<V>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public V call() throws Exception {
                    try {
                        Object v = Cache.this.computable.compute(key);
                        return v;
                    }
                    finally {
                        OriginThreadAwareFuture.this.threadId = -1L;
                    }
                }
            };
            this.future = new FutureTask(eval);
        }

        public int hashCode() {
            return this.future.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OriginThreadAwareFuture other = (OriginThreadAwareFuture)obj;
            return this.future == other.future || this.future != null && this.future.equals(other.future);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.future.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get(timeout, unit);
        }

        public void run() {
            this.future.run();
        }
    }

    public static interface CycleHandler<K> {
        public void handleCycle(K var1);
    }
}

