/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal.alt.clazz;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.MethodInformationI;
import org.glassfish.hk2.xml.internal.alt.clazz.AnnotationAltAnnotationImpl;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;

public class MethodAltMethodImpl
implements AltMethod {
    private final Method method;
    private final ClassReflectionHelper helper;
    private List<AltClass> parameterTypes;
    private List<AltAnnotation> altAnnotations;
    private MethodInformationI methodInformation;

    public MethodAltMethodImpl(Method method, ClassReflectionHelper helper) {
        this.method = method;
        this.helper = helper;
    }

    public Method getOriginalMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public AltClass getReturnType() {
        Class<Object> retVal = this.method.getReturnType();
        if (retVal == null) {
            retVal = Void.TYPE;
        }
        return new ClassAltClassImpl(retVal, this.helper);
    }

    @Override
    public synchronized List<AltClass> getParameterTypes() {
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        Class<?>[] pTypes = this.method.getParameterTypes();
        ArrayList<ClassAltClassImpl> retVal = new ArrayList<ClassAltClassImpl>(pTypes.length);
        for (Class<?> pType : pTypes) {
            retVal.add(new ClassAltClassImpl(pType, this.helper));
        }
        this.parameterTypes = Collections.unmodifiableList(retVal);
        return this.parameterTypes;
    }

    @Override
    public AltClass getFirstTypeArgument() {
        Type type = this.method.getGenericReturnType();
        if (type == null) {
            return null;
        }
        Type first = ReflectionHelper.getFirstTypeArgument((Type)type);
        if (first == null) {
            return null;
        }
        Class retVal = ReflectionHelper.getRawClass((Type)first);
        if (retVal == null) {
            return null;
        }
        return new ClassAltClassImpl(retVal, this.helper);
    }

    @Override
    public AltClass getFirstTypeArgumentOfParameter(int index) {
        Type[] pTypes = this.method.getGenericParameterTypes();
        Type pType = pTypes[index];
        Type first = ReflectionHelper.getFirstTypeArgument((Type)pType);
        if (first == null) {
            return null;
        }
        Class retVal = ReflectionHelper.getRawClass((Type)first);
        if (retVal == null) {
            return null;
        }
        return new ClassAltClassImpl(retVal, this.helper);
    }

    @Override
    public AltAnnotation getAnnotation(String annotation) {
        Annotation[] annotations;
        if (annotation == null) {
            return null;
        }
        for (Annotation anno : annotations = this.method.getAnnotations()) {
            if (!annotation.equals(anno.annotationType().getName())) continue;
            return new AnnotationAltAnnotationImpl(anno, this.helper);
        }
        return null;
    }

    @Override
    public synchronized List<AltAnnotation> getAnnotations() {
        if (this.altAnnotations != null) {
            return this.altAnnotations;
        }
        Annotation[] annotations = this.method.getAnnotations();
        ArrayList<AnnotationAltAnnotationImpl> retVal = new ArrayList<AnnotationAltAnnotationImpl>(annotations.length);
        for (Annotation annotation : annotations) {
            retVal.add(new AnnotationAltAnnotationImpl(annotation, this.helper));
        }
        this.altAnnotations = Collections.unmodifiableList(retVal);
        return this.altAnnotations;
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    @Override
    public void setMethodInformation(MethodInformationI methodInfo) {
        this.methodInformation = methodInfo;
    }

    @Override
    public MethodInformationI getMethodInformation() {
        return this.methodInformation;
    }

    public String toString() {
        return "MethodAltMethodImpl(" + this.method + "," + System.identityHashCode(this) + ")";
    }
}

