/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.XmlServiceImpl;
import org.glassfish.hk2.xml.internal.XmlStreamImpl;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
@Named(value="StreamXmlParsingService")
@Rank(value=1)
public class DomXmlParser
implements XmlServiceParser {
    private final XMLInputFactory xif = XMLInputFactory.newInstance();
    @Inject
    @Named(value="StreamXmlParsingService")
    private Provider<XmlServiceImpl> xmlService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener, Map<String, Object> options) throws Exception {
        try (InputStream urlStream = location.toURL().openStream();){
            T t = this.parseRoot(rootModel, urlStream, listener, options);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T parseRoot(Model rootModel, InputStream input, Unmarshaller.Listener listener, Map<String, Object> options) throws Exception {
        try (XMLStreamReader xmlStreamReader = this.xif.createXMLStreamReader(input);){
            Object t = XmlStreamImpl.parseRoot((XmlServiceImpl)this.xmlService.get(), rootModel, xmlStreamReader, listener);
            return t;
        }
    }

    @Override
    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.LAZY_PREGENERATION;
    }

    @Override
    public <T> void marshal(OutputStream outputStream, XmlRootHandle<T> root, Map<String, Object> options) throws IOException {
        XmlStreamImpl.marshall(outputStream, root);
    }
}

