/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.xml.internal.Format;
import org.glassfish.hk2.xml.internal.XmlElementData;

public class NameInformation {
    private final Map<String, XmlElementData> nameMapping;
    private final Set<String> noXmlElement;
    private final Map<String, String> addMethodToVariableName;
    private final Map<String, String> removeMethodToVariableName;
    private final Map<String, String> lookupMethodToVariableName;
    private final Set<String> referenceSet;
    private final Map<String, List<XmlElementData>> aliases;
    private final XmlElementData valueData;

    public NameInformation(Map<String, XmlElementData> nameMapping, Set<String> unmappedNames, Map<String, String> addMethodToVariableName, Map<String, String> removeMethodToVariableName, Map<String, String> lookupMethodToVariableName, Set<String> referenceSet, Map<String, List<XmlElementData>> aliases, XmlElementData valueData) {
        this.nameMapping = nameMapping;
        this.noXmlElement = unmappedNames;
        this.addMethodToVariableName = addMethodToVariableName;
        this.removeMethodToVariableName = removeMethodToVariableName;
        this.lookupMethodToVariableName = lookupMethodToVariableName;
        this.referenceSet = referenceSet;
        this.aliases = aliases;
        this.valueData = valueData;
    }

    public String getNamespaceMap(String mapMe) {
        if (mapMe == null) {
            return null;
        }
        if (!this.nameMapping.containsKey(mapMe)) {
            return mapMe;
        }
        return this.nameMapping.get(mapMe).getNamespace();
    }

    public String getNameMap(String mapMe) {
        if (mapMe == null) {
            return null;
        }
        if (!this.nameMapping.containsKey(mapMe)) {
            return mapMe;
        }
        return this.nameMapping.get(mapMe).getName();
    }

    public List<XmlElementData> getAliases(String variableName) {
        return this.aliases.get(variableName);
    }

    public String getDefaultNameMap(String mapMe) {
        if (mapMe == null) {
            return "\u0000";
        }
        if (!this.nameMapping.containsKey(mapMe)) {
            return "\u0000";
        }
        return this.nameMapping.get(mapMe).getDefaultValue();
    }

    public String getXmlWrapperTag(String mapMe) {
        if (mapMe == null) {
            return null;
        }
        if (!this.nameMapping.containsKey(mapMe)) {
            return null;
        }
        return this.nameMapping.get(mapMe).getXmlWrapperTag();
    }

    public boolean hasNoXmlElement(String variableName) {
        if (variableName == null) {
            return true;
        }
        return this.noXmlElement.contains(variableName);
    }

    public boolean isReference(String variableName) {
        if (variableName == null) {
            return false;
        }
        return this.referenceSet.contains(variableName);
    }

    public boolean isRequired(String variableName) {
        if (variableName == null) {
            return false;
        }
        if (!this.nameMapping.containsKey(variableName)) {
            return false;
        }
        return this.nameMapping.get(variableName).isRequired();
    }

    public String getOriginalMethodName(String variableName) {
        if (variableName == null) {
            return null;
        }
        if (!this.nameMapping.containsKey(variableName)) {
            return null;
        }
        return this.nameMapping.get(variableName).getOriginalMethodName();
    }

    public Format getFormat(String variableName) {
        if (variableName == null) {
            return Format.ATTRIBUTE;
        }
        if (this.valueData != null && this.valueData.getName().equals(variableName)) {
            return Format.VALUE;
        }
        if (!this.nameMapping.containsKey(variableName)) {
            return Format.ATTRIBUTE;
        }
        return this.nameMapping.get(variableName).getFormat();
    }

    public String getAddVariableName(String methodName) {
        return this.addMethodToVariableName.get(methodName);
    }

    public String getRemoveVariableName(String methodName) {
        return this.removeMethodToVariableName.get(methodName);
    }

    public String getLookupVariableName(String methodName) {
        return this.lookupMethodToVariableName.get(methodName);
    }

    public String toString() {
        return "NameInformation(nameMapping=" + this.nameMapping + ",noXmlElement=" + this.noXmlElement + ",addMethodToVariableName=" + this.addMethodToVariableName + ",removeMethodToVariableName=" + this.removeMethodToVariableName + ",lookupMethodToVariableName=" + this.lookupMethodToVariableName + ",referenceSet=" + this.referenceSet + ",aliases=" + this.aliases + ",valueData=" + this.valueData + "," + System.identityHashCode(this) + ")";
    }
}

