/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.module.maven;

import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.osgi.Maven2OsgiConverter;

public class OsgiVersionMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String dropVersionComponent;
    protected String versionPropertyName;
    protected Maven2OsgiConverter converter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        DefaultArtifactVersion projectVersion = new DefaultArtifactVersion(this.project.getVersion());
        VERSION_COMPONENT compToDrop = this.dropVersionComponent == null ? null : VERSION_COMPONENT.valueOf(this.dropVersionComponent);
        DefaultArtifactVersion newVersion = projectVersion;
        if (compToDrop != null) {
            switch (compToDrop) {
                case major: {
                    newVersion = new DefaultArtifactVersion("0.0.0");
                    break;
                }
                case minor: {
                    int major = projectVersion.getMajorVersion();
                    newVersion = new DefaultArtifactVersion(major + "");
                    break;
                }
                case micro: {
                    int major = projectVersion.getMajorVersion();
                    int minor = projectVersion.getMinorVersion();
                    newVersion = new DefaultArtifactVersion(major + "." + minor);
                    break;
                }
                case qualifier: {
                    int major = projectVersion.getMajorVersion();
                    int minor = projectVersion.getMinorVersion();
                    int micro = projectVersion.getIncrementalVersion();
                    newVersion = new DefaultArtifactVersion(major + "." + minor + "." + micro);
                    break;
                }
            }
        }
        String v = this.converter.getVersion(newVersion.toString());
        this.getLog().debug((CharSequence)("OSGi Version for " + this.project.getVersion() + " is " + v));
        this.getLog().debug((CharSequence)("It is set in project property called " + this.versionPropertyName));
        this.project.getProperties().put(this.versionPropertyName, v);
    }

    private static enum VERSION_COMPONENT {
        major,
        minor,
        micro,
        qualifier;

    }
}

